/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.emblem.emblematic.Emblematic;
import longevity.emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import longevity.emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import longevity.emblem.exceptions.CouldNotTraverseException;
import longevity.emblem.stringUtil$;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.ptype.Key;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.jdbc.JdbcCreate;
import longevity.persistence.jdbc.JdbcDelete;
import longevity.persistence.jdbc.JdbcId;
import longevity.persistence.jdbc.JdbcPRepo$;
import longevity.persistence.jdbc.JdbcQuery;
import longevity.persistence.jdbc.JdbcQuery$FilterInfo$;
import longevity.persistence.jdbc.JdbcRetrieve;
import longevity.persistence.jdbc.JdbcSchema;
import longevity.persistence.jdbc.JdbcUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import streamadapter.Chunkerator;

@ScalaSignature(bytes="\u0006\u0001\ruf!B\u0001\u0003\u0001\u0011A!!\u0003&eE\u000e\u0004&+\u001a9p\u0015\t\u0019A!\u0001\u0003kI\n\u001c'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\t%\u0001\u0012\u0005J\n\n\u0001)1#&\f\u00194me\u0002Ra\u0003\u0007\u000fA\rj\u0011\u0001B\u0005\u0003\u001b\u0011\u0011Q\u0001\u0015*fa>\u0004\"a\u0004\t\r\u0001\u0011)\u0011\u0003\u0001b\u0001'\t\tai\u0001\u0001\u0016\u0005Qq\u0012CA\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0006\u000f\n\u0005u9\"aA!os\u0012)q\u0004\u0005b\u0001)\t\tq\f\u0005\u0002\u0010C\u0011)!\u0005\u0001b\u0001)\t\tQ\n\u0005\u0002\u0010I\u0011)Q\u0005\u0001b\u0001)\t\t\u0001\u000bE\u0003(Q9\u00013%D\u0001\u0003\u0013\tI#A\u0001\u0006KI\n\u001c7k\u00195f[\u0006\u0004RaJ\u0016\u000fA\rJ!\u0001\f\u0002\u0003\u0015)#'mY\"sK\u0006$X\rE\u0003(]9\u00013%\u0003\u00020\u0005\ta!\n\u001a2d%\u0016$(/[3wKB)q%\r\b!G%\u0011!G\u0001\u0002\n\u0015\u0012\u00147-U;fef\u0004Ra\n\u001b\u000fA\rJ!!\u000e\u0002\u0003\u0015)#'mY+qI\u0006$X\rE\u0003(o9\u00013%\u0003\u00029\u0005\tQ!\n\u001a2d\t\u0016dW\r^3\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001 @\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001!\u0002\u0007\r|W.\u0003\u0002Cw\tYA*\u0019>z\u0019><w-\u001b8h\u0011%!\u0005A!A!\u0002\u0013)%*\u0001\u0004fM\u001a,7\r\u001e\t\u0004\r\"sQ\"A$\u000b\u0005\u00113\u0011BA%H\u0005\u0019)eMZ3di&\u0011A\t\u0004\u0005\n\u0019\u0002\u0011\t\u0011)A\u0005\u001bN\u000b\u0011\"\\8eK2$\u0016\u0010]3\u0011\u00079\u000b\u0006%D\u0001P\u0015\t\u0001f!A\u0003n_\u0012,G.\u0003\u0002S\u001f\nIQj\u001c3fYRK\b/Z\u0005\u0003\u00192A\u0011\"\u0016\u0001\u0003\u0002\u0003\u0006IAV-\u0002\u000bA$\u0016\u0010]3\u0011\t9;\u0006eI\u0005\u00031>\u0013Q\u0001\u0015+za\u0016L!!\u0016\u0007\t\u0011m\u0003!Q1A\u0005\u0012q\u000b\u0011\u0003]3sg&\u001cH/\u001a8dK\u000e{gNZ5h+\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011\u0007\u0003\u0019\u0019wN\u001c4jO&\u0011!m\u0018\u0002\u0012!\u0016\u00148/[:uK:\u001cWmQ8oM&<\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B/\u0002%A,'o]5ti\u0016t7-Z\"p]\u001aLw\r\t\u0005\tM\u0002\u0011)\u0019!C\tO\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003!\u00042AF5l\u0013\tQwCA\u0005Gk:\u001cG/[8oaA\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0004gFd'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014!bQ8o]\u0016\u001cG/[8o\u0011!!\bA!A!\u0002\u0013A\u0017aC2p]:,7\r^5p]\u0002BaA\u001e\u0001\u0005\u0002\u00119\u0018A\u0002\u001fj]&$h\b\u0006\u0004ysj\\H0 \t\u0006O\u0001q\u0001e\t\u0005\u0006\tV\u0004\r!\u0012\u0005\u0006\u0019V\u0004\r!\u0014\u0005\u0006+V\u0004\rA\u0016\u0005\u00067V\u0004\r!\u0018\u0005\u0006MV\u0004\r\u0001\u001b\u0005\n\u007f\u0002\u0011\r\u0011\"\u0005\u0003\u0003\u0003\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003'qA!a\u0002\u0002\u0010A\u0019\u0011\u0011B\f\u000e\u0005\u0005-!bAA\u0007%\u00051AH]8pizJ1!!\u0005\u0018\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011C\f\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u0007\t!\u0002^1cY\u0016t\u0015-\\3!\u0011%\ty\u0002\u0001b\u0001\n#\t\t#A\nqCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002$A1\u0011QEA\u0016\u0003_i!!a\n\u000b\u0007\u0005%r#\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002(\t\u00191+Z91\r\u0005E\u0012qHA(!%\t\u0019$!\u000f$\u0003{\ti%\u0004\u0002\u00026)\u0019\u0011qG(\u0002\u0011I,\u0017\r\\5{K\u0012LA!a\u000f\u00026\t)\"+Z1mSj,G\r\u0015:pa\u000e{W\u000e]8oK:$\bcA\b\u0002@\u0011Y\u0011\u0011IA\"\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\ryF%\r\u0005\u000b\u0003\u000b\n9%!A\u0001\u0002\u0005-\u0013\u0001\u0003\u0013b]>tg-\u001e8\t\u0011\u0005%\u0003\u0001)A\u0005\u0003G\tA\u0003]1si&$\u0018n\u001c8D_6\u0004xN\\3oiN\u00043\u0002\u0001\t\u0004\u001f\u0005=CaCA)\u0003\u0007\n\t\u0011!A\u0003\u0002Q\u00111a\u0018\u00133\u0011%\t)\u0006\u0001b\u0001\n#\t9&A\fq_N$\b+\u0019:uSRLwN\\\"p[B|g.\u001a8ugV\u0011\u0011\u0011\f\t\u0007\u0003K\tY#a\u00171\r\u0005u\u0013\u0011MA7!%\t\u0019$!\u000f$\u0003?\nY\u0007E\u0002\u0010\u0003C\"1\"a\u0019\u0002f\u0005\u0005\t\u0011!B\u0001)\t\u0019q\fJ\u001a\t\u0015\u0005\u0015\u0013qMA\u0001\u0002\u0003\tY\u0005\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA-\u0003a\u0001xn\u001d;QCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8\u000f\t\t\u0004\u001f\u00055DaCA8\u0003K\n\t\u0011!A\u0003\u0002Q\u00111a\u0018\u00135\u0011%\t\u0019\b\u0001b\u0001\n#\t\t#\u0001\u000bqe&l\u0017M]=LKf\u001cu.\u001c9p]\u0016tGo\u001d\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002$\u0005)\u0002O]5nCJL8*Z=D_6\u0004xN\\3oiN\u0004\u0003\"CA>\u0001\t\u0007I\u0011CA?\u0003Q\t7\r^;bY&TX\rZ\"p[B|g.\u001a8ugV\u0011\u0011q\u0010\t\u0007\u0003\u0003\u000b9)a#\u000e\u0005\u0005\r%\u0002BAC\u0003O\t\u0011\"[7nkR\f'\r\\3\n\t\u0005%\u00151\u0011\u0002\u0004'\u0016$\b\u0007CAG\u0003#\u000b\u0019+!+\u0011\u0015\u0005M\u0012\u0011HAH\u0003C\u000b9\u000bE\u0002\u0010\u0003##A\"a%\u0002\u0016\u0006\u0005\t\u0011!B\u0001\u0003?\u00131a\u0018\u00139\u0011!\t9\n\u0001C\t\u0005\u0005e\u0015!E5oI\u0016DX\rZ\"p[B|g.\u001a8ugV\u0011\u00111\u0014\t\u0007\u0003\u000b\ti*a#\n\t\u0005%\u0015qC\t\u0003Gm\u00012aDAR\t-\t)+!&\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}#\u0013\bE\u0002\u0010\u0003S#1\"a+\u0002\u0016\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u00191\u0011!\ty\u000b\u0001Q\u0001\n\u0005}\u0014!F1diV\fG.\u001b>fI\u000e{W\u000e]8oK:$8\u000f\t\u0005\n\u0003g\u0003!\u0019!C\t\u0003k\u000b!$Z7cY\u0016l\u0017\r^5d)>T5o\u001c8Ue\u0006t7\u000f\\1u_J,\"!a.\u0011\t\u0005e\u00161Z\u0007\u0003\u0003wSA!!0\u0002@\u0006!1/\u001f8d\u0015\u0011\t\t-a1\u0002\u0015Q\u0014\u0018M^3sg>\u00148O\u0003\u0003\u0002F\u0006\u001d\u0017AC3nE2,W.\u0019;jG*\u0019\u0011\u0011\u001a\u0004\u0002\r\u0015l'\r\\3n\u0013\u0011\ti-a/\u00035\u0015k'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:\t\u0011\u0005E\u0007\u0001)A\u0005\u0003o\u000b1$Z7cY\u0016l\u0017\r^5d)>T5o\u001c8Ue\u0006t7\u000f\\1u_J\u0004\u0003\"CAk\u0001\t\u0007I\u0011CAl\u0003iQ7o\u001c8U_\u0016k'\r\\3nCRL7\r\u0016:b]Nd\u0017\r^8s+\t\tI\u000e\u0005\u0003\u0002:\u0006m\u0017\u0002BAo\u0003w\u0013!DS:p]R{W)\u001c2mK6\fG/[2Ue\u0006t7\u000f\\1u_JD\u0001\"!9\u0001A\u0003%\u0011\u0011\\\u0001\u001cUN|g\u000eV8F[\ndW-\\1uS\u000e$&/\u00198tY\u0006$xN\u001d\u0011\t\u000f\u0005\u0015\b\u0001\"\u0005\u0002h\u0006Q1m\u001c7v[:t\u0015-\\3\u0015\t\u0005%\u00181\u001f\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*\u0019\u0011q^8\u0002\t1\fgnZ\u0005\u0005\u0003+\ti\u000f\u0003\u0005\u0002v\u0006\r\b\u0019AA|\u0003\u0011\u0001(o\u001c91\u0011\u0005e\u0018Q B\u0002\u0005\u0013\u0001\"\"a\r\u0002:\u0005m(\u0011\u0001B\u0004!\ry\u0011Q \u0003\f\u0003\u007f\f\u00190!A\u0001\u0002\u000b\u0005AC\u0001\u0003`IEJ\u0004cA\b\u0003\u0004\u0011Y!QAAz\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yFE\r\u0019\u0011\u0007=\u0011I\u0001B\u0006\u0003\f\u0005M\u0018\u0011!A\u0001\u0006\u0003!\"\u0001B0%eEBqAa\u0004\u0001\t#\u0011\t\"\u0001\u0006tG>\u0014X\r\u001a)bi\"$B!!;\u0003\u0014!A\u0011Q\u001fB\u0007\u0001\u0004\u0011)\u0002\r\u0005\u0003\u0018\tm!\u0011\u0005B\u0014!)\t\u0019$!\u000f\u0003\u001a\t}!Q\u0005\t\u0004\u001f\tmAa\u0003B\u000f\u0005'\t\t\u0011!A\u0003\u0002Q\u0011Aa\u0018\u00133eA\u0019qB!\t\u0005\u0017\t\r\"1CA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u00124\u0007E\u0002\u0010\u0005O!1B!\u000b\u0003\u0014\u0005\u0005\t\u0011!B\u0001)\t!q\f\n\u001a5\u0011\u001d\u0011i\u0003\u0001C\t\u0005_\taB[:p]N#(/\u001b8h\r>\u0014\b\u000b\u0006\u0003\u0002\u0004\tE\u0002b\u0002B\u001a\u0005W\u0001\raI\u0001\u0002a\"9!q\u0007\u0001\u0005\u0012\te\u0012!E;qI\u0006$XmQ8mk6tg*Y7fgR!!1\bB&!\u0019\u0011iDa\u0012\u0002\u00049!!q\bB\"\u001d\u0011\tIA!\u0011\n\u0003aI1A!\u0012\u0018\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\f\u0003J)\u0019!QI\f\t\u0015\t5#Q\u0007I\u0001\u0002\u0004\u0011y%\u0001\u0005jg\u000e\u0013X-\u0019;f!\r1\"\u0011K\u0005\u0004\u0005':\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005/\u0002A\u0011\u0003B-\u0003I)\b\u000fZ1uK\u000e{G.^7o-\u0006dW/Z:\u0015\r\tm#1\rB7!\u0019\u0011iDa\u0012\u0003^A\u0019aCa\u0018\n\u0007\t\u0005tC\u0001\u0004B]f\u0014VM\u001a\u0005\t\u0005K\u0012)\u00061\u0001\u0003h\u0005)1\u000f^1uKB!1B!\u001b$\u0013\r\u0011Y\u0007\u0002\u0002\u0007!N#\u0018\r^3\t\u0015\t5#Q\u000bI\u0001\u0002\u0004\u0011y\u0005C\u0004\u0003r\u0001!\tBa\u001d\u0002\tU,\u0018\u000e\u001a\u000b\u0005\u0005k\u0012\t\t\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011Yh\\\u0001\u0005kRLG.\u0003\u0003\u0003\u0000\te$\u0001B+V\u0013\u0012C\u0001B!\u001a\u0003p\u0001\u0007!q\r\u0005\b\u0005\u000b\u0003A\u0011CA\u0001\u0003A9\b.\u001a:f\u0003N\u001c\u0018n\u001a8nK:$8\u000fC\u0004\u0003\n\u0002!\tBa#\u0002\u001b]DWM]3CS:$\u0017N\\4t)\u0011\u0011iIa$\u0011\r\u0005\u0015\u00121\u0006B/\u0011!\u0011)Ga\"A\u0002\t\u001d\u0004b\u0002BJ\u0001\u0011%!QS\u0001\u000faJ|\u0007OV1m\u0005&tG-\u001b8h+\u0019\u00119Ja)\u00030R1!Q\fBM\u0005gC\u0001Ba'\u0003\u0012\u0002\u0007!QT\u0001\nG>l\u0007o\u001c8f]R\u0004DAa(\u0003*BQ\u00111GA\u001d\u0005C\u00139K!,\u0011\u0007=\u0011\u0019\u000b\u0002\u0005\u0003&\nE%\u0019AAP\u0005\t\u0001\u0006\u000bE\u0002\u0010\u0005S#1Ba+\u0003\u001a\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u001a2!\ry!q\u0016\u0003\b\u0005c\u0013\tJ1\u0001\u0015\u0005\u0005\t\u0005b\u0002B\u001a\u0005#\u0003\ra\t\u0005\b\u0005o\u0003A\u0011\u0003B]\u0003%QGMY2WC2,X\r\u0006\u0003\u0003^\tm\u0006b\u0002B_\u0005k\u0003\raG\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005\u0003\u0004A\u0011\u0003Bb\u0003!QGMY2ECR,G\u0003\u0002Bc\u0005\u0017\u0004BAa\u001e\u0003H&!!\u0011\u001aB=\u0005\u0011!\u0015\r^3\t\u0011\t5'q\u0018a\u0001\u0005\u001f\f\u0011\u0001\u001a\t\u0005\u0005#\u0014y.\u0004\u0002\u0003T*!!Q\u001bBl\u0003\u0011!\u0018.\\3\u000b\t\te'1\\\u0001\u0005U>$\u0017M\u0003\u0002\u0003^\u0006\u0019qN]4\n\t\t\u0005(1\u001b\u0002\t\t\u0006$X\rV5nK\"9!Q\u001d\u0001\u0005\u0012\t\u001d\u0018!\u0006:fiJLWM^3Ge>l'+Z:vYR\u001cV\r\u001e\u000b\u0005\u0005O\u0012I\u000f\u0003\u0005\u0003l\n\r\b\u0019\u0001Bw\u0003%\u0011Xm];miN+G\u000fE\u0002m\u0005_L1A!=n\u0005%\u0011Vm];miN+G\u000fC\u0004\u0003v\u0002!\tBa>\u00029\r|gN^3si\u0012+\b\u000f\\5dCR,7*Z=Fq\u000e,\u0007\u000f^5p]R!!\u0011`B\u0006!\u001d1\"1 B\u0000\u0007\u000bI1A!@\u0018\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0003\u0002B\u001f\u0007\u0003IAaa\u0001\u0003J\tIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0004-\r\u001d\u0011bAB\u0005/\t!QK\\5u\u0011!\u0011)Ga=A\u0002\t\u001d\u0004bBB\b\u0001\u0011\u00053\u0011C\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0001\u0005\n\u0007+\u0001\u0011\u0013!C\t\u0007/\t1$\u001e9eCR,7i\u001c7v[:t\u0015-\\3tI\u0011,g-Y;mi\u0012\nTCAB\rU\u0011\u0011yea\u0007,\u0005\ru\u0001\u0003BB\u0010\u0007Si!a!\t\u000b\t\r\r2QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\n\u0018\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007W\u0019\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba\f\u0001#\u0003%\tba\u0006\u00029U\u0004H-\u0019;f\u0007>dW/\u001c8WC2,Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%e!i11\u0007\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u00046M\u000bqb];qKJ$Sn\u001c3fYRK\b/Z\u000b\u0002\u001b\u001eA1\u0011\b\u0002\t\u0002\u0011\u0019Y$A\u0005KI\n\u001c\u0007KU3q_B\u0019qe!\u0010\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0004@M!1Q\bB/\u0011\u001d18Q\bC\u0001\u0007\u0007\"\"aa\u000f\t\u0011\r\u001d3Q\bC\u0001\u0007\u0013\nQ!\u00199qYf,\u0002ba\u0013\u0004R\re3Q\f\u000b\u000f\u0007\u001b\u001ayfa\u0019\u0004h\r-4QNBL!!9\u0003aa\u0014\u0004X\rm\u0003cA\b\u0004R\u00119\u0011c!\u0012C\u0002\rMSc\u0001\u000b\u0004V\u00111qd!\u0015C\u0002Q\u00012aDB-\t\u0019\u00113Q\tb\u0001)A\u0019qb!\u0018\u0005\r\u0015\u001a)E1\u0001\u0015\u0011\u001d!5Q\ta\u0001\u0007C\u0002BA\u0012%\u0004P!9Aj!\u0012A\u0002\r\u0015\u0004\u0003\u0002(R\u0007/Bq!VB#\u0001\u0004\u0019I\u0007\u0005\u0004O/\u000e]31\f\u0005\u0007A\u000e\u0015\u0003\u0019A/\t\u0011\r=4Q\ta\u0001\u0007c\n1\u0002]8msJ+\u0007o\\(qiB)aca\u001d\u0004x%\u00191QO\f\u0003\r=\u0003H/[8oa\u0011\u0019Ih! \u0011\u0011\u001d\u00021qJB,\u0007w\u00022aDB?\t1\u0019yh!!\u0002\u0002\u0003\u0005)\u0011ABK\u0005\u0011yFe\r\u001a\t\u0011\r=4Q\ta\u0001\u0007\u0007\u0003RAFB:\u0007\u000b\u0003Daa\"\u0004\u0010BAq\u0005ABE\u0007\u0017\u001bi\tE\u0002\u0010\u0007#\u00022aDB-!\ry1q\u0012\u0003\r\u0007\u007f\u001a\t)!A\u0001\u0002\u000b\u00051\u0011S\t\u0004\u0007'[\u0002cA\b\u0004^E\u001911L\u000e\t\r\u0019\u001c)\u00051\u0001i\u0011-\u0019Yj!\u0010C\u0002\u0013\u0005!a!(\u0002\u001f\t\f7/[2U_*#'m\u0019+za\u0016,\"aa(\u0011\u0011\u0005\u00055\u0011UBS\u0003SLAaa)\u0002\u0004\n\u0019Q*\u001991\t\r\u001d6Q\u0017\t\u0007\u0007S\u001byka-\u000e\u0005\r-&BABW\u0003\u001d!\u0018\u0010]3lKfLAa!-\u0004,\n9A+\u001f9f\u0017\u0016L\bcA\b\u00046\u0012Y1qWB]\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yFeM\u001a\t\u0013\rm6Q\bQ\u0001\n\r}\u0015\u0001\u00052bg&\u001cGk\u001c&eE\u000e$\u0016\u0010]3!\u0001")
public class JdbcPRepo<F, M, P>
extends PRepo<F, M, P>
implements JdbcSchema<F, M, P>,
JdbcCreate<F, M, P>,
JdbcRetrieve<F, M, P>,
JdbcQuery<F, M, P>,
JdbcUpdate<F, M, P>,
JdbcDelete<F, M, P>,
LazyLogging {
    private final PersistenceConfig persistenceConfig;
    private final Function0<Connection> connection;
    private final String tableName;
    private final Seq<RealizedPropComponent<P, ?, ?>> partitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private Logger logger;
    private volatile JdbcQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    private String longevity$persistence$jdbc$JdbcCreate$$insertSql;
    private volatile byte bitmap$0;

    public static <F, M, P> JdbcPRepo<F, M, P> apply(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Option<JdbcPRepo<F, M, ? super P>> option, Function0<Connection> function0) {
        return JdbcPRepo$.MODULE$.apply(effect, modelType, pType, persistenceConfig, option, function0);
    }

    @Override
    public F delete(PState<P> state) {
        return (F)JdbcDelete.delete$(this, state);
    }

    @Override
    public F update(PState<P> state) {
        return (F)JdbcUpdate.update$(this, state);
    }

    @Override
    public Chunkerator<PState<P>> queryToChunkerator(Query<P> query) {
        return JdbcQuery.queryToChunkerator$(this, query);
    }

    @Override
    public String queryWhereClause(JdbcQuery.FilterInfo filterInfo) {
        return JdbcQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V> F retrieve(V keyVal2, Key<M, P, V> evidence$1) {
        return (F)JdbcRetrieve.retrieve$(this, keyVal2, evidence$1);
    }

    @Override
    public Option<PState<P>> retrieveFromPreparedStatement(PreparedStatement statement) {
        return JdbcRetrieve.retrieveFromPreparedStatement$(this, statement);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<M, P, ?> key) {
        return JdbcRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public F create(P p) {
        return (F)JdbcCreate.create$(this, p);
    }

    @Override
    public void createSchemaBlocking() {
        JdbcSchema.createSchemaBlocking$(this);
    }

    @Override
    public void createTable() {
        JdbcSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        JdbcSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToJdbcType(RealizedPropComponent<? super P, ?, A> component2) {
        return JdbcSchema.componentToJdbcType$(this, component2);
    }

    @Override
    public void createUniqueIndexes() {
        JdbcSchema.createUniqueIndexes$(this);
    }

    @Override
    public void createNonUniqueIndexes() {
        JdbcSchema.createNonUniqueIndexes$(this);
    }

    @Override
    public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        JdbcSchema.createIndex$(this, unique, indexName, columnNames);
    }

    private Logger logger$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public JdbcQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement = JdbcRetrieve.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    @Override
    public Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() : this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    private String longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.longevity$persistence$jdbc$JdbcCreate$$insertSql = JdbcCreate.longevity$persistence$jdbc$JdbcCreate$$insertSql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    @Override
    public String longevity$persistence$jdbc$JdbcCreate$$insertSql() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() : this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    public /* synthetic */ ModelType longevity$persistence$jdbc$JdbcPRepo$$super$modelType() {
        return super.modelType();
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public Function0<Connection> connection() {
        return this.connection;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> partitionComponents() {
        return this.partitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents() {
        return this.postPartitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents() {
        return this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JdbcPRepo.$anonfun$indexedComponents$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$6 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$6), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$21 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$21);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$21, x$22));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), e);
        }
        return string;
    }

    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        String string = "p";
        Seq withP = (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            String string2 = "created_timestamp";
            String string3 = "updated_timestamp";
            seq3 = (Seq)((SeqLike)withP.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            String string4 = "row_version";
            seq2 = (Seq)withDateTimes.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            String string5 = "id";
            seq = (Seq)withRowVersion.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        String string = this.jsonStringForP(state.get());
        Seq withP = (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            Object object = state.createdTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            Object object2 = state.updatedTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            seq3 = (Seq)((SeqLike)withP.$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            Object object = state.rowVersionOrNull();
            seq2 = (Seq)withDateTimes.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            UUID uUID = this.uuid(state);
            seq = (Seq)withRowVersion.$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((JdbcId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((JdbcId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.jdbcValue(component2.outerPropPath().get().apply(p));
    }

    public Object jdbcValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.jdbcDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date jdbcDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromResultSet(ResultSet resultSet) {
        Tuple2 tuple2;
        None$ id = !this.hasPrimaryKey() ? new Some(new JdbcId(UUID.fromString(resultSet.getString("id")))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)resultSet.getLong("row_version"))) : None$.MODULE$;
        Tuple2 tuple22 = tuple2 = this.persistenceConfig().writeTimestamps() ? new Tuple2((Object)JdbcPRepo.toOptDateTime$1("created_timestamp", resultSet), (Object)JdbcPRepo.toOptDateTime$1("updated_timestamp", resultSet)) : new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option createdTimestamp = (Option)tuple2._1();
        Option updatedTimestamp = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createdTimestamp, (Object)updatedTimestamp);
        Tuple2 tuple24 = tuple23;
        Option createdTimestamp2 = (Option)tuple24._1();
        Option updatedTimestamp2 = (Option)tuple24._2();
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(resultSet.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply(id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp2, (Option<DateTime>)updatedTimestamp2, p);
    }

    public PartialFunction<Throwable, BoxedUnit> convertDuplicateKeyException(PState<P> state) {
        return PartialFunction$.MODULE$.empty();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JdbcPRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new JdbcQuery$FilterInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$3) {
        return x$3 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Option toOptDateTime$1(String c, ResultSet resultSet$1) {
        return Option$.MODULE$.apply((Object)resultSet$1.getDate(c)).map((Function1 & Serializable & scala.Serializable)x$19 -> new DateTime(x$19, DateTimeZone.UTC));
    }

    public JdbcPRepo(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Function0<Connection> connection) {
        Seq seq;
        Seq seq2;
        this.persistenceConfig = persistenceConfig;
        this.connection = connection;
        super(effect, modelType, pType);
        JdbcSchema.$init$(this);
        JdbcCreate.$init$(this);
        JdbcRetrieve.$init$(this);
        JdbcQuery.$init$(this);
        JdbcUpdate.$init$(this);
        JdbcDelete.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.tableName = stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
        Option option = this.realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq2 = (Seq)key.partitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        this.partitionComponents = seq2;
        Option option2 = this.realizedPType().primaryKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq = (Seq)key.postPartitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        this.postPartitionComponents = seq;
        this.primaryKeyComponents = (Seq)this.partitionComponents().$plus$plus(this.postPartitionComponents(), Seq$.MODULE$.canBuildFrom());
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
    }
}

