/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.jdbc.JdbcRepo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C.\u0003\u0015)#'mY+qI\u0006$XM\u0003\u0002\u0004\t\u0005!!\u000e\u001a2d\u0015\t)a!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"A\u0004\u0002\u00131|gnZ3wSRLXcA\u0005ZOM\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011A\n\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012\u0001\u0006\t\u0003\u0017UI!A\u0006\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u00061\u0001!\t%G\u0001\u0007kB$\u0017\r^3\u0015\u0005i)DCA\u000e1!\rar$I\u0007\u0002;)\u0011a\u0004D\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u0011\u001e\u0005\u00191U\u000f^;sKB\u0019!eI\u0013\u000e\u0003\u0011I!\u0001\n\u0003\u0003\rA\u001bF/\u0019;f!\t1s\u0005\u0004\u0001\u0005\u000b!\u0002!\u0019A\u0015\u0003\u0003A\u000b\"AK\u0017\u0011\u0005-Y\u0013B\u0001\u0017\r\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u0003\u0018\n\u0005=b!aA!os\")\u0011g\u0006a\u0002e\u000591m\u001c8uKb$\bC\u0001\u000f4\u0013\t!TD\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")ag\u0006a\u0001C\u0005)1\u000f^1uK\")\u0001\b\u0001C\u0005s\u0005\u0019\"-\u001b8e+B$\u0017\r^3Ti\u0006$X-\\3oiR\u0019!HQ\"\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aA:rY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\u0006m]\u0002\r!\t\u0005\u0006\t^\u0002\rAC\u0001\u000be><h+\u001a:tS>t\u0007\"\u0002$\u0001\t\u00139\u0015!C;qI\u0006$XmU9m+\u0005A\u0005CA%Q\u001d\tQe\n\u0005\u0002L\u00195\tAJ\u0003\u0002N%\u00051AH]8pizJ!a\u0014\u0007\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f2AQ\u0001\u0016\u0001\u0005\n\u001d\u000b\u0011cY8mk6t\u0017i]:jO:lWM\u001c;t\u0011\u00151\u0006\u0001\"\u0003H\u0003]9\u0018\u000e\u001e5pkRdunY6j]\u001e,\u0006\u000fZ1uKN\u000bH\u000eC\u0003Y\u0001\u0011%q)\u0001\u000bxSRDGj\\2lS:<W\u000b\u001d3bi\u0016\u001c\u0016\u000f\u001c\u0003\u00065\u0002\u0011\r!\u000b\u0002\u0002\u001bB!A,X0&\u001b\u0005\u0011\u0011B\u00010\u0003\u0005!QEMY2SKB|\u0007C\u0001\u0014Z\u0001")
public interface JdbcUpdate<M, P> {
    public static /* synthetic */ Future update$(JdbcUpdate $this, PState state, ExecutionContext context) {
        return $this.update(state, context);
    }

    default public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling JdbcRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((PRepo)((Object)this)).validateStablePrimaryKey(state);
            PState newState = state.update(((JdbcRepo)this).persistenceConfig().optimisticLocking(), ((JdbcRepo)this).persistenceConfig().writeTimestamps());
            Object rowCount = package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                try {
                    PreparedStatement stmt = this.bindUpdateStatement(newState, state.rowVersionOrNull());
                    object = BoxesRunTime.boxToInteger((int)stmt.executeUpdate());
                }
                catch (Throwable x$1) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr$1 = ((JdbcRepo)this).convertDuplicateKeyException(newState);
                    if (catchExpr$1.isDefinedAt((Object)x$1)) {
                        object = catchExpr$1.apply((Object)x$1);
                    }
                    throw x$1;
                }
                return object;
            });
            if (((JdbcRepo)this).persistenceConfig().optimisticLocking() && !BoxesRunTime.equals((Object)rowCount, (Object)BoxesRunTime.boxToInteger((int)1))) {
                throw new WriteConflictException(state);
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling JdbcRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    private PreparedStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        BoxedUnit boxedUnit;
        Seq columnBindings;
        Seq seq;
        if (((JdbcRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((JdbcRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((JdbcRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((JdbcRepo)this).updateColumnValues(state, false);
            seq = columnBindings = (Seq)((JdbcRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking SQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updateSql(), columnBindings})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        PreparedStatement preparedStatement = ((JdbcRepo)this).connection().prepareStatement(this.updateSql());
        ((IterableLike)columnBindings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JdbcUpdate.$anonfun$bindUpdateStatement$1(preparedStatement, x0$1);
            return BoxedUnit.UNIT;
        });
        return preparedStatement;
    }

    private String updateSql() {
        return ((JdbcRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateSql() : this.withoutLockingUpdateSql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((JdbcRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), this.columnAssignments(), ((JdbcRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |AND\n  |  row_version = :old_row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateSql()})))).stripMargin();
    }

    public static /* synthetic */ void $anonfun$bindUpdateStatement$1(PreparedStatement preparedStatement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object binding = tuple2._1();
        int index = tuple2._2$mcI$sp();
        preparedStatement$1.setObject(index + 1, binding);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(JdbcUpdate $this) {
    }
}

