/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.ptype.Index;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.BaseRepo;
import longevity.persistence.jdbc.JdbcRepo;
import longevity.persistence.jdbc.JdbcRepo$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005UcAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002N\tQ!\n\u001a2d'\u000eDW-\\1\u000b\u0005\r!\u0011\u0001\u00026eE\u000eT!!\u0002\u0004\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0002\u000f\u0005IAn\u001c8hKZLG/_\u000b\u0003\u0013a\u001b\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0014\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u000b\u0011\u0005-)\u0012B\u0001\f\r\u0005\u0011)f.\u001b;\t\ra\u0001A\u0011\u0003\u0003\u001a\u00031\u0019'/Z1uKN\u001b\u0007.Z7b)\u0005QBCA\u000e\"!\rar\u0004F\u0007\u0002;)\u0011a\u0004D\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u0011\u001e\u0005\u00191U\u000f^;sK\")!e\u0006a\u0002G\u000591m\u001c8uKb$\bC\u0001\u000f%\u0013\t)SD\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")q\u0005\u0001C\t'\u0005Y1M]3bi\u0016$\u0016M\u00197f\u0011\u0015I\u0003\u0001\"\u0003+\u0003\u0015IG\rR3g+\u0005Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0011a\u0017M\\4\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0007'R\u0014\u0018N\\4\t\u000bQ\u0002A\u0011B\u001b\u0002;\u0005\u001cG/^1mSj,GmQ8na>tWM\u001c;D_2,XN\u001c#fMN,\u0012A\u000e\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005ebQ\"\u0001\u001e\u000b\u0005m\u0012\u0012A\u0002\u001fs_>$h(\u0003\u0002>\u0019\u00051\u0001K]3eK\u001aL!AM \u000b\u0005ub\u0001\"B!\u0001\t\u0013)\u0014!\u00049sS6\f'/_&fs\u0012+g\rC\u0003D\u0001\u0011%Q'\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7og\")Q\t\u0001C\u0005\r\u0006I1m\u001c7v[:$UM\u001a\u000b\u0003m\u001dCQ\u0001\u0013#A\u0002%\u000b\u0011bY8na>tWM\u001c;1\t)#&-\u001a\t\u0006\u0017B\u0013\u0016\rZ\u0007\u0002\u0019*\u0011QJT\u0001\te\u0016\fG.\u001b>fI*\u0011qJB\u0001\u0006[>$W\r\\\u0005\u0003#2\u0013QCU3bY&TX\r\u001a)s_B\u001cu.\u001c9p]\u0016tG\u000f\u0005\u0002T)2\u0001A!C+H\u0003\u0003\u0005\tQ!\u0001W\u0005\ryF%M\t\u0003/z\u0003\"a\u0015-\u0005\u000be\u0003!\u0019\u0001.\u0003\u0003A\u000b\"a\u00170\u0011\u0005-a\u0016BA/\r\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aC0\n\u0005\u0001d!aA!osB\u00111K\u0019\u0003\nG\u001e\u000b\t\u0011!A\u0003\u0002i\u00131a\u0018\u00133!\t\u0019V\rB\u0005g\u000f\u0006\u0005\t\u0011!B\u00015\n\u0019q\fJ\u001a\t\u000b!\u0004A\u0011C5\u0002\u0013\u0005$GmQ8mk6tGc\u0001\u000bkY\")1n\u001aa\u0001m\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000b5<\u0007\u0019\u0001\u001c\u0002\u0015\r|G.^7o)f\u0004X\rC\u0003p\u0001\u0011E\u0001/A\nd_6\u0004xN\\3oiR{'\n\u001a2d)f\u0004X-\u0006\u0002ryR\u0011aG\u001d\u0005\u0006\u0011:\u0004\ra\u001d\u0019\u0004iZL\b#B&Qkb\\\bCA*w\t%9(/!A\u0001\u0002\u000b\u0005aKA\u0002`IQ\u0002\"aU=\u0005\u0013i\u0014\u0018\u0011!A\u0001\u0006\u0003Q&aA0%kA\u00111\u000b \u0003\u0006{:\u0014\rA\u0017\u0002\u0002\u0003\")q\u0010\u0001C\t'\u0005\u00192M]3bi\u0016,f.[9vK&sG-\u001a=fg\"1\u00111\u0001\u0001\u0005\u0012M\tac\u0019:fCR,gj\u001c8V]&\fX/Z%oI\u0016DXm\u001d\u0005\b\u0003\u000f\u0001A\u0011CA\u0005\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u000fQ\tY!!\u0006\u0002\u001a!A\u0011QBA\u0003\u0001\u0004\ty!\u0001\u0004v]&\fX/\u001a\t\u0004\u0017\u0005E\u0011bAA\n\u0019\t9!i\\8mK\u0006t\u0007bBA\f\u0003\u000b\u0001\rAN\u0001\nS:$W\r\u001f(b[\u0016D\u0001\"a\u0007\u0002\u0006\u0001\u0007\u0011QD\u0001\fG>dW/\u001c8OC6,7\u000fE\u0003\u0002 \u0005%bG\u0004\u0003\u0002\"\u0005\u0015bbA\u001d\u0002$%\tQ\"C\u0002\u0002(1\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"aA*fc*\u0019\u0011q\u0005\u0007\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\u0005Q1oY8sK\u0012\u0004\u0016\r\u001e5\u0015\u0007-\n)\u0004\u0003\u0005\u00028\u0005=\u0002\u0019AA\u001d\u0003\u0011\u0001(o\u001c91\r\u0005m\u00121IA%!\u001dY\u0015QHA!\u0003\u000fJ1!a\u0010M\u00051\u0011V-\u00197ju\u0016$\u0007K]8q!\r\u0019\u00161\t\u0003\f\u0003\u000b\n)$!A\u0001\u0002\u000b\u0005!L\u0001\u0003`IE\u001a\u0004cA*\u0002J\u0011Y\u00111JA\u001b\u0003\u0003\u0005\tQ!\u0001[\u0005\u0011yF%\r\u001b\u0011\u000b\u0005=\u0013\u0011K,\u000e\u0003\tI1!a\u0015\u0003\u0005!QEMY2SKB|\u0007")
public interface JdbcSchema<P> {
    public static /* synthetic */ Future createSchema$(JdbcSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createUniqueIndexes();
            this.createNonUniqueIndexes();
            if (((JdbcRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((JdbcRepo)this).persistenceConfig().writeTimestamps()) {
                this.addColumn("created_timestamp", "timestamp");
                this.addColumn("updated_timestamp", "timestamp");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(JdbcSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", "\n    |  ", "\n    |)\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(createTable).execute();
    }

    private String idDef() {
        return ((BaseRepo)((Object)this)).hasPrimaryKey() ? "" : "\n  id text,";
    }

    private String actualizedComponentColumnDefs() {
        String s = ((TraversableOnce)((JdbcRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
        return s.isEmpty() ? s : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private String primaryKeyDef() {
        return ((BaseRepo)((Object)this)).hasPrimaryKey() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
    }

    private String partitionColumns() {
        return ((TraversableOnce)((JdbcRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).columnName(component2), this.componentToJdbcType(component2)}));
    }

    public static /* synthetic */ void addColumn$(JdbcSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(sql).execute();
    }

    public static /* synthetic */ String componentToJdbcType$(JdbcSchema $this, RealizedPropComponent component2) {
        return $this.componentToJdbcType(component2);
    }

    default public <A> String componentToJdbcType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)JdbcRepo$.MODULE$.basicToJdbcType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createUniqueIndexes$(JdbcSchema $this) {
        $this.createUniqueIndexes();
    }

    default public void createUniqueIndexes() {
        Set nonPrimaryKeys = (Set)((BaseRepo)((Object)this)).realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcSchema.$anonfun$createUniqueIndexes$1(x$1)));
        nonPrimaryKeys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            JdbcSchema.$anonfun$createUniqueIndexes$2(this, key);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createNonUniqueIndexes$(JdbcSchema $this) {
        $this.createNonUniqueIndexes();
    }

    default public void createNonUniqueIndexes() {
        ((BaseRepo)((Object)this)).pType().indexSet().foreach((Function1 & Serializable & scala.Serializable)index -> {
            JdbcSchema.$anonfun$createNonUniqueIndexes$1(this, index);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(JdbcSchema $this, boolean unique, String indexName, Seq columnNames) {
        $this.createIndex(unique, indexName, (Seq<String>)columnNames);
    }

    default public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        BoxedUnit boxedUnit;
        String prefix = unique ? "CREATE UNIQUE INDEX" : "CREATE INDEX";
        String columnList = columnNames.mkString(", ");
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, indexName, ((JdbcRepo)this).tableName(), columnList}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(createIndex).execute();
    }

    private String scoredPath(RealizedProp<?, ?> prop) {
        return prop.inlinedPath().replace('.', '_');
    }

    public static /* synthetic */ boolean $anonfun$createUniqueIndexes$1(RealizedKey x$1) {
        return x$1 instanceof RealizedPrimaryKey;
    }

    public static /* synthetic */ void $anonfun$createUniqueIndexes$2(JdbcSchema $this, RealizedKey key) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)$this).tableName(), $this.scoredPath(key.realizedProp())}));
        Seq columnsNames = (Seq)key.realizedProp().realizedPropComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(true, indexName, (Seq<String>)columnsNames);
    }

    private static Seq toComponents$1(RealizedProp prop) {
        return prop.realizedPropComponents();
    }

    public static /* synthetic */ void $anonfun$createNonUniqueIndexes$1(JdbcSchema $this, Index index) {
        Seq realizedProps = (Seq)index.props().map((Function1 & Serializable & scala.Serializable)x$2 -> (RealizedProp)((BaseRepo)((Object)$this)).realizedPType().realizedProps().apply(x$2), Seq$.MODULE$.canBuildFrom());
        Seq scoredPaths = (Seq)realizedProps.map((Function1 & Serializable & scala.Serializable)prop -> $this.scoredPath((RealizedProp<?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)$this).tableName(), scoredPaths.mkString("__")}));
        Seq columnsNames = (Seq)((TraversableLike)realizedProps.flatMap((Function1 & Serializable & scala.Serializable)prop -> JdbcSchema.toComponents$1(prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(false, indexName, (Seq<String>)columnsNames);
    }

    public static void $init$(JdbcSchema $this) {
    }
}

