/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import akka.NotUsed;
import akka.stream.scaladsl.Source;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import emblem.TypeKey;
import emblem.stringUtil$;
import java.io.Serializable;
import longevity.config.MongoDBConfig;
import longevity.config.PersistenceConfig;
import longevity.model.DomainModel;
import longevity.model.KeyVal;
import longevity.model.PType;
import longevity.model.ptype.Prop;
import longevity.model.query.Query;
import longevity.model.query.QueryFilter;
import longevity.model.query.RelationalOp;
import longevity.model.realized.RealizedKey;
import longevity.persistence.BaseRepo;
import longevity.persistence.Deleted;
import longevity.persistence.PState;
import longevity.persistence.mongo.BsonToDomainModelTranslator;
import longevity.persistence.mongo.DomainModelToBsonTranslator;
import longevity.persistence.mongo.MongoCreate;
import longevity.persistence.mongo.MongoDelete;
import longevity.persistence.mongo.MongoQuery;
import longevity.persistence.mongo.MongoRead;
import longevity.persistence.mongo.MongoRepo$;
import longevity.persistence.mongo.MongoRetrieve;
import longevity.persistence.mongo.MongoSchema;
import longevity.persistence.mongo.MongoUpdate;
import longevity.persistence.mongo.MongoWrite;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0001\u0019A!!C'p]\u001e|'+\u001a9p\u0015\t\u0019A!A\u0003n_:<wN\u0003\u0002\u0006\r\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\u00059\u0011!\u00037p]\u001e,g/\u001b;z+\tI\u0001cE\u0006\u0001\u0015u\tCe\n\u0016.aM2\u0004cA\u0006\r\u001d5\tA!\u0003\u0002\u000e\t\tA!)Y:f%\u0016\u0004x\u000e\u0005\u0002\u0010!1\u0001A!B\t\u0001\u0005\u0004\u0019\"!\u0001)\u0004\u0001E\u0011AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b\u001d>$\b.\u001b8h!\t)2$\u0003\u0002\u001d-\t\u0019\u0011I\\=\u0011\u0007yyb\"D\u0001\u0003\u0013\t\u0001#AA\u0006N_:<wn\u0011:fCR,\u0007c\u0001\u0010#\u001d%\u00111E\u0001\u0002\f\u001b>twm\u001c#fY\u0016$X\rE\u0002\u001fK9I!A\n\u0002\u0003\u00155{gnZ8Rk\u0016\u0014\u0018\u0010E\u0002\u001fQ9I!!\u000b\u0002\u0003\u00135{gnZ8SK\u0006$\u0007c\u0001\u0010,\u001d%\u0011AF\u0001\u0002\u000e\u001b>twm\u001c*fiJLWM^3\u0011\u0007yqc\"\u0003\u00020\u0005\tYQj\u001c8h_N\u001b\u0007.Z7b!\rq\u0012GD\u0005\u0003e\t\u00111\"T8oO>,\u0006\u000fZ1uKB\u0019a\u0004\u000e\b\n\u0005U\u0012!AC'p]\u001e|wK]5uKB\u0011qGP\u0007\u0002q)\u0011\u0011HO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003wq\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002{\u0005\u00191m\\7\n\u0005}B$a\u0003'bufdunZ4j]\u001eD\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011%\u0002\u000bA$\u0016\u0010]3\u0011\u0007\r3e\"D\u0001E\u0015\t)e!A\u0003n_\u0012,G.\u0003\u0002H\t\n)\u0001\u000bV=qK&\u0011\u0011\t\u0004\u0005\n\u0015\u0002\u0011\t\u0011)A\u0005\u0017:\u000b1\u0002Z8nC&tWj\u001c3fYB\u00111\tT\u0005\u0003\u001b\u0012\u00131\u0002R8nC&tWj\u001c3fY&\u0011!\n\u0004\u0005\t!\u0002\u0011)\u0019!C\t#\u000691/Z:tS>tW#\u0001*\u0011\u0005M{fB\u0001\u0010U\u000f\u0019)&\u0001#\u0001\u0005-\u0006IQj\u001c8h_J+\u0007o\u001c\t\u0003=]3a!\u0001\u0002\t\u0002\u0011A6CA,Z!\t)\",\u0003\u0002\\-\t1\u0011I\\=SK\u001aDQ!X,\u0005\u0002y\u000ba\u0001P5oSRtD#\u0001,\u0007\t\u0001<\u0006)\u0019\u0002\u0011\u001b>twm\\*fgNLwN\\%oM>\u001cBaX-cKB\u0011QcY\u0005\u0003IZ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0016M&\u0011qM\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tS~\u0013)\u001a!C\u0001U\u000611m\u001c8gS\u001e,\u0012a\u001b\t\u0003Y:l\u0011!\u001c\u0006\u0003S\u001aI!a\\7\u0003\u001b5{gnZ8E\u0005\u000e{gNZ5h\u0011!\txL!E!\u0002\u0013Y\u0017aB2p]\u001aLw\r\t\u0005\u0006;~#\ta\u001d\u000b\u0003iZ\u0004\"!^0\u000e\u0003]CQ!\u001b:A\u0002-D\u0001\u0002_0\t\u0006\u0004%\t!_\u0001\u0007G2LWM\u001c;\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!! \u001f\u0002\u000f5|gnZ8eE&\u0011q\u0010 \u0002\f\u001b>twm\\\"mS\u0016tG\u000f\u0003\u0006\u0002\u0004}C)\u0019!C\u0001\u0003\u000b\t!\u0001\u001a2\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0005ad\u0018\u0002BA\b\u0003\u0017\u0011Q\"T8oO>$\u0015\r^1cCN,\u0007\"CA\n?\u0006\u0005I\u0011AA\u000b\u0003\u0011\u0019w\u000e]=\u0015\u0007Q\f9\u0002\u0003\u0005j\u0003#\u0001\n\u00111\u0001l\u0011%\tYbXI\u0001\n\u0003\ti\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}!fA6\u0002\"-\u0012\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0002.Y\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00026}\u000b\t\u0011\"\u0011\u00028\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!A.\u00198h\u0015\t\t\u0019%\u0001\u0003kCZ\f\u0017\u0002BA$\u0003{\u0011aa\u0015;sS:<\u0007\"CA&?\u0006\u0005I\u0011AA'\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0005E\u0002\u0016\u0003#J1!a\u0015\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003/z\u0016\u0011!C\u0001\u00033\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002\u001b\u00037B!\"!\u0018\u0002V\u0005\u0005\t\u0019AA(\u0003\rAH%\r\u0005\n\u0003Cz\u0016\u0011!C!\u0003G\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003K\u0002R!a\u001a\u0002nii!!!\u001b\u000b\u0007\u0005-d#\u0001\u0006d_2dWm\u0019;j_:LA!a\u001c\u0002j\tA\u0011\n^3sCR|'\u000fC\u0005\u0002t}\u000b\t\u0011\"\u0001\u0002v\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002x\u0005u\u0004cA\u000b\u0002z%\u0019\u00111\u0010\f\u0003\u000f\t{w\u000e\\3b]\"I\u0011QLA9\u0003\u0003\u0005\rA\u0007\u0005\n\u0003\u0003{\u0016\u0011!C!\u0003\u0007\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u001fB\u0011\"a\"`\u0003\u0003%\t%!#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000f\t\u0013\u00055u,!A\u0005B\u0005=\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005E\u0005\"CA/\u0003\u0017\u000b\t\u00111\u0001\u001b\u000f%\t)jVA\u0001\u0012\u0003\t9*\u0001\tN_:<wnU3tg&|g.\u00138g_B\u0019Q/!'\u0007\u0011\u0001<\u0016\u0011!E\u0001\u00037\u001bR!!'\u0002\u001e\u0016\u0004b!a(\u0002&.$XBAAQ\u0015\r\t\u0019KF\u0001\beVtG/[7f\u0013\u0011\t9+!)\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004^\u00033#\t!a+\u0015\u0005\u0005]\u0005BCAD\u00033\u000b\t\u0011\"\u0012\u0002\n\"Q\u0011\u0011WAM\u0003\u0003%\t)a-\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007Q\f)\f\u0003\u0004j\u0003_\u0003\ra\u001b\u0005\u000b\u0003s\u000bI*!A\u0005\u0002\u0006m\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003{\u000b\u0019\r\u0005\u0003\u0016\u0003\u007f[\u0017bAAa-\t1q\n\u001d;j_:D\u0011\"!2\u00028\u0006\u0005\t\u0019\u0001;\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002J\u0006e\u0015\u0011!C\u0005\u0003\u0017\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001a\t\u0005\u0003w\ty-\u0003\u0003\u0002R\u0006u\"AB(cU\u0016\u001cG\u000fC\u0004\u00022^#\t!!6\u0016\t\u0005]\u0017Q\u001c\u000b\r\u00033\fy.a9\u0002f\u0006\u001d\u0018q\u001e\t\u0005=\u0001\tY\u000eE\u0002\u0010\u0003;$a!EAj\u0005\u0004\u0019\u0002bB!\u0002T\u0002\u0007\u0011\u0011\u001d\t\u0005\u0007\u001a\u000bY\u000e\u0003\u0004K\u0003'\u0004\ra\u0013\u0005\u0007!\u0006M\u0007\u0019\u0001;\t\u000f%\f\u0019\u000e1\u0001\u0002jB\u0019A.a;\n\u0007\u00055XNA\tQKJ\u001c\u0018n\u001d;f]\u000e,7i\u001c8gS\u001eD\u0001\"!=\u0002T\u0002\u0007\u00111_\u0001\fa>d\u0017PU3q_>\u0003H\u000fE\u0003\u0016\u0003\u007f\u000b)\u0010\r\u0003\u0002x\u0006m\b\u0003\u0002\u0010\u0001\u0003s\u00042aDA~\t1\ti0a@\u0002\u0002\u0003\u0005)\u0011\u0001B\b\u0005\ryF%\r\u0005\t\u0003c\f\u0019\u000e1\u0001\u0003\u0002A)Q#a0\u0003\u0004A\"!Q\u0001B\u0005!\u0011q\u0002Aa\u0002\u0011\u0007=\u0011I\u0001\u0002\u0007\u0002~\u0006}\u0018\u0011!A\u0001\u0006\u0003\u0011Y!E\u0002\u0003\u000ei\u00012aDAo#\r\tYN\u0007\u0005\n\u0005'\u0001!\u0011!Q\u0001\nI\u000b\u0001b]3tg&|g\u000e\t\u0005\u000b\u0005/\u0001!Q1A\u0005\u0012\te\u0011!\u00059feNL7\u000f^3oG\u0016\u001cuN\u001c4jOV\u0011\u0011\u0011\u001e\u0005\u000b\u0005;\u0001!\u0011!Q\u0001\n\u0005%\u0018A\u00059feNL7\u000f^3oG\u0016\u001cuN\u001c4jO\u0002Bq!\u0018\u0001\u0005\u0002\u0011\u0011\t\u0003\u0006\u0006\u0003$\t\u0015\"q\u0005B\u0015\u0005W\u00012A\b\u0001\u000f\u0011\u0019\t%q\u0004a\u0001\u0005\"1!Ja\bA\u0002-Ca\u0001\u0015B\u0010\u0001\u0004\u0011\u0006\u0002\u0003B\f\u0005?\u0001\r!!;\t\u000f\t=\u0002\u0001\"\u0005\u00032\u0005q1m\u001c7mK\u000e$\u0018n\u001c8OC6,WC\u0001B\u001a!\u0011\u0011)Da\u0011\u000f\t\t]\"q\b\t\u0004\u0005s1RB\u0001B\u001e\u0015\r\u0011iDE\u0001\u0007yI|w\u000e\u001e \n\u0007\t\u0005c#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\u0012)EC\u0002\u0003BYA1B!\u0013\u0001\u0011\u000b\u0007I\u0011\u0003\u0002\u0003L\u0005yQn\u001c8h_\u000e{G\u000e\\3di&|g.\u0006\u0002\u0003NA1\u0011\u0011\u0002B(\u0005'JAA!\u0015\u0002\f\tyQj\u001c8h_\u000e{G\u000e\\3di&|g\u000e\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\t\t\u001cxN\u001c\u0006\u0003\u0005;\n1a\u001c:h\u0013\u0011\u0011\tGa\u0016\u0003\u0019\t\u001bxN\u001c#pGVlWM\u001c;\t\u0011\t\u0015\u0004\u0001\"\u0005\u0005\u0005O\nQa\u00197pg\u0016$\"A!\u001b\u0015\t\t-$Q\u0010\t\u0007\u0005[\u0012\u0019Ha\u001e\u000e\u0005\t=$b\u0001B9-\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tU$q\u000e\u0002\u0007\rV$XO]3\u0011\u0007U\u0011I(C\u0002\u0003|Y\u0011A!\u00168ji\"A!q\u0010B2\u0001\b\u0011\t)\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!!Q\u000eBB\u0013\u0011\u0011)Ia\u001c\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBAD\u0001\u0011\u0005#\u0011\u0012\u000b\u0003\u0005g\u0001")
public class MongoRepo<P>
extends BaseRepo<P>
implements MongoCreate<P>,
MongoDelete<P>,
MongoQuery<P>,
MongoRead<P>,
MongoRetrieve<P>,
MongoSchema<P>,
MongoUpdate<P>,
MongoWrite<P>,
LazyLogging {
    private MongoCollection<BsonDocument> mongoCollection;
    private final MongoSessionInfo session;
    private final PersistenceConfig persistenceConfig;
    private volatile Logger logger;
    private DomainModelToBsonTranslator domainModelToBsonTranslator;
    private BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    private volatile byte bitmap$0;

    public static <P> MongoRepo<P> apply(PType<P> pType, DomainModel domainModel2, MongoSessionInfo mongoSessionInfo, PersistenceConfig persistenceConfig, Option<MongoRepo<? super P>> option) {
        return MongoRepo$.MODULE$.apply(pType, domainModel2, mongoSessionInfo, persistenceConfig, option);
    }

    @Override
    public BsonDocument bsonForState(PState<P> state) {
        return MongoWrite.bsonForState$(this, state);
    }

    @Override
    public BsonDocument translate(P p) {
        return MongoWrite.translate$(this, p);
    }

    @Override
    public Nothing$ throwDuplicateKeyValException(P p, MongoWriteException cause) {
        return MongoWrite.throwDuplicateKeyValException$(this, p, cause);
    }

    @Override
    public Option<ObjectId> mongoId(PState<P> state) {
        return MongoWrite.mongoId$(this, state);
    }

    @Override
    public Bson writeQuery(PState<P> state) {
        return MongoWrite.writeQuery$(this, state);
    }

    @Override
    public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return MongoUpdate.update$(this, state, context);
    }

    @Override
    public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return MongoSchema.createSchema$(this, context);
    }

    @Override
    public String indexName(RealizedKey<P, ?> key) {
        return MongoSchema.indexName$(this, key);
    }

    @Override
    public void createIndex(Seq<String> paths, String indexName, boolean unique) {
        MongoSchema.createIndex$(this, paths, indexName, unique);
    }

    @Override
    public void createIndex(Seq<String> paths, String indexName, boolean unique, boolean hashed) {
        MongoSchema.createIndex$(this, paths, indexName, unique, hashed);
    }

    @Override
    public boolean createIndex$default$4() {
        return MongoSchema.createIndex$default$4$(this);
    }

    @Override
    public <V extends KeyVal<P>> Future<Option<PState<P>>> retrieve(V keyVal2, TypeKey<V> evidence$1, ExecutionContext context) {
        return MongoRetrieve.retrieve$(this, keyVal2, evidence$1, context);
    }

    @Override
    public <V extends KeyVal<P>> Bson keyValQuery(V keyVal2, TypeKey<V> evidence$2) {
        return MongoRetrieve.keyValQuery$(this, keyVal2, evidence$2);
    }

    @Override
    public PState<P> bsonToState(BsonDocument document) {
        return MongoRead.bsonToState$(this, document);
    }

    @Override
    public <A> BsonValue propValToMongo(A value, Prop<? super P, A> prop) {
        return MongoRead.propValToMongo$(this, value, prop);
    }

    @Override
    public <A> Bson mongoRelationalFilter(Prop<? super P, A> prop, RelationalOp op, A value) {
        return MongoRead.mongoRelationalFilter$(this, prop, op, value);
    }

    @Override
    public Future<Seq<PState<P>>> retrieveByQuery(Query<P> query, ExecutionContext context) {
        return MongoQuery.retrieveByQuery$(this, query, context);
    }

    @Override
    public Source<PState<P>, NotUsed> streamByQueryImpl(Query<P> query) {
        return MongoQuery.streamByQueryImpl$(this, query);
    }

    @Override
    public Bson mongoFilter(QueryFilter<P> filter) {
        return MongoQuery.mongoFilter$(this, filter);
    }

    @Override
    public Future<Deleted<P>> delete(PState<P> state, ExecutionContext context) {
        return MongoDelete.delete$(this, state, context);
    }

    @Override
    public Future<PState<P>> create(P p, ExecutionContext context) {
        return MongoCreate.create$(this, p, context);
    }

    private Logger logger$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private DomainModelToBsonTranslator domainModelToBsonTranslator$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.domainModelToBsonTranslator = MongoWrite.domainModelToBsonTranslator$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.domainModelToBsonTranslator;
    }

    @Override
    public DomainModelToBsonTranslator domainModelToBsonTranslator() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.domainModelToBsonTranslator$lzycompute() : this.domainModelToBsonTranslator;
    }

    private BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator = MongoRead.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    }

    @Override
    public BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$lzycompute() : this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    }

    public MongoSessionInfo session() {
        return this.session;
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public String collectionName() {
        return stringUtil$.MODULE$.uncapitalize(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
    }

    private MongoCollection<BsonDocument> mongoCollection$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mongoCollection = this.session().db().getCollection(this.collectionName(), BsonDocument.class);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mongoCollection;
    }

    public MongoCollection<BsonDocument> mongoCollection() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mongoCollection$lzycompute() : this.mongoCollection;
    }

    @Override
    public Future<BoxedUnit> close(ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.session().client().close()), executionContext);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MongoRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    public MongoRepo(PType<P> pType, DomainModel domainModel2, MongoSessionInfo session, PersistenceConfig persistenceConfig) {
        this.session = session;
        this.persistenceConfig = persistenceConfig;
        super(pType, domainModel2);
        MongoCreate.$init$(this);
        MongoDelete.$init$(this);
        MongoQuery.$init$(this);
        MongoRead.$init$(this);
        MongoRetrieve.$init$(this);
        MongoSchema.$init$(this);
        MongoUpdate.$init$(this);
        MongoWrite.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class MongoSessionInfo
    implements Product,
    scala.Serializable {
        private MongoClient client;
        private MongoDatabase db;
        private final MongoDBConfig config;
        private volatile byte bitmap$0;

        public MongoDBConfig config() {
            return this.config;
        }

        private MongoClient client$lzycompute() {
            MongoSessionInfo mongoSessionInfo = this;
            synchronized (mongoSessionInfo) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.client = new MongoClient(new MongoClientURI(this.config().uri()));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.client;
        }

        public MongoClient client() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.client$lzycompute() : this.client;
        }

        private MongoDatabase db$lzycompute() {
            MongoSessionInfo mongoSessionInfo = this;
            synchronized (mongoSessionInfo) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.db = this.client().getDatabase(this.config().db());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.db;
        }

        public MongoDatabase db() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
        }

        public MongoSessionInfo copy(MongoDBConfig config) {
            return new MongoSessionInfo(config);
        }

        public MongoDBConfig copy$default$1() {
            return this.config();
        }

        public String productPrefix() {
            return "MongoSessionInfo";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.config();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MongoSessionInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MongoSessionInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            MongoSessionInfo mongoSessionInfo = (MongoSessionInfo)x$1;
            MongoDBConfig mongoDBConfig = this.config();
            MongoDBConfig mongoDBConfig2 = mongoSessionInfo.config();
            if (mongoDBConfig == null) {
                if (mongoDBConfig2 != null) {
                    return false;
                }
            } else if (!((Object)mongoDBConfig).equals(mongoDBConfig2)) return false;
            if (!mongoSessionInfo.canEqual(this)) return false;
            return true;
        }

        public MongoSessionInfo(MongoDBConfig config) {
            this.config = config;
            Product.$init$((Product)this);
        }
    }
}

