/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import longevity.exceptions.persistence.DuplicateKeyValException;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.mongo.DomainModelToBsonTranslator;
import longevity.persistence.mongo.MongoId;
import longevity.persistence.mongo.MongoRepo;
import longevity.persistence.mongo.MongoSchema;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@ScalaSignature(bytes="\u0006\u0001I4\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C8\u0003\u00155{gnZ8Xe&$XM\u0003\u0002\u0004\t\u0005)Qn\u001c8h_*\u0011QAB\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001\b\u0003%awN\\4fm&$\u00180\u0006\u0002\ncM\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011A\n\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012\u0001\u0006\t\u0003\u0017UI!A\u0006\u0007\u0003\tUs\u0017\u000e\u001e\u0005\t1\u0001A)\u0019!C\t3\u0005YBm\\7bS:lu\u000eZ3m)>\u00145o\u001c8Ue\u0006t7\u000f\\1u_J,\u0012A\u0007\t\u00037qi\u0011AA\u0005\u0003;\t\u00111\u0004R8nC&tWj\u001c3fYR{'i]8o)J\fgn\u001d7bi>\u0014\b\"B\u0010\u0001\t#\u0001\u0013\u0001\u00042t_:4uN]*uCR,GCA\u0011*!\t\u0011s%D\u0001$\u0015\t!S%\u0001\u0003cg>t'\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)G\ta!i]8o\t>\u001cW/\\3oi\")!F\ba\u0001W\u0005)1\u000f^1uKB\u0019A&L\u0018\u000e\u0003\u0011I!A\f\u0003\u0003\rA\u001bF/\u0019;f!\t\u0001\u0014\u0007\u0004\u0001\u0005\u000bI\u0002!\u0019A\u001a\u0003\u0003A\u000b\"\u0001N\u001c\u0011\u0005-)\u0014B\u0001\u001c\r\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u0003\u001d\n\u0005eb!aA!os\")1\b\u0001C\ty\u0005IAO]1og2\fG/\u001a\u000b\u0003CuBQA\u0010\u001eA\u0002=\n\u0011\u0001\u001d\u0005\u0006\u0001\u0002!\t\"Q\u0001\u001ei\"\u0014xn\u001e#va2L7-\u0019;f\u0017\u0016Lh+\u00197Fq\u000e,\u0007\u000f^5p]R\u0019AGQ\"\t\u000byz\u0004\u0019A\u0018\t\u000b\u0011{\u0004\u0019A#\u0002\u000b\r\fWo]3\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015aB7p]\u001e|GM\u0019\u0006\u0002\u0015\u0006\u00191m\\7\n\u00051;%aE'p]\u001e|wK]5uK\u0016C8-\u001a9uS>t\u0007\"\u0002(\u0001\t#y\u0015aB7p]\u001e|\u0017\n\u001a\u000b\u0003!f\u00032aC)T\u0013\t\u0011FB\u0001\u0004PaRLwN\u001c\t\u0003)^k\u0011!\u0016\u0006\u0003-\u000e\nQ\u0001^=qKNL!\u0001W+\u0003\u0011=\u0013'.Z2u\u0013\u0012DQAK'A\u0002-BQa\u0017\u0001\u0005\u0012q\u000b!b\u001e:ji\u0016\fV/\u001a:z)\ti6\r\u0005\u0002_C6\tqL\u0003\u0002aG\u0005Y1m\u001c8wKJ\u001c\u0018n\u001c8t\u0013\t\u0011wL\u0001\u0003Cg>t\u0007\"\u0002\u0016[\u0001\u0004Y\u0003\"B3\u0001\t\u00131\u0017!C6fs\u001aKG\u000e^3s)\tiv\rC\u0003+I\u0002\u00071\u0006C\u0003j\u0001\u0011%!.\u0001\u0004jI\n\u001bxN\u001c\u000b\u0003W:\u0004\"A\t7\n\u00055\u001c#\u0001\u0004\"t_:|%M[3di&#\u0007\"\u0002\u0016i\u0001\u0004Y\u0003cA\u000eq_%\u0011\u0011O\u0001\u0002\n\u001b>twm\u001c*fa>\u0004")
public interface MongoWrite<P> {
    public static /* synthetic */ DomainModelToBsonTranslator domainModelToBsonTranslator$(MongoWrite $this) {
        return $this.domainModelToBsonTranslator();
    }

    default public DomainModelToBsonTranslator domainModelToBsonTranslator() {
        return new DomainModelToBsonTranslator(((BaseRepo)((Object)this)).domainModel().emblematic());
    }

    public static /* synthetic */ BsonDocument bsonForState$(MongoWrite $this, PState state) {
        return $this.bsonForState(state);
    }

    /*
     * WARNING - void declaration
     */
    default public BsonDocument bsonForState(PState<P> state) {
        void var2_2;
        BsonDocument document = this.translate(state.get());
        Object object = !((BaseRepo)((Object)this)).hasPrimaryKey() ? document.append("_id", (BsonValue)this.idBson(state)) : BoxedUnit.UNIT;
        state.rowVersion().foreach((Function1 & Serializable & scala.Serializable)v -> document.append("_rowVersion", (BsonValue)new BsonInt64(BoxesRunTime.unboxToLong((Object)v))));
        return var2_2;
    }

    public static /* synthetic */ BsonDocument translate$(MongoWrite $this, Object p) {
        return $this.translate(p);
    }

    default public BsonDocument translate(P p) {
        return this.domainModelToBsonTranslator().translate(p, true, ((BaseRepo)((Object)this)).pTypeKey()).asDocument();
    }

    public static /* synthetic */ Nothing$ throwDuplicateKeyValException$(MongoWrite $this, Object p, MongoWriteException cause) {
        return $this.throwDuplicateKeyValException(p, cause);
    }

    default public Nothing$ throwDuplicateKeyValException(P p, MongoWriteException cause) {
        String name;
        String string;
        UnanchoredRegex indexRegex = new StringOps(Predef$.MODULE$.augmentString("index: (?:[\\w\\.]*\\$)?(\\S+)\\s+dup key: \\{ :")).r().unanchored();
        Option option = ((Regex)indexRegex).unapplySeq((CharSequence)(string = cause.getMessage()));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw cause;
        }
        String string2 = name = (String)((LinearSeqOptimized)option.get()).apply(0);
        String name2 = string2;
        RealizedKey realizedKey = (RealizedKey)((BaseRepo)((Object)this)).realizedPType().keySet().find((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)MongoWrite.$anonfun$throwDuplicateKeyValException$1(this, name2, key))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw cause;
        });
        throw new DuplicateKeyValException<P>(p, realizedKey.key(), (Exception)((Object)cause));
    }

    public static /* synthetic */ Option mongoId$(MongoWrite $this, PState state) {
        return $this.mongoId(state);
    }

    default public Option<ObjectId> mongoId(PState<P> state) {
        return state.id().map((Function1 & Serializable & scala.Serializable)x$1 -> ((MongoId)x$1).objectId());
    }

    public static /* synthetic */ Bson writeQuery$(MongoWrite $this, PState state) {
        return $this.writeQuery(state);
    }

    default public Bson writeQuery(PState<P> state) {
        Bson bson;
        if (((MongoRepo)this).persistenceConfig().optimisticLocking()) {
            Bson bson2;
            Option<Object> option = state.rowVersion();
            if (option instanceof Some) {
                Some some = (Some)option;
                long rv = BoxesRunTime.unboxToLong((Object)some.value());
                bson2 = Filters.eq((String)"_rowVersion", (Object)new BsonInt64(rv));
            } else if (None$.MODULE$.equals(option)) {
                bson2 = Filters.exists((String)"_rowVersion", (boolean)false);
            } else {
                throw new MatchError(option);
            }
            Bson rvBson = bson2;
            bson = Filters.and((Bson[])new Bson[]{this.keyFilter(state), rvBson});
        } else {
            bson = this.keyFilter(state);
        }
        return bson;
    }

    private Bson keyFilter(PState<P> state) {
        Bson bson;
        Option option = ((BaseRepo)((Object)this)).realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            bson = this.pkFilter$1(key, state);
        } else if (None$.MODULE$.equals(option)) {
            bson = Filters.eq((String)"_id", (Object)this.idBson(state));
        } else {
            throw new MatchError(option);
        }
        return bson;
    }

    private BsonObjectId idBson(PState<P> state) {
        return new BsonObjectId((ObjectId)this.mongoId(state).get());
    }

    public static /* synthetic */ boolean $anonfun$throwDuplicateKeyValException$1(MongoWrite $this, String name$1, RealizedKey key) {
        String string = ((MongoSchema)((Object)$this)).indexName(key);
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Bson pkFilter$1(RealizedKey key, PState state$1) {
        String fieldName = key.realizedProp().inlinedPath();
        Object keyVal2 = key.keyValForP(state$1.get());
        BsonValue bson = this.domainModelToBsonTranslator().translate(keyVal2, false, key.keyValTypeKey());
        return Filters.eq((String)fieldName, (Object)bson);
    }

    public static void $init$(MongoWrite $this) {
    }
}

