/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import akka.NotUsed;
import akka.stream.scaladsl.Source;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import emblem.TypeKey;
import emblem.emblematic.Emblematic;
import emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import emblem.exceptions.CouldNotTraverseException;
import emblem.exceptions.TraversorException;
import emblem.stringUtil$;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import longevity.config.CassandraConfig;
import longevity.config.PersistenceConfig;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.exceptions.persistence.cassandra.KeyspaceDoesNotExistException;
import longevity.model.DomainModel;
import longevity.model.KeyVal;
import longevity.model.PType;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.BaseRepo;
import longevity.persistence.Deleted;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.SchemaCreator;
import longevity.persistence.cassandra.CassandraCreate;
import longevity.persistence.cassandra.CassandraDelete;
import longevity.persistence.cassandra.CassandraId;
import longevity.persistence.cassandra.CassandraQuery;
import longevity.persistence.cassandra.CassandraQuery$FilterInfo$;
import longevity.persistence.cassandra.CassandraRepo$;
import longevity.persistence.cassandra.CassandraRetrieve;
import longevity.persistence.cassandra.CassandraSchema;
import longevity.persistence.cassandra.CassandraUpdate;
import org.joda.time.DateTime;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Me!B\u0001\u0003\u0001\u0019A!!D\"bgN\fg\u000e\u001a:b%\u0016\u0004xN\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV\u0011\u0011\u0002E\n\n\u0001)i\u0012\u0005J\u0014+[A\u00022a\u0003\u0007\u000f\u001b\u0005!\u0011BA\u0007\u0005\u0005!\u0011\u0015m]3SKB|\u0007CA\b\u0011\u0019\u0001!Q!\u0005\u0001C\u0002M\u0011\u0011\u0001U\u0002\u0001#\t!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004O_RD\u0017N\\4\u0011\u0005UY\u0012B\u0001\u000f\u0017\u0005\r\te.\u001f\t\u0004=}qQ\"\u0001\u0002\n\u0005\u0001\u0012!aD\"bgN\fg\u000e\u001a:b'\u000eDW-\\1\u0011\u0007y\u0011c\"\u0003\u0002$\u0005\ty1)Y:tC:$'/Y\"sK\u0006$X\rE\u0002\u001fK9I!A\n\u0002\u0003#\r\u000b7o]1oIJ\f'+\u001a;sS\u00164X\rE\u0002\u001fQ9I!!\u000b\u0002\u0003\u001d\r\u000b7o]1oIJ\f\u0017+^3ssB\u0019ad\u000b\b\n\u00051\u0012!aD\"bgN\fg\u000e\u001a:b+B$\u0017\r^3\u0011\u0007yqc\"\u0003\u00020\u0005\ty1)Y:tC:$'/\u0019#fY\u0016$X\r\u0005\u00022q5\t!G\u0003\u00024i\u0005a1oY1mC2|wmZ5oO*\u0011QGN\u0001\tif\u0004Xm]1gK*\tq'A\u0002d_6L!!\u000f\u001a\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\nw\u0001\u0011\t\u0011)A\u0005y\t\u000bQ\u0001\u001d+za\u0016\u00042!\u0010!\u000f\u001b\u0005q$BA \u0007\u0003\u0015iw\u000eZ3m\u0013\t\teHA\u0003Q)f\u0004X-\u0003\u0002<\u0019!IA\t\u0001B\u0001B\u0003%Q\tS\u0001\fI>l\u0017-\u001b8N_\u0012,G\u000e\u0005\u0002>\r&\u0011qI\u0010\u0002\f\t>l\u0017-\u001b8N_\u0012,G.\u0003\u0002E\u0019!A!\n\u0001BC\u0002\u0013%1*A\u0006tKN\u001c\u0018n\u001c8J]\u001a|W#\u0001'\u0011\u00055KfB\u0001\u0010O\u000f\u0019y%\u0001#\u0001\u0005!\u0006i1)Y:tC:$'/\u0019*fa>\u0004\"AH)\u0007\r\u0005\u0011\u0001\u0012\u0001\u0003S'\t\t6\u000b\u0005\u0002\u0016)&\u0011QK\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000b]\u000bF\u0011\u0001-\u0002\rqJg.\u001b;?)\u0005\u0001f\u0001\u0002.R\u0001n\u0013AcQ1tg\u0006tGM]1TKN\u001c\u0018n\u001c8J]\u001a|7#B-T9~\u0013\u0007CA\u0006^\u0013\tqFAA\u0007TG\",W.Y\"sK\u0006$xN\u001d\t\u0003+\u0001L!!\u0019\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcY\u0005\u0003IZ\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001BZ-\u0003\u0016\u0004%\taZ\u0001\u0007G>tg-[4\u0016\u0003!\u0004\"![6\u000e\u0003)T!A\u001a\u0004\n\u00051T'aD\"bgN\fg\u000e\u001a:b\u0007>tg-[4\t\u00119L&\u0011#Q\u0001\n!\fqaY8oM&<\u0007\u0005C\u0003X3\u0012\u0005\u0001\u000f\u0006\u0002rgB\u0011!/W\u0007\u0002#\")am\u001ca\u0001Q\"AQ/\u0017EC\u0002\u0013\u0005a/A\u0004dYV\u001cH/\u001a:\u0016\u0003]\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\t\r|'/\u001a\u0006\u0003yv\fa\u0001\u001a:jm\u0016\u0014(B\u0001@7\u0003!!\u0017\r^1ti\u0006D\u0018bAA\u0001s\n91\t\\;ti\u0016\u0014\bBCA\u00033\"\u0015\r\u0011\"\u0001\u0002\b\u000591/Z:tS>tWCAA\u0005!\rA\u00181B\u0005\u0004\u0003\u001bI(aB*fgNLwN\u001c\u0005\u000b\u0003#I\u0006R1A\u0005\n\u0005\u001d\u0011!E;oI\u0016\u0014H._5oON+7o]5p]\"9\u0011QC-\u0005\u0002\u0005]\u0011\u0001D2sK\u0006$XmU2iK6\fGCAA\r)\u0011\tY\"!\f\u0011\r\u0005u\u00111EA\u0014\u001b\t\tyBC\u0002\u0002\"Y\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)#a\b\u0003\r\u0019+H/\u001e:f!\r)\u0012\u0011F\u0005\u0004\u0003W1\"\u0001B+oSRD\u0001\"a\f\u0002\u0014\u0001\u000f\u0011\u0011G\u0001\bG>tG/\u001a=u!\u0011\ti\"a\r\n\t\u0005U\u0012q\u0004\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD\u0011\"!\u000fZ\u0003\u0003%\t!a\u000f\u0002\t\r|\u0007/\u001f\u000b\u0004c\u0006u\u0002\u0002\u00034\u00028A\u0005\t\u0019\u00015\t\u0013\u0005\u0005\u0013,%A\u0005\u0002\u0005\r\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bR3\u0001[A$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA.3\u0006\u0005I\u0011IA/\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0014\u0001\u00026bm\u0006LA!!\u001c\u0002d\t11\u000b\u001e:j]\u001eD\u0011\"!\u001dZ\u0003\u0003%\t!a\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0004cA\u000b\u0002x%\u0019\u0011\u0011\u0010\f\u0003\u0007%sG\u000fC\u0005\u0002~e\u000b\t\u0011\"\u0001\u0002\u0000\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001\u000e\u0002\u0002\"Q\u00111QA>\u0003\u0003\u0005\r!!\u001e\u0002\u0007a$\u0013\u0007C\u0005\u0002\bf\u000b\t\u0011\"\u0011\u0002\n\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fB)\u0011QRAJ55\u0011\u0011q\u0012\u0006\u0004\u0003#3\u0012AC2pY2,7\r^5p]&!\u0011QSAH\u0005!IE/\u001a:bi>\u0014\b\"CAM3\u0006\u0005I\u0011AAN\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAO\u0003G\u00032!FAP\u0013\r\t\tK\u0006\u0002\b\u0005>|G.Z1o\u0011%\t\u0019)a&\u0002\u0002\u0003\u0007!\u0004C\u0005\u0002(f\u000b\t\u0011\"\u0011\u0002*\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002v!I\u0011QV-\u0002\u0002\u0013\u0005\u0013qV\u0001\ti>\u001cFO]5oOR\u0011\u0011q\f\u0005\n\u0003gK\u0016\u0011!C!\u0003k\u000ba!Z9vC2\u001cH\u0003BAO\u0003oC\u0011\"a!\u00022\u0006\u0005\t\u0019\u0001\u000e\b\u0013\u0005m\u0016+!A\t\u0002\u0005u\u0016\u0001F\"bgN\fg\u000e\u001a:b'\u0016\u001c8/[8o\u0013:4w\u000eE\u0002s\u0003\u007f3\u0001BW)\u0002\u0002#\u0005\u0011\u0011Y\n\u0006\u0003\u007f\u000b\u0019M\u0019\t\u0007\u0003\u000b\fY\r[9\u000e\u0005\u0005\u001d'bAAe-\u00059!/\u001e8uS6,\u0017\u0002BAg\u0003\u000f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u001d9\u0016q\u0018C\u0001\u0003#$\"!!0\t\u0015\u00055\u0016qXA\u0001\n\u000b\ny\u000b\u0003\u0006\u0002X\u0006}\u0016\u0011!CA\u00033\fQ!\u00199qYf$2!]An\u0011\u00191\u0017Q\u001ba\u0001Q\"Q\u0011q\\A`\u0003\u0003%\t)!9\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Au!\u0011)\u0012Q\u001d5\n\u0007\u0005\u001dhC\u0001\u0004PaRLwN\u001c\u0005\n\u0003W\fi.!AA\u0002E\f1\u0001\u001f\u00131\u0011)\ty/a0\u0002\u0002\u0013%\u0011\u0011_\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002tB!\u0011\u0011MA{\u0013\u0011\t90a\u0019\u0003\r=\u0013'.Z2u\u0011\u001d\t9.\u0015C\u0001\u0003w,B!!@\u0003\u0004Qa\u0011q B\u0003\u0005\u0013\u0011YA!\u0004\u0003\u0016A!a\u0004\u0001B\u0001!\ry!1\u0001\u0003\u0007#\u0005e(\u0019A\n\t\u000fm\nI\u00101\u0001\u0003\bA!Q\b\u0011B\u0001\u0011\u0019!\u0015\u0011 a\u0001\u000b\"9\u0011QAA}\u0001\u0004\t\bb\u00024\u0002z\u0002\u0007!q\u0002\t\u0004S\nE\u0011b\u0001B\nU\n\t\u0002+\u001a:tSN$XM\\2f\u0007>tg-[4\t\u0011\t]\u0011\u0011 a\u0001\u00053\t1\u0002]8msJ+\u0007o\\(qiB)Q#!:\u0003\u001cA\"!Q\u0004B\u0011!\u0011q\u0002Aa\b\u0011\u0007=\u0011\t\u0003\u0002\u0007\u0003$\t\u0015\u0012\u0011!A\u0001\u0006\u0003\u0011)D\u0001\u0003`IM\u0012\u0004\u0002\u0003B\f\u0003s\u0004\rAa\n\u0011\u000bU\t)O!\u000b1\t\t-\"q\u0006\t\u0005=\u0001\u0011i\u0003E\u0002\u0010\u0005_!ABa\t\u0003&\u0005\u0005\t\u0011!B\u0001\u0005c\t2Aa\r\u001b!\ry!1A\t\u0004\u0005\u0003Q\u0002B\u0003B\u001d#\n\u0007I\u0011\u0001\u0002\u0003<\u0005!\"-Y:jGR{7)Y:tC:$'/\u0019+za\u0016,\"A!\u0010\u0011\u0011\t}\"Q\tB%\u0003?j!A!\u0011\u000b\t\t\r\u0013qR\u0001\nS6lW\u000f^1cY\u0016LAAa\u0012\u0003B\t\u0019Q*\u001991\t\t-#\u0011\f\t\u0007\u0005\u001b\u0012\u0019Fa\u0016\u000e\u0005\t=#B\u0001B)\u0003\u0019)WN\u00197f[&!!Q\u000bB(\u0005\u001d!\u0016\u0010]3LKf\u00042a\u0004B-\t-\u0011YF!\u0018\u0002\u0002\u0003\u0005)\u0011A\n\u0003\t}#3g\r\u0005\t\u0005?\n\u0006\u0015!\u0003\u0003>\u0005)\"-Y:jGR{7)Y:tC:$'/\u0019+za\u0016\u0004\u0003\"\u0003B2\u0001\t\u0005\t\u0015!\u0003M\u00031\u0019Xm]:j_:LeNZ8!\u0011)\u00119\u0007\u0001BC\u0002\u0013E!\u0011N\u0001\u0012a\u0016\u00148/[:uK:\u001cWmQ8oM&<WC\u0001B\b\u0011)\u0011i\u0007\u0001B\u0001B\u0003%!qB\u0001\u0013a\u0016\u00148/[:uK:\u001cWmQ8oM&<\u0007\u0005\u0003\u0004X\u0001\u0011%!\u0011\u000f\u000b\u000b\u0005g\u0012)Ha\u001e\u0003z\tm\u0004c\u0001\u0010\u0001\u001d!11Ha\u001cA\u0002qBa\u0001\u0012B8\u0001\u0004)\u0005B\u0002&\u0003p\u0001\u0007A\n\u0003\u0005\u0003h\t=\u0004\u0019\u0001B\b\u0011)\t)\u0001\u0001EC\u0002\u0013E\u0011q\u0001\u0005\u000b\u0005\u0003\u0003!\u0019!C\t\u0005\t\r\u0015!\u0003;bE2,g*Y7f+\t\u0011)\t\u0005\u0003\u0003\b\nUe\u0002\u0002BE\u0005#\u00032Aa#\u0017\u001b\t\u0011iIC\u0002\u0003\u0010J\ta\u0001\u0010:p_Rt\u0014b\u0001BJ-\u00051\u0001K]3eK\u001aLA!!\u001c\u0003\u0018*\u0019!1\u0013\f\t\u0011\tm\u0005\u0001)A\u0005\u0005\u000b\u000b!\u0002^1cY\u0016t\u0015-\\3!\u0011%\u0011y\n\u0001b\u0001\n#\u0011\t+A\nqCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8/\u0006\u0002\u0003$B1\u0011Q\u0012BS\u0005SKAAa*\u0002\u0010\n\u00191+Z91\r\t-&\u0011\u0018Be!%\u0011iKa-\u000f\u0005o\u00139-\u0004\u0002\u00030*\u0019!\u0011\u0017 \u0002\u0011I,\u0017\r\\5{K\u0012LAA!.\u00030\n)\"+Z1mSj,G\r\u0015:pa\u000e{W\u000e]8oK:$\bcA\b\u0003:\u0012Y!1\u0018B_\u0003\u0003\u0005\tQ!\u0001\u0014\u0005\ryF%\r\u0005\u000b\u0005\u007f\u0013\t-!A\u0001\u0002\t\u0015\u0017\u0001\u0003\u0013b]>tg-\u001e8\t\u0011\t\r\u0007\u0001)A\u0005\u0005G\u000bA\u0003]1si&$\u0018n\u001c8D_6\u0004xN\\3oiN\u00043\u0002\u0001\t\u0004\u001f\t%Ga\u0003Bf\u0005{\u000b\t\u0011!A\u0003\u0002M\u00111a\u0018\u00133\u0011%\u0011y\r\u0001b\u0001\n#\u0011\t.A\fq_N$\b+\u0019:uSRLwN\\\"p[B|g.\u001a8ugV\u0011!1\u001b\t\u0007\u0003\u001b\u0013)K!61\r\t]'1\u001cBt!%\u0011iKa-\u000f\u00053\u0014)\u000fE\u0002\u0010\u00057$1B!8\u0003`\u0006\u0005\t\u0011!B\u0001'\t\u0019q\fJ\u001a\t\u0015\t}&\u0011]A\u0001\u0002\u0003\u0011)\r\u0003\u0005\u0003d\u0002\u0001\u000b\u0011\u0002Bj\u0003a\u0001xn\u001d;QCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8\u000f\t\t\u0004\u001f\t\u001dHa\u0003Bu\u0005?\f\t\u0011!A\u0003\u0002M\u00111a\u0018\u00135\u0011%\u0011i\u000f\u0001b\u0001\n#\u0011\t+\u0001\u000bqe&l\u0017M]=LKf\u001cu.\u001c9p]\u0016tGo\u001d\u0005\t\u0005c\u0004\u0001\u0015!\u0003\u0003$\u0006)\u0002O]5nCJL8*Z=D_6\u0004xN\\3oiN\u0004\u0003\"\u0003B{\u0001\t\u0007I\u0011\u0003B|\u0003Q\t7\r^;bY&TX\rZ\"p[B|g.\u001a8ugV\u0011!\u0011 \t\u0007\u0005\u007f\u0011YPa@\n\t\tu(\u0011\t\u0002\u0004'\u0016$\b\u0007CB\u0001\u0007\u000b\u00199b!\b\u0011\u0015\t5&1WB\u0002\u0007+\u0019Y\u0002E\u0002\u0010\u0007\u000b!Aba\u0002\u0004\n\u0005\u0005\t\u0011!B\u0001\u0007'\u00111a\u0018\u00139\u0011!\u0019Y\u0001\u0001C\t\u0005\r5\u0011!E5oI\u0016DX\rZ\"p[B|g.\u001a8ugV\u00111q\u0002\t\u0007\u0005\u000f\u001b\tBa@\n\t\tu(qS\t\u0003\u001di\u00012aDB\f\t-\u0019Ib!\u0003\u0002\u0002\u0003\u0005)\u0011A\n\u0003\u0007}#\u0013\bE\u0002\u0010\u0007;!1ba\b\u0004\n\u0005\u0005\t\u0011!B\u0001'\t!q\fJ\u00191\u0011!\u0019\u0019\u0003\u0001Q\u0001\n\te\u0018!F1diV\fG.\u001b>fI\u000e{W\u000e]8oK:$8\u000f\t\u0005\n\u0007O\u0001!\u0019!C\t\u0007S\t!$Z7cY\u0016l\u0017\r^5d)>T5o\u001c8Ue\u0006t7\u000f\\1u_J,\"aa\u000b\u0011\t\r521H\u0007\u0003\u0007_QAa!\r\u00044\u0005!1/\u001f8d\u0015\u0011\u0019)da\u000e\u0002\u0015Q\u0014\u0018M^3sg>\u00148O\u0003\u0003\u0004:\t=\u0013AC3nE2,W.\u0019;jG&!1QHB\u0018\u0005i)UN\u00197f[\u0006$\u0018n\u0019+p\u0015N|g\u000e\u0016:b]Nd\u0017\r^8s\u0011!\u0019\t\u0005\u0001Q\u0001\n\r-\u0012aG3nE2,W.\u0019;jGR{'j]8o)J\fgn\u001d7bi>\u0014\b\u0005C\u0005\u0004F\u0001\u0011\r\u0011\"\u0005\u0004H\u0005Q\"n]8o)>,UN\u00197f[\u0006$\u0018n\u0019+sC:\u001cH.\u0019;peV\u00111\u0011\n\t\u0005\u0007[\u0019Y%\u0003\u0003\u0004N\r=\"A\u0007&t_:$v.R7cY\u0016l\u0017\r^5d)J\fgn\u001d7bi>\u0014\b\u0002CB)\u0001\u0001\u0006Ia!\u0013\u00027)\u001cxN\u001c+p\u000b6\u0014G.Z7bi&\u001cGK]1og2\fGo\u001c:!\u0011\u001d\u0019)\u0006\u0001C\t\u0007/\n!bY8mk6tg*Y7f)\u0011\tyf!\u0017\t\u0011\rm31\u000ba\u0001\u0007;\nA\u0001\u001d:paBB1qLB2\u0007S\u001ay\u0007\u0005\u0006\u0003.\nM6\u0011MB4\u0007[\u00022aDB2\t-\u0019)g!\u0017\u0002\u0002\u0003\u0005)\u0011A\n\u0003\t}#\u0013'\u000f\t\u0004\u001f\r%DaCB6\u00073\n\t\u0011!A\u0003\u0002M\u0011Aa\u0018\u00133aA\u0019qba\u001c\u0005\u0017\rE4\u0011LA\u0001\u0002\u0003\u0015\ta\u0005\u0002\u0005?\u0012\u0012\u0014\u0007C\u0004\u0004v\u0001!\tba\u001e\u0002\u0015M\u001cwN]3e!\u0006$\b\u000e\u0006\u0003\u0002`\re\u0004\u0002CB.\u0007g\u0002\raa\u001f1\u0011\ru4\u0011QBD\u0007\u001b\u0003\"B!,\u00034\u000e}4QQBF!\ry1\u0011\u0011\u0003\f\u0007\u0007\u001bI(!A\u0001\u0002\u000b\u00051C\u0001\u0003`II\u0012\u0004cA\b\u0004\b\u0012Y1\u0011RB=\u0003\u0003\u0005\tQ!\u0001\u0014\u0005\u0011yFEM\u001a\u0011\u0007=\u0019i\tB\u0006\u0004\u0010\u000ee\u0014\u0011!A\u0001\u0006\u0003\u0019\"\u0001B0%eQBqaa%\u0001\t#\u0019)*\u0001\bkg>t7\u000b\u001e:j]\u001e4uN\u001d)\u0015\t\t\u00155q\u0013\u0005\b\u00073\u001b\t\n1\u0001\u000f\u0003\u0005\u0001\bbBBO\u0001\u0011E1qT\u0001\u0012kB$\u0017\r^3D_2,XN\u001c(b[\u0016\u001cH\u0003BBQ\u0007c\u0003baa)\u0004.\n\u0015e\u0002BBS\u0007SsAAa#\u0004(&\tq#C\u0002\u0004,Z\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003(\u000e=&bABV-!Q11WBN!\u0003\u0005\r!!(\u0002\u0011%\u001c8I]3bi\u0016Dqaa.\u0001\t#\u0019I,\u0001\nva\u0012\fG/Z\"pYVlgNV1mk\u0016\u001cHCBB^\u0007{\u001b9\rE\u0003\u0004$\u000e56\u000b\u0003\u0005\u0004@\u000eU\u0006\u0019ABa\u0003\u0015\u0019H/\u0019;f!\u0011Y11\u0019\b\n\u0007\r\u0015GA\u0001\u0004Q'R\fG/\u001a\u0005\u000b\u0007g\u001b)\f%AA\u0002\u0005u\u0005bBBf\u0001\u0011E1QZ\u0001\u0005kVLG\r\u0006\u0003\u0004P\u000em\u0007\u0003BBi\u0007/l!aa5\u000b\t\rU\u0017qM\u0001\u0005kRLG.\u0003\u0003\u0004Z\u000eM'\u0001B+V\u0013\u0012C\u0001ba0\u0004J\u0002\u00071\u0011\u0019\u0005\b\u0007?\u0004A\u0011\u0003BB\u0003A9\b.\u001a:f\u0003N\u001c\u0018n\u001a8nK:$8\u000fC\u0004\u0004d\u0002!\tb!:\u0002\u001b]DWM]3CS:$\u0017N\\4t)\u0011\u00199o!;\u0011\u000b\u00055%QU*\t\u0011\r}6\u0011\u001da\u0001\u0007\u0003Dqa!<\u0001\t\u0013\u0019y/\u0001\bqe>\u0004h+\u00197CS:$\u0017N\\4\u0016\r\rE8Q C\u0005)\u0015\u001961\u001fC\u0007\u0011!\u0019)pa;A\u0002\r]\u0018!C2p[B|g.\u001a8ua\u0011\u0019I\u0010b\u0001\u0011\u0015\t5&1WB~\t\u0003!9\u0001E\u0002\u0010\u0007{$\u0001ba@\u0004l\n\u000711\u0003\u0002\u0003!B\u00032a\u0004C\u0002\t-!)aa=\u0002\u0002\u0003\u0005)\u0011A\n\u0003\t}#3'\r\t\u0004\u001f\u0011%Aa\u0002C\u0006\u0007W\u0014\ra\u0005\u0002\u0002\u0003\"91\u0011TBv\u0001\u0004q\u0001b\u0002C\t\u0001\u0011EA1C\u0001\u000fG\u0006\u001c8/\u00198ee\u00064\u0016\r\\;f)\r\u0019FQ\u0003\u0005\b\t/!y\u00011\u0001\u001b\u0003\u00151\u0018\r\\;f\u0011\u001d!Y\u0002\u0001C\t\t;\tQbY1tg\u0006tGM]1ECR,G\u0003\u0002C\u0010\tK\u0001Ba!5\u0005\"%!A1EBj\u0005\u0011!\u0015\r^3\t\u0011\u0011\u001dB\u0011\u0004a\u0001\tS\t\u0011\u0001\u001a\t\u0005\tW!I$\u0004\u0002\u0005.)!Aq\u0006C\u0019\u0003\u0011!\u0018.\\3\u000b\t\u0011MBQG\u0001\u0005U>$\u0017M\u0003\u0002\u00058\u0005\u0019qN]4\n\t\u0011mBQ\u0006\u0002\t\t\u0006$X\rV5nK\"9Aq\b\u0001\u0005\u0012\u0011\u0005\u0013a\u0004:fiJLWM^3Ge>l'k\\<\u0015\t\r\u0005G1\t\u0005\t\t\u000b\"i\u00041\u0001\u0005H\u0005\u0019!o\\<\u0011\u0007a$I%C\u0002\u0005Le\u00141AU8x\u0011%!y\u0005\u0001a\u0001\n\u0013!\t&\u0001\nqe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u001cXC\u0001C*!!\u0011yD!\u0012\u0003\u0006\u0012U\u0003c\u0001=\u0005X%\u0019A\u0011L=\u0003#A\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000fC\u0005\u0005^\u0001\u0001\r\u0011\"\u0003\u0005`\u00051\u0002O]3qCJ,Gm\u0015;bi\u0016lWM\u001c;t?\u0012*\u0017\u000f\u0006\u0003\u0002(\u0011\u0005\u0004BCAB\t7\n\t\u00111\u0001\u0005T!AAQ\r\u0001!B\u0013!\u0019&A\nqe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u001c\b\u0005C\u0004\u0005j\u0001!\t\u0002b\u001b\u0002#A\u0014X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0003\u0005V\u00115\u0004\u0002\u0003C8\tO\u0002\rA!\"\u0002\u0007\r\fH\u000e\u0003\u0005\u0005t\u0001!\t\u0006\u0002C;\u0003\u0015\u0019Gn\\:f)\t!9\b\u0006\u0003\u0002\u001c\u0011e\u0004\u0002\u0003C>\tc\u0002\u001d!!\r\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bbBAW\u0001\u0011\u0005Cq\u0010\u000b\u0003\u0005\u000bC\u0011\u0002b!\u0001#\u0003%\t\u0002\"\"\u00029U\u0004H-\u0019;f\u0007>dW/\u001c8WC2,Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011Aq\u0011\u0016\u0005\u0003;\u000b9\u0005C\u0005\u0005\f\u0002\t\n\u0011\"\u0005\u0005\u0006\u0006YR\u000f\u001d3bi\u0016\u001cu\u000e\\;n]:\u000bW.Z:%I\u00164\u0017-\u001e7uIEBQ\u0002b$\u0001!\u0003\r\t\u0011!C\u0005\t#C\u0015!E:va\u0016\u0014H\u0005Z8nC&tWj\u001c3fYV\tQ\t")
public class CassandraRepo<P>
extends BaseRepo<P>
implements CassandraSchema<P>,
CassandraCreate<P>,
CassandraRetrieve<P>,
CassandraQuery<P>,
CassandraUpdate<P>,
CassandraDelete<P>,
LazyLogging {
    private Session session;
    private final CassandraSessionInfo sessionInfo;
    private final PersistenceConfig persistenceConfig;
    private final String tableName;
    private final Seq<RealizedPropComponent<P, ?, ?>> partitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private Map<String, PreparedStatement> preparedStatements;
    private Logger logger;
    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    private volatile CassandraQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    private volatile byte bitmap$0;

    public static <P> CassandraRepo<P> apply(PType<P> pType, DomainModel domainModel2, CassandraSessionInfo cassandraSessionInfo, PersistenceConfig persistenceConfig, Option<CassandraRepo<? super P>> option) {
        return CassandraRepo$.MODULE$.apply(pType, domainModel2, cassandraSessionInfo, persistenceConfig, option);
    }

    @Override
    public Future<Deleted<P>> delete(PState<P> state, ExecutionContext context) {
        return CassandraDelete.delete$(this, state, context);
    }

    @Override
    public PreparedStatement deleteStatement() {
        return CassandraDelete.deleteStatement$(this);
    }

    @Override
    public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return CassandraUpdate.update$(this, state, context);
    }

    @Override
    public Future<Seq<PState<P>>> retrieveByQuery(Query<P> query, ExecutionContext context) {
        return CassandraQuery.retrieveByQuery$(this, query, context);
    }

    @Override
    public Source<PState<P>, NotUsed> streamByQueryImpl(Query<P> query) {
        return CassandraQuery.streamByQueryImpl$(this, query);
    }

    @Override
    public String queryWhereClause(CassandraQuery.FilterInfo filterInfo) {
        return CassandraQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V extends KeyVal<P>> Future<Option<PState<P>>> retrieve(V keyVal2, TypeKey<V> evidence$1, ExecutionContext context) {
        return CassandraRetrieve.retrieve$(this, keyVal2, evidence$1, context);
    }

    @Override
    public Future<Option<PState<P>>> retrieveFromBoundStatement(BoundStatement statement, ExecutionContext context) {
        return CassandraRetrieve.retrieveFromBoundStatement$(this, statement, context);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<P, ?> key) {
        return CassandraRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public Future<PState<P>> create(P p, ExecutionContext context) {
        return CassandraCreate.create$(this, p, context);
    }

    @Override
    public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return CassandraSchema.createSchema$(this, context);
    }

    @Override
    public void createTable() {
        CassandraSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        CassandraSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return CassandraSchema.componentToCassandraType$(this, component2);
    }

    @Override
    public void createIndexes() {
        CassandraSchema.createIndexes$(this);
    }

    @Override
    public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        CassandraSchema.createIndex$(this, component2);
    }

    @Override
    public void createIndex(String indexName, String columnName) {
        CassandraSchema.createIndex$(this, indexName, columnName);
    }

    private Logger logger$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce = CassandraDelete.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() : this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement = CassandraUpdate.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public CassandraQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    @Override
    public Map<RealizedKey<P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements() {
        return this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    }

    @Override
    public void longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements_$eq(Map<RealizedKey<P, ?>, PreparedStatement> x$1) {
        this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements = x$1;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.longevity$persistence$cassandra$CassandraCreate$$insertStatement = CassandraCreate.longevity$persistence$cassandra$CassandraCreate$$insertStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    public /* synthetic */ DomainModel longevity$persistence$cassandra$CassandraRepo$$super$domainModel() {
        return super.domainModel();
    }

    private CassandraSessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    private Session session$lzycompute() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = this.sessionInfo().session();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.sessionInfo = null;
        return this.session;
    }

    public Session session() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.session$lzycompute() : this.session;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> partitionComponents() {
        return this.partitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents() {
        return this.postPartitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents() {
        return this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CassandraRepo.$anonfun$indexedComponents$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$6 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$6), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$25 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$26 = JsonMethods$.MODULE$.render$default$2(x$25);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$25, x$26));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), (TraversorException)e);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(isCreate && !this.hasPrimaryKey(), this.persistenceConfig().optimisticLocking());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                String string = "id";
                String string2 = "row_version";
                String string3 = "p";
                return (Seq)((SeqLike)((SeqLike)componentColumnNames.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                String string = "id";
                String string4 = "p";
                return (Seq)((SeqLike)componentColumnNames.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (!bl && bl4) {
                String string = "row_version";
                String string5 = "p";
                return (Seq)((SeqLike)componentColumnNames.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (false != bl) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        String string = "p";
        return (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(isCreate && !this.hasPrimaryKey(), this.persistenceConfig().optimisticLocking());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                UUID uUID = this.uuid(state);
                Object object = CassandraRepo.rv$1(state);
                String string = this.jsonStringForP(state.get());
                return (Seq)((SeqLike)((SeqLike)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl && bl3) {
                Object object = CassandraRepo.rv$1(state);
                String string = this.jsonStringForP(state.get());
                return (Seq)((SeqLike)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (bl && !bl4) {
                UUID uUID = this.uuid(state);
                String string = this.jsonStringForP(state.get());
                return (Seq)((SeqLike)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (false != bl) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        String string = this.jsonStringForP(state.get());
        return (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((CassandraId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((CassandraId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.cassandraValue(component2.outerPropPath().get().apply(p));
    }

    public Object cassandraValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.cassandraDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date cassandraDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromRow(Row row) {
        None$ id = !this.hasPrimaryKey() ? new Some(new CassandraId(row.getUUID("id"))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong("row_version"))) : None$.MODULE$;
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(row.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply(id, (Option<Object>)rowVersion, p);
    }

    private Map<String, PreparedStatement> preparedStatements() {
        return this.preparedStatements;
    }

    private void preparedStatements_$eq(Map<String, PreparedStatement> x$1) {
        this.preparedStatements = x$1;
    }

    public PreparedStatement preparedStatement(String cql) {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if (!this.preparedStatements().contains((Object)cql)) {
                this.preparedStatements_$eq((Map<String, PreparedStatement>)this.preparedStatements().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cql), (Object)this.session().prepare(cql))));
            }
        }
        return (PreparedStatement)this.preparedStatements().apply((Object)cql);
    }

    @Override
    public Future<BoxedUnit> close(ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.session().close();
            this.session().getCluster().close();
        }), executionContext);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CassandraRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        CassandraRepo cassandraRepo = this;
        synchronized (cassandraRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new CassandraQuery$FilterInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$3) {
        return x$3 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Object rv$1(PState state$1) {
        return state$1.rowVersionOrNull();
    }

    public CassandraRepo(PType<P> pType, DomainModel domainModel2, CassandraSessionInfo sessionInfo, PersistenceConfig persistenceConfig) {
        Seq seq;
        Seq seq2;
        this.sessionInfo = sessionInfo;
        this.persistenceConfig = persistenceConfig;
        super(pType, domainModel2);
        CassandraSchema.$init$(this);
        CassandraCreate.$init$(this);
        CassandraRetrieve.$init$(this);
        CassandraQuery.$init$(this);
        CassandraUpdate.$init$(this);
        CassandraDelete.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.tableName = stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
        Option option = this.realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq2 = (Seq)key.partitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        this.partitionComponents = seq2;
        Option option2 = this.realizedPType().primaryKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq = (Seq)key.postPartitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        this.postPartitionComponents = seq;
        this.primaryKeyComponents = (Seq)this.partitionComponents().$plus$plus(this.postPartitionComponents(), Seq$.MODULE$.canBuildFrom());
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraRepo$$super$domainModel().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraRepo$$super$domainModel().emblematic();
            }
        };
        this.preparedStatements = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public static class CassandraSessionInfo
    implements SchemaCreator,
    Product,
    scala.Serializable {
        private Cluster cluster;
        private Session session;
        private Session underlyingSession;
        private final CassandraConfig config;
        private volatile byte bitmap$0;

        public CassandraConfig config() {
            return this.config;
        }

        private Cluster cluster$lzycompute() {
            CassandraSessionInfo cassandraSessionInfo = this;
            synchronized (cassandraSessionInfo) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Cluster.Builder builder = Cluster.builder().addContactPoint(this.config().address());
                    this.config().credentials().map((Function1 & Serializable & scala.Serializable)creds -> builder.withCredentials(creds.username(), creds.password()));
                    this.cluster = builder.build();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.cluster;
        }

        public Cluster cluster() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.cluster$lzycompute() : this.cluster;
        }

        private Session session$lzycompute() {
            CassandraSessionInfo cassandraSessionInfo = this;
            synchronized (cassandraSessionInfo) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.liftedTree1$1();
                    this.session = this.underlyingSession();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.session;
        }

        public Session session() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
        }

        private Session underlyingSession$lzycompute() {
            CassandraSessionInfo cassandraSessionInfo = this;
            synchronized (cassandraSessionInfo) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.underlyingSession = this.cluster().connect();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.underlyingSession;
        }

        private Session underlyingSession() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.underlyingSession$lzycompute() : this.underlyingSession;
        }

        @Override
        public Future<BoxedUnit> createSchema(ExecutionContext context) {
            return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> this.underlyingSession().execute(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n          |CREATE KEYSPACE IF NOT EXISTS ", "\n          |WITH replication = {\n          |  'class': 'SimpleStrategy',\n          |  'replication_factor': ", "\n          |};\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config().keyspace(), BoxesRunTime.boxToInteger((int)this.config().replicationFactor())})))).stripMargin())), context);
        }

        public CassandraSessionInfo copy(CassandraConfig config) {
            return new CassandraSessionInfo(config);
        }

        public CassandraConfig copy$default$1() {
            return this.config();
        }

        public String productPrefix() {
            return "CassandraSessionInfo";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.config();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CassandraSessionInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CassandraSessionInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            CassandraSessionInfo cassandraSessionInfo = (CassandraSessionInfo)x$1;
            CassandraConfig cassandraConfig = this.config();
            CassandraConfig cassandraConfig2 = cassandraSessionInfo.config();
            if (cassandraConfig == null) {
                if (cassandraConfig2 != null) {
                    return false;
                }
            } else if (!((Object)cassandraConfig).equals(cassandraConfig2)) return false;
            if (!cassandraSessionInfo.canEqual(this)) return false;
            return true;
        }

        private final ResultSet liftedTree1$1() {
            ResultSet resultSet;
            try {
                resultSet = this.underlyingSession().execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config().keyspace()})));
            }
            catch (Throwable throwable) {
                InvalidQueryException invalidQueryException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().startsWith("Keyspace '") && invalidQueryException.getMessage().endsWith("' does not exist")) {
                    throw new KeyspaceDoesNotExistException(this.config(), invalidQueryException);
                }
                throw throwable;
            }
            return resultSet;
        }

        public CassandraSessionInfo(CassandraConfig config) {
            this.config = config;
            Product.$init$((Product)this);
        }
    }
}

