/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import akka.NotUsed;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.mongo.MongoRead;
import longevity.persistence.mongo.MongoRepo;
import longevity.subdomain.Persistent;
import longevity.subdomain.ptype.Prop;
import longevity.subdomain.query.AndOp$;
import longevity.subdomain.query.Ascending$;
import longevity.subdomain.query.ConditionalFilter;
import longevity.subdomain.query.Descending$;
import longevity.subdomain.query.FilterAll;
import longevity.subdomain.query.LogicalOp;
import longevity.subdomain.query.OrOp$;
import longevity.subdomain.query.Query;
import longevity.subdomain.query.QueryFilter;
import longevity.subdomain.query.QueryOrderBy;
import longevity.subdomain.query.QueryOrderBy$;
import longevity.subdomain.query.QuerySortDirection;
import longevity.subdomain.query.RelationalFilter;
import longevity.subdomain.query.RelationalOp;
import longevity.subdomain.realized.RealizedPartitionKey;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015cAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002>\tQQj\u001c8h_F+XM]=\u000b\u0005\r!\u0011!B7p]\u001e|'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\u0005%\u00194C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001'\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u0015!\tYQ#\u0003\u0002\u0017\u0019\t!QK\\5u\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003=\u0011X\r\u001e:jKZ,')_)vKJLHC\u0001\u000eE)\tYr\bE\u0002\u001d?\u0005j\u0011!\b\u0006\u0003=1\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0001SD\u0001\u0004GkR,(/\u001a\t\u0004E)jcBA\u0012)\u001d\t!s%D\u0001&\u0015\t1##\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0011\u0011\u0006D\u0001\ba\u0006\u001c7.Y4f\u0013\tYCFA\u0002TKFT!!\u000b\u0007\u0011\u00079z\u0013'D\u0001\u0005\u0013\t\u0001DA\u0001\u0004Q'R\fG/\u001a\t\u0003eMb\u0001\u0001B\u00035\u0001\t\u0007QGA\u0001Q#\t1\u0014\b\u0005\u0002\fo%\u0011\u0001\b\u0004\u0002\b\u001d>$\b.\u001b8h!\tQT(D\u0001<\u0015\tad!A\u0005tk\n$w.\\1j]&\u0011ah\u000f\u0002\u000b!\u0016\u00148/[:uK:$\b\"\u0002!\u0018\u0001\b\t\u0015aB2p]R,\u0007\u0010\u001e\t\u00039\tK!aQ\u000f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B#\u0018\u0001\u00041\u0015!B9vKJL\bcA$Jc5\t\u0001J\u0003\u0002Fw%\u0011!\n\u0013\u0002\u0006#V,'/\u001f\u0005\u0006\u0019\u0002!\t!T\u0001\u0012gR\u0014X-Y7CsF+XM]=J[BdGC\u0001(]!\u0011ye+\f-\u000e\u0003AS!!\u0015*\u0002\u0011M\u001c\u0017\r\\1eg2T!a\u0015+\u0002\rM$(/Z1n\u0015\u0005)\u0016\u0001B1lW\u0006L!a\u0016)\u0003\rM{WO]2f!\tI&,D\u0001U\u0013\tYFKA\u0004O_R,6/\u001a3\t\u000b\u0015[\u0005\u0019\u0001$\t\u000by\u0003A\u0011B0\u0002\u0017E,XM]=DkJ\u001cxN\u001d\u000b\u0003AJ\u00042!\u00195k\u001b\u0005\u0011'BA2e\u0003\u0019\u0019G.[3oi*\u0011QMZ\u0001\b[>twm\u001c3c\u0015\u00059\u0017aA2p[&\u0011\u0011N\u0019\u0002\f\u001b>twm\\\"veN|'\u000f\u0005\u0002la6\tAN\u0003\u0002n]\u0006!!m]8o\u0015\u0005y\u0017aA8sO&\u0011\u0011\u000f\u001c\u0002\r\u0005N|g\u000eR8dk6,g\u000e\u001e\u0005\u0006\u000bv\u0003\rA\u0012\u0005\u0006i\u0002!\t\"^\u0001\f[>twm\u001c$jYR,'\u000f\u0006\u0002wyB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010\\\u0001\fG>tg/\u001a:tS>t7/\u0003\u0002|q\n!!i]8o\u0011\u0015i8\u000f1\u0001\u007f\u0003\u00191\u0017\u000e\u001c;feB\u0019qi`\u0019\n\u0007\u0005\u0005\u0001JA\u0006Rk\u0016\u0014\u0018PR5mi\u0016\u0014\bbBA\u0003\u0001\u0011%\u0011qA\u0001\u0004I>\u001cG#\u00026\u0002\n\u0005u\u0001\u0002CA\u0006\u0003\u0007\u0001\r!!\u0004\u0002\u0007-,\u0017\u0010\u0005\u0003\u0002\u0010\u0005]a\u0002BA\t\u0003'\u0001\"\u0001\n\u0007\n\u0007\u0005UA\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+a\u0001\u0002CA\u0010\u0003\u0007\u0001\r!!\t\u0002\u000bY\fG.^3\u0011\u0007-\f\u0019#C\u0002\u0002&1\u0014\u0011BQ:p]Z\u000bG.^3\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005aQn\u001c8h_>\u0013H-\u001a:CsR!\u0011QFA\u001a!\u0011Y\u0011q\u00066\n\u0007\u0005EBB\u0001\u0004PaRLwN\u001c\u0005\t\u0003k\t9\u00031\u0001\u00028\u00059qN\u001d3fe\nK\b\u0003B$\u0002:EJ1!a\u000fI\u00051\tV/\u001a:z\u001fJ$WM\u001d\"z!\u0015\ty$!\u00112\u001b\u0005\u0011\u0011bAA\"\u0005\tIQj\u001c8h_J+\u0007o\u001c")
public interface MongoQuery<P extends Persistent> {
    public static /* synthetic */ Future retrieveByQuery$(MongoQuery $this, Query query, ExecutionContext context) {
        return $this.retrieveByQuery(query, context);
    }

    default public Future<Seq<PState<P>>> retrieveByQuery(Query<P> query, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling MongoRepo.retrieveByQuery: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Vector states = (Vector)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
                MongoCursor<BsonDocument> cursor = this.queryCursor(query);
                VectorBuilder builder = new VectorBuilder();
                while (cursor.hasNext()) {
                    builder.$plus$eq(((MongoRead)((Object)this)).bsonToState((BsonDocument)cursor.next()));
                }
                return builder.result();
            });
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling MongoRepo.retrieveByQuery: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{states})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    public static /* synthetic */ Source streamByQueryImpl$(MongoQuery $this, Query query) {
        return $this.streamByQueryImpl(query);
    }

    /*
     * WARNING - void declaration
     */
    default public Source<PState<P>, NotUsed> streamByQueryImpl(Query<P> query) {
        void var2_2;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling MongoRepo.streamByQuery: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Source source = Source$.MODULE$.fromIterator((Function0 & Serializable & scala.Serializable)() -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.queryCursor(query)).asScala()).map((Function1 & Serializable & scala.Serializable)document -> ((MongoRead)((Object)this)).bsonToState((BsonDocument)document)));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling MongoRepo.streamByQuery: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private MongoCursor<BsonDocument> queryCursor(Query<P> query) {
        BoxedUnit boxedUnit;
        Bson filter = this.mongoFilter(query.filter());
        FindIterable filteredCursor = ((MongoRepo)this).mongoCollection().find(filter);
        Option<BsonDocument> orderBy = this.mongoOrderBy(query.orderBy());
        FindIterable orderByCursor = (FindIterable)orderBy.map((Function1 & Serializable & scala.Serializable)o -> filteredCursor.sort((Bson)o)).getOrElse((Function0 & Serializable & scala.Serializable)() -> filteredCursor);
        FindIterable offsetCursor = (FindIterable)query.offset().map((Function1 & Serializable & scala.Serializable)x$1 -> orderByCursor.skip(BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> orderByCursor);
        FindIterable limitCursor = (FindIterable)query.limit().map((Function1 & Serializable & scala.Serializable)x$1 -> offsetCursor.limit(BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsetCursor);
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling MongoCollection.find: filter = ", " orderBy = ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter, orderBy})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset = ", " limit = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.offset(), query.limit()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return limitCursor.iterator();
    }

    public static /* synthetic */ Bson mongoFilter$(MongoQuery $this, QueryFilter filter) {
        return $this.mongoFilter(filter);
    }

    default public Bson mongoFilter(QueryFilter<P> filter) {
        BsonDocument bsonDocument;
        QueryFilter<P> queryFilter = filter;
        if (queryFilter instanceof FilterAll) {
            bsonDocument = this.doc("$comment", (BsonValue)new BsonString("matching FilterAll"));
        } else if (queryFilter instanceof RelationalFilter) {
            RelationalFilter relationalFilter = (RelationalFilter)queryFilter;
            Prop prop = relationalFilter.prop();
            RelationalOp op = relationalFilter.op();
            Object value = relationalFilter.value();
            bsonDocument = ((MongoRead)((Object)this)).mongoRelationalFilter(prop, op, value);
        } else if (queryFilter instanceof ConditionalFilter) {
            Bson bson;
            ConditionalFilter conditionalFilter = (ConditionalFilter)queryFilter;
            QueryFilter lhs = conditionalFilter.lhs();
            LogicalOp op = conditionalFilter.op();
            QueryFilter rhs = conditionalFilter.rhs();
            LogicalOp logicalOp = op;
            if (AndOp$.MODULE$.equals(logicalOp)) {
                bson = Filters.and((Bson[])new Bson[]{this.mongoFilter(lhs), this.mongoFilter(rhs)});
            } else if (OrOp$.MODULE$.equals(logicalOp)) {
                bson = Filters.or((Bson[])new Bson[]{this.mongoFilter(lhs), this.mongoFilter(rhs)});
            } else {
                throw new MatchError((Object)logicalOp);
            }
            bsonDocument = bson;
        } else {
            throw new MatchError(queryFilter);
        }
        return bsonDocument;
    }

    private BsonDocument doc(String key, BsonValue value) {
        return new BsonDocument(key, value);
    }

    private Option<BsonDocument> mongoOrderBy(QueryOrderBy<P> orderBy) {
        None$ none$;
        QueryOrderBy<P> queryOrderBy = orderBy;
        QueryOrderBy queryOrderBy2 = QueryOrderBy$.MODULE$.empty();
        if (!(queryOrderBy != null ? !((Object)queryOrderBy).equals(queryOrderBy2) : queryOrderBy2 != null)) {
            none$ = None$.MODULE$;
        } else {
            BsonDocument document = new BsonDocument();
            orderBy.sortExprs().foreach((Function1 & Serializable & scala.Serializable)sortExpr -> {
                void var3_13;
                int n;
                QuerySortDirection querySortDirection = sortExpr.direction();
                if (Ascending$.MODULE$.equals(querySortDirection)) {
                    n = 1;
                } else {
                    if (!Descending$.MODULE$.equals(querySortDirection)) throw new MatchError((Object)querySortDirection);
                    n = -1;
                }
                int direction = n;
                Prop<Persistent, ?> prop2 = sortExpr.prop();
                Option option = ((BaseRepo)((Object)this)).realizedPType().partitionKey();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    RealizedPartitionKey key = (RealizedPartitionKey)some.value();
                    Prop prop3 = key.prop().prop();
                    Prop<Persistent, ?> prop4 = prop2;
                    if (!(prop3 != null ? !((Object)prop3).equals(prop4) : prop4 != null) && !key.fullyPartitioned()) {
                        Object object = ((TraversableLike)key.props().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.prop(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)prop -> MongoQuery.appendProp$1(prop, document, direction), Seq$.MODULE$.canBuildFrom());
                        return var3_13;
                    }
                }
                BsonDocument bsonDocument = MongoQuery.appendProp$1(prop2, document, direction);
                return var3_13;
            });
            none$ = new Some((Object)document);
        }
        return none$;
    }

    private static BsonDocument appendProp$1(Prop prop, BsonDocument document$1, int direction$1) {
        return document$1.append(prop.path(), (BsonValue)new BsonInt32(direction$1));
    }

    public static void $init$(MongoQuery $this) {
    }
}

