/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.subdomain.Persistent;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001)4\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001\u00034\u0003\u001f\r\u000b7o]1oIJ\fW\u000b\u001d3bi\u0016T!a\u0001\u0003\u0002\u0013\r\f7o]1oIJ\f'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\u0005%93C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001'\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u0015!\tYQ#\u0003\u0002\u0017\u0019\t!QK\\5u\u0011\u0015A\u0002\u0001\"\u0011\u001a\u0003\u0019)\b\u000fZ1uKR\u0011!\u0004\u000f\u000b\u00037M\u00022\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Au\u0011aAR;ukJ,\u0007c\u0001\u0012$K5\tA!\u0003\u0002%\t\t1\u0001k\u0015;bi\u0016\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\t\u0001+\u0005\u0002+[A\u00111bK\u0005\u0003Y1\u0011qAT8uQ&tw\r\u0005\u0002/c5\tqF\u0003\u00021\r\u0005I1/\u001e2e_6\f\u0017N\\\u0005\u0003e=\u0012!\u0002U3sg&\u001cH/\u001a8u\u0011\u0015!t\u0003q\u00016\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001\b\u001c\n\u0005]j\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015It\u00031\u0001\"\u0003\u0015\u0019H/\u0019;f\u0011\u0015Y\u0004\u0001\"\u0003=\u0003M\u0011\u0017N\u001c3Va\u0012\fG/Z*uCR,W.\u001a8u)\ri\u0014J\u0013\t\u0003}\u001dk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bAaY8sK*\u0011!iQ\u0001\u0007IJLg/\u001a:\u000b\u0005\u0011+\u0015\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003\u0019\u000b1aY8n\u0013\tAuH\u0001\bC_VtGm\u0015;bi\u0016lWM\u001c;\t\u000beR\u0004\u0019A\u0011\t\u000b-S\u0004\u0019\u0001\u0006\u0002\u0015I|wOV3sg&|g\u000e\u0003\u0005N\u0001!\u0015\r\u0011\"\u0003O\u0003=)\b\u000fZ1uKN#\u0018\r^3nK:$X#A(\u0011\u0005y\u0002\u0016BA)@\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\u0006'\u0002!I\u0001V\u0001\nkB$\u0017\r^3Dc2,\u0012!\u0016\t\u0003-vs!aV.\u0011\u0005acQ\"A-\u000b\u0005i\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002]\u0019\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF\u0002C\u0003b\u0001\u0011%A+A\td_2,XN\\!tg&<g.\\3oiNDQa\u0019\u0001\u0005\nQ\u000bqc^5uQ>,H\u000fT8dW&tw-\u00169eCR,7)\u001d7\t\u000b\u0015\u0004A\u0011\u0002+\u0002)]LG\u000f\u001b'pG.LgnZ+qI\u0006$XmQ9m!\r9\u0007.J\u0007\u0002\u0005%\u0011\u0011N\u0001\u0002\u000e\u0007\u0006\u001c8/\u00198ee\u0006\u0014V\r]8")
public interface CassandraUpdate<P extends Persistent> {
    public static /* synthetic */ Future update$(CassandraUpdate $this, PState state, ExecutionContext context) {
        return $this.update(state, context);
    }

    default public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean updateSuccess;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling CassandraRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((BaseRepo)((Object)this)).validateStablePartitionKey(state);
            PState newState = state.update(((CassandraRepo)this).persistenceConfig().optimisticLocking());
            ResultSet resultSet = (ResultSet)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> ((CassandraRepo)this).session().execute((Statement)this.bindUpdateStatement(newState, state.rowVersionOrNull())));
            if (((CassandraRepo)this).persistenceConfig().optimisticLocking() && !(updateSuccess = resultSet.one().getBool(0))) {
                throw new WriteConflictException(state);
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling CassandraRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    private BoundStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        BoxedUnit boxedUnit;
        Seq columnBindings;
        Seq seq;
        if (((CassandraRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((CassandraRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((CassandraRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((CassandraRepo)this).updateColumnValues(state, false);
            seq = columnBindings = (Seq)((CassandraRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking CQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().getQueryString(), columnBindings})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().bind((Object[])columnBindings.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public static /* synthetic */ PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(CassandraUpdate $this) {
        return $this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement();
    }

    default public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return ((CassandraRepo)this).preparedStatement(this.updateCql());
    }

    private String updateCql() {
        return ((CassandraRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateCql() : this.withoutLockingUpdateCql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((CassandraRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), this.columnAssignments(), ((CassandraRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |IF\n  |  row_version = :row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateCql()})))).stripMargin();
    }

    public static void $init$(CassandraUpdate $this) {
    }
}

