/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.persistence.BaseRepo;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.cassandra.CassandraRepo$;
import longevity.subdomain.Persistent;
import longevity.subdomain.realized.RealizedPropComponent;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}bAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u00028\ty1)Y:tC:$'/Y*dQ\u0016l\u0017M\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV\u0011\u0011BW\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0019\u0012A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003Q\u0001\"aC\u000b\n\u0005Ya!\u0001B+oSRDa\u0001\u0007\u0001\u0005\u0012\u0011I\u0012\u0001D2sK\u0006$XmU2iK6\fG#\u0001\u000e\u0015\u0005m\t\u0003c\u0001\u000f )5\tQD\u0003\u0002\u001f\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0001j\"A\u0002$viV\u0014X\rC\u0003#/\u0001\u000f1%A\u0004d_:$X\r\u001f;\u0011\u0005q!\u0013BA\u0013\u001e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003(\u0001\u0011E1#A\u0006de\u0016\fG/\u001a+bE2,\u0007\"B\u0015\u0001\t\u0013Q\u0013!B5e\t\u00164W#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t11\u000b\u001e:j]\u001eDQ\u0001\u000e\u0001\u0005\nU\nQ$Y2uk\u0006d\u0017N_3e\u0007>l\u0007o\u001c8f]R\u001cu\u000e\\;n]\u0012+gm]\u000b\u0002mA\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\u0007\u000e\u0003iR!a\u000f\n\u0002\rq\u0012xn\u001c;?\u0013\tiD\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003e}R!!\u0010\u0007\t\u000b\u0005\u0003A\u0011B\u001b\u0002\u001bA\u0014\u0018.\\1ss.+\u0017\u0010R3g\u0011\u0015\u0019\u0005\u0001\"\u00036\u0003A\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000fC\u0003F\u0001\u0011%Q'\u0001\u000bq_N$\b+\u0019:uSRLwN\\\"pYVlgn\u001d\u0005\u0006\u000f\u0002!I\u0001S\u0001\nG>dW/\u001c8EK\u001a$\"AN%\t\u000b)3\u0005\u0019A&\u0002\u0013\r|W\u000e]8oK:$\b\u0007\u0002'WK2\u0004R!\u0014*UI.l\u0011A\u0014\u0006\u0003\u001fB\u000b\u0001B]3bY&TX\r\u001a\u0006\u0003#\u001a\t\u0011b];cI>l\u0017-\u001b8\n\u0005Ms%!\u0006*fC2L'0\u001a3Qe>\u00048i\\7q_:,g\u000e\u001e\t\u0003+Zc\u0001\u0001B\u0005X\u0013\u0006\u0005\t\u0011!B\u00011\n\u0019q\fJ\u0019\u0012\u0005e\u0003\u0007CA+[\t\u0015Y\u0006A1\u0001]\u0005\u0005\u0001\u0016CA/a!\tYa,\u0003\u0002`\u0019\t9aj\u001c;iS:<\u0007CA1c\u001b\u0005\u0001\u0016BA2Q\u0005)\u0001VM]:jgR,g\u000e\u001e\t\u0003+\u0016$\u0011BZ%\u0002\u0002\u0003\u0005)\u0011A4\u0003\u0007}##'\u0005\u0002^QB\u00111\"[\u0005\u0003U2\u00111!\u00118z!\t)F\u000eB\u0005n\u0013\u0006\u0005\t\u0011!B\u0001O\n\u0019q\fJ\u001a\t\u000b=\u0004A\u0011\u00039\u0002\u0013\u0005$GmQ8mk6tGc\u0001\u000brg\")!O\u001ca\u0001m\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000bQt\u0007\u0019\u0001\u001c\u0002\u0015\r|G.^7o)f\u0004X\rC\u0003w\u0001\u0011Eq/\u0001\rd_6\u0004xN\\3oiR{7)Y:tC:$'/\u0019+za\u0016,2\u0001_A\u0004)\t1\u0014\u0010C\u0003Kk\u0002\u0007!\u0010\r\u0003|{\u0006\u0005\u0001CB'Sy~\f)\u0001\u0005\u0002V{\u0012Ia0_A\u0001\u0002\u0003\u0015\t\u0001\u0017\u0002\u0004?\u0012\"\u0004cA+\u0002\u0002\u0011Q\u00111A=\u0002\u0002\u0003\u0005)\u0011A4\u0003\u0007}#S\u0007E\u0002V\u0003\u000f!a!!\u0003v\u0005\u00049'!A!\t\r\u00055\u0001\u0001\"\u0005\u0014\u00035\u0019'/Z1uK&sG-\u001a=fg\"9\u0011\u0011\u0003\u0001\u0005\u0012\u0005M\u0011aC2sK\u0006$X-\u00138eKb$2\u0001FA\u000b\u0011\u001dQ\u0015q\u0002a\u0001\u0003/\u0001\u0004\"!\u0007\u0002\u001e\u0005\r\u0012\u0011\u0006\t\t\u001bJ\u000bY\"!\t\u0002(A\u0019Q+!\b\u0005\u0017\u0005}\u0011QCA\u0001\u0002\u0003\u0015\t\u0001\u0017\u0002\u0004?\u00122\u0004cA+\u0002$\u0011Y\u0011QEA\u000b\u0003\u0003\u0005\tQ!\u0001h\u0005\ryFe\u000e\t\u0004+\u0006%BaCA\u0016\u0003+\t\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00139\u0011\u001d\t\t\u0002\u0001C\t\u0003_!R\u0001FA\u0019\u0003kAq!a\r\u0002.\u0001\u0007a'A\u0005j]\u0012,\u0007PT1nK\"1!/!\fA\u0002Y\u0002R!!\u000f\u0002<ek\u0011AA\u0005\u0004\u0003{\u0011!!D\"bgN\fg\u000e\u001a:b%\u0016\u0004x\u000e")
public interface CassandraSchema<P extends Persistent> {
    public static /* synthetic */ Future createSchema$(CassandraSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createIndexes();
            if (((CassandraRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(CassandraSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", ",\n    |  ", "\n    |)\n    |WITH COMPRESSION = { 'sstable_compression': 'SnappyCompressor' };\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createTable);
    }

    private String idDef() {
        return ((BaseRepo)((Object)this)).hasPartitionKey() ? "" : "\n  id uuid,";
    }

    private String actualizedComponentColumnDefs() {
        return ((TraversableOnce)((CassandraRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component -> this.columnDef((RealizedPropComponent<? extends Persistent, ?, ?>)component), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String primaryKeyDef() {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(((BaseRepo)((Object)this)).hasPartitionKey(), ((CassandraRepo)this).postPartitionComponents().nonEmpty());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns(), this.postPartitionColumns()}));
            }
        }
        if (sp2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (!bl || bl3) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()}));
    }

    private String partitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String postPartitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).postPartitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? extends Persistent, ?, ?> component) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).columnName(component), this.componentToCassandraType(component)}));
    }

    public static /* synthetic */ void addColumn$(CassandraSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String cql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            ((CassandraRepo)this).session().execute(cql);
        }
        catch (Throwable throwable) {
            InvalidQueryException invalidQueryException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().contains("because it conflicts with an existing column")) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ String componentToCassandraType$(CassandraSchema $this, RealizedPropComponent component) {
        return $this.componentToCassandraType(component);
    }

    default public <A> String componentToCassandraType(RealizedPropComponent<? extends Persistent, ?, A> component) {
        return (String)CassandraRepo$.MODULE$.basicToCassandraType().apply(component.componentTypeKey());
    }

    public static /* synthetic */ void createIndexes$(CassandraSchema $this) {
        $this.createIndexes();
    }

    default public void createIndexes() {
        ((CassandraRepo)this).indexedComponents().foreach((Function1 & Serializable & scala.Serializable)component -> {
            this.createIndex(component);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, RealizedPropComponent component) {
        $this.createIndex(component);
    }

    default public void createIndex(RealizedPropComponent<? extends Persistent, ?, ?> component) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), ((CassandraRepo)this).scoredPath(component)}));
        this.createIndex(indexName, ((CassandraRepo)this).columnName(component));
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, String indexName, String columnName) {
        $this.createIndex(indexName, columnName);
    }

    default public void createIndex(String indexName, String columnName) {
        BoxedUnit boxedUnit;
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE INDEX IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexName, ((CassandraRepo)this).tableName(), columnName}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createIndex);
    }

    public static void $init$(CassandraSchema $this) {
    }
}

