/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence;

import emblem.TypeKey;
import emblem.TypeKeyMap;
import emblem.TypeKeyMap$;
import emblem.typeBound.TypeBoundPair;
import java.io.Serializable;
import longevity.context.BackEnd;
import longevity.context.Cassandra$;
import longevity.context.CassandraConfig;
import longevity.context.InMem$;
import longevity.context.LongevityConfig;
import longevity.context.Mongo$;
import longevity.context.MongoConfig;
import longevity.context.PersistenceConfig;
import longevity.persistence.BaseRepo;
import longevity.persistence.RepoPool;
import longevity.persistence.RepoPoolBuilder;
import longevity.persistence.RepoPoolBuilder$repoFactory$4$;
import longevity.persistence.RepoPoolBuilder$repoFactory$5$;
import longevity.persistence.RepoPoolBuilder$repoFactory$6$;
import longevity.persistence.SchemaCreator;
import longevity.persistence.SchemaCreator$;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.mongo.MongoRepo;
import longevity.subdomain.DerivedPType;
import longevity.subdomain.PType;
import longevity.subdomain.Persistent;
import longevity.subdomain.PolyPType;
import longevity.subdomain.Subdomain;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;

public final class RepoPoolBuilder$ {
    public static RepoPoolBuilder$ MODULE$;

    static {
        new RepoPoolBuilder$();
    }

    public RepoPool buildRepoPool(Subdomain subdomain, BackEnd backEnd, LongevityConfig config, boolean test) {
        RepoPool repoPool;
        BackEnd backEnd2 = backEnd;
        if (InMem$.MODULE$.equals(backEnd2)) {
            repoPool = this.inMemTestRepoPool(subdomain, config);
        } else if (Mongo$.MODULE$.equals(backEnd2)) {
            MongoConfig mongoConfig = test ? config.test().mongodb() : config.mongodb();
            repoPool = this.mongoRepoPool(subdomain, new MongoRepo.MongoSessionInfo(mongoConfig), config);
        } else if (Cassandra$.MODULE$.equals(backEnd2)) {
            CassandraConfig cassandraConfig = test ? config.test().cassandra() : config.cassandra();
            repoPool = this.cassandraRepoPool(subdomain, new CassandraRepo.CassandraSessionInfo(cassandraConfig), config);
        } else {
            throw new MatchError((Object)backEnd2);
        }
        RepoPool pool = repoPool;
        Object object = config.autocreateSchema() ? Await$.MODULE$.result(pool.createSchema((ExecutionContext)ExecutionContext$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(1L, "seconds")) : BoxedUnit.UNIT;
        return pool;
    }

    private RepoPool inMemTestRepoPool(Subdomain subdomain, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(subdomain, this.repoFactory$1(subdomain, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private RepoPool mongoRepoPool(Subdomain subdomain, MongoRepo.MongoSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(subdomain, this.repoFactory$2(subdomain, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private RepoPool cassandraRepoPool(Subdomain subdomain, CassandraRepo.CassandraSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(subdomain, this.repoFactory$3(subdomain, session, persistenceConfig, repoFactory$module), session, persistenceConfig);
    }

    private <R extends BaseRepo<Persistent>> RepoPool buildRepoPool(Subdomain subdomain, RepoPoolBuilder.StockRepoFactory<R> stockRepoFactory, SchemaCreator schemaCreator, PersistenceConfig persistenceConfig) {
        ObjectRef keyToRepoMap = ObjectRef.create((Object)TypeKeyMap$.MODULE$.apply());
        subdomain.pTypePool().filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)this.isPolyPType((TypeBoundPair<Persistent, TypeKey, PType, ? extends Persistent>)pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoPoolBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        subdomain.pTypePool().filterNot((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)this.isPolyPType((TypeBoundPair<Persistent, TypeKey, PType, ? extends Persistent>)pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoPoolBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        RepoPool repoPool = new RepoPool((TypeKeyMap<Persistent, BaseRepo>)((TypeKeyMap)keyToRepoMap.elem).widen(), schemaCreator);
        this.finishRepoInitialization(repoPool);
        this.autocreateSchema(repoPool, persistenceConfig);
        return repoPool;
    }

    private boolean isPolyPType(TypeBoundPair<Persistent, TypeKey, PType, ? extends Persistent> pair) {
        return pair._2() instanceof PolyPType;
    }

    private void finishRepoInitialization(RepoPool repoPool) {
        repoPool.baseRepoMap().values().foreach((Function1 & Serializable & scala.Serializable)repo -> {
            repo._repoPoolOption_$eq((Option<RepoPool>)new Some((Object)repoPool));
            return BoxedUnit.UNIT;
        });
    }

    private void autocreateSchema(RepoPool repoPool, PersistenceConfig persistenceConfig) {
        block0: {
            if (!persistenceConfig.autocreateSchema()) break block0;
            Await$.MODULE$.result(repoPool.createSchema(ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(10L, "seconds"));
        }
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$4$ repoFactory$lzycompute$1(Subdomain subdomain$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        RepoPoolBuilder$repoFactory$4$ repoPoolBuilder$repoFactory$4$;
        LazyRef lazyRef = repoFactory$module$1;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$4$ = repoFactory$module$1.initialized() ? (RepoPoolBuilder$repoFactory$4$)repoFactory$module$1.value() : (RepoPoolBuilder$repoFactory$4$)repoFactory$module$1.initialize((Object)new RepoPoolBuilder$repoFactory$4$(subdomain$1, persistenceConfig$1));
        }
        return repoPoolBuilder$repoFactory$4$;
    }

    private final RepoPoolBuilder$repoFactory$4$ repoFactory$1(Subdomain subdomain$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        return repoFactory$module$1.initialized() ? (RepoPoolBuilder$repoFactory$4$)repoFactory$module$1.value() : RepoPoolBuilder$.repoFactory$lzycompute$1(subdomain$1, persistenceConfig$1, repoFactory$module$1);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$5$ repoFactory$lzycompute$2(Subdomain subdomain$2, MongoRepo.MongoSessionInfo session$1, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        RepoPoolBuilder$repoFactory$5$ repoPoolBuilder$repoFactory$5$;
        LazyRef lazyRef = repoFactory$module$2;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$5$ = repoFactory$module$2.initialized() ? (RepoPoolBuilder$repoFactory$5$)repoFactory$module$2.value() : (RepoPoolBuilder$repoFactory$5$)repoFactory$module$2.initialize((Object)new RepoPoolBuilder$repoFactory$5$(subdomain$2, session$1, persistenceConfig$2));
        }
        return repoPoolBuilder$repoFactory$5$;
    }

    private final RepoPoolBuilder$repoFactory$5$ repoFactory$2(Subdomain subdomain$2, MongoRepo.MongoSessionInfo session$1, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        return repoFactory$module$2.initialized() ? (RepoPoolBuilder$repoFactory$5$)repoFactory$module$2.value() : RepoPoolBuilder$.repoFactory$lzycompute$2(subdomain$2, session$1, persistenceConfig$2, repoFactory$module$2);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$6$ repoFactory$lzycompute$3(Subdomain subdomain$3, CassandraRepo.CassandraSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        RepoPoolBuilder$repoFactory$6$ repoPoolBuilder$repoFactory$6$;
        LazyRef lazyRef = repoFactory$module$3;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$6$ = repoFactory$module$3.initialized() ? (RepoPoolBuilder$repoFactory$6$)repoFactory$module$3.value() : (RepoPoolBuilder$repoFactory$6$)repoFactory$module$3.initialize((Object)new RepoPoolBuilder$repoFactory$6$(subdomain$3, session$2, persistenceConfig$3));
        }
        return repoPoolBuilder$repoFactory$6$;
    }

    private final RepoPoolBuilder$repoFactory$6$ repoFactory$3(Subdomain subdomain$3, CassandraRepo.CassandraSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        return repoFactory$module$3.initialized() ? (RepoPoolBuilder$repoFactory$6$)repoFactory$module$3.value() : RepoPoolBuilder$.repoFactory$lzycompute$3(subdomain$3, session$2, persistenceConfig$3, repoFactory$module$3);
    }

    private static final void createRepoFromPair$1(TypeBoundPair pair, RepoPoolBuilder.StockRepoFactory stockRepoFactory$1, ObjectRef keyToRepoMap$1) {
        None$ none$;
        TypeKey pTypeKey = (TypeKey)pair._1();
        PType pType = (PType)pair._2();
        PType pType2 = pType;
        if (pType2 instanceof DerivedPType) {
            DerivedPType derivedPType = (DerivedPType)pType2;
            none$ = new Some(derivedPType.polyPTypeKey());
        } else {
            none$ = None$.MODULE$;
        }
        None$ polyKey = none$;
        Object repo = stockRepoFactory$1.build(pType, polyKey.map((Function1 & Serializable & scala.Serializable)x$1 -> (BaseRepo)((TypeKeyMap)keyToRepoMap$1.elem).apply(x$1)));
        keyToRepoMap$1.elem = ((TypeKeyMap)keyToRepoMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pTypeKey), repo), Predef$.MODULE$.$conforms());
    }

    private RepoPoolBuilder$() {
        MODULE$ = this;
    }
}

