/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.turn;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatus;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatusAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;

public class ConnectionStatusIndication
extends AbstractStunMessage {
    private final InetSocketAddress m_remoteAddress;
    private final ConnectionStatus m_connectionStatus;

    public ConnectionStatusIndication(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.CONNECTION_STATUS_INDICATION, attributes);
        RemoteAddressAttribute att = (RemoteAddressAttribute)attributes.get((Object)StunAttributeType.REMOTE_ADDRESS);
        this.m_remoteAddress = att.getInetSocketAddress();
        ConnectionStatusAttribute csa = (ConnectionStatusAttribute)attributes.get((Object)StunAttributeType.CONNECT_STAT);
        this.m_connectionStatus = csa.getConnectionStatus();
    }

    public ConnectionStatusIndication(InetSocketAddress remoteAddress, ConnectionStatus connectionStatus) {
        super(UUID.randomUUID(), StunMessageType.CONNECTION_STATUS_INDICATION, ConnectionStatusIndication.createAttributes(remoteAddress, connectionStatus));
        this.m_remoteAddress = remoteAddress;
        this.m_connectionStatus = connectionStatus;
    }

    private static Map<StunAttributeType, StunAttribute> createAttributes(InetSocketAddress remoteAddress, ConnectionStatus connectionStatus) {
        ConcurrentHashMap<StunAttributeType, StunAttribute> attributes = new ConcurrentHashMap<StunAttributeType, StunAttribute>();
        RemoteAddressAttribute remoteAddressAttribute = new RemoteAddressAttribute(remoteAddress);
        ConnectionStatusAttribute status = new ConnectionStatusAttribute(connectionStatus);
        attributes.put(remoteAddressAttribute.getAttributeType(), remoteAddressAttribute);
        attributes.put(status.getAttributeType(), status);
        return attributes;
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitConnectionStatusIndication(this);
    }

    public ConnectionStatus getConnectionStatus() {
        return this.m_connectionStatus;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.m_remoteAddress;
    }
}

