/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.turn;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.MappedAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.turn.RelayAddressAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllocateSuccessResponse
extends AbstractStunMessage {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress m_mappedAddress;
    private final InetSocketAddress m_relayAddress;

    public AllocateSuccessResponse(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.ALLOCATE_SUCCESS_RESPONSE, attributes);
        MappedAddressAttribute ma = (MappedAddressAttribute)attributes.get((Object)StunAttributeType.MAPPED_ADDRESS);
        RelayAddressAttribute ra = (RelayAddressAttribute)attributes.get((Object)StunAttributeType.RELAY_ADDRESS);
        this.m_mappedAddress = ma.getInetSocketAddress();
        this.m_relayAddress = ra.getInetSocketAddress();
    }

    public AllocateSuccessResponse(UUID transactionId, InetSocketAddress relayAddress, InetSocketAddress mappedAddress) {
        super(transactionId, StunMessageType.ALLOCATE_SUCCESS_RESPONSE, AllocateSuccessResponse.createAttributes(relayAddress, mappedAddress));
        this.m_mappedAddress = mappedAddress;
        this.m_relayAddress = relayAddress;
    }

    private static Map<StunAttributeType, StunAttribute> createAttributes(InetSocketAddress relayAddress, InetSocketAddress mappedAddress) {
        RelayAddressAttribute ra = new RelayAddressAttribute(relayAddress);
        MappedAddressAttribute ma = new MappedAddressAttribute(mappedAddress);
        return AllocateSuccessResponse.createAttributes(ra, ma);
    }

    public InetSocketAddress getMappedAddress() {
        return this.m_mappedAddress;
    }

    public InetSocketAddress getRelayAddress() {
        return this.m_relayAddress;
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitAllocateSuccessResponse(this);
    }
}

