/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes.ice;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.support.ByteBufferHexDumper;
import org.littleshoot.stun.stack.message.attributes.AbstractStunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.StunAttributeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IceControllingAttribute
extends AbstractStunAttribute {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final byte[] m_tieBreaker;

    public IceControllingAttribute(byte[] tieBreaker) {
        super(StunAttributeType.ICE_CONTROLLING, tieBreaker.length);
        this.m_tieBreaker = tieBreaker;
    }

    public byte[] getTieBreaker() {
        return this.m_tieBreaker;
    }

    @Override
    public void accept(StunAttributeVisitor visitor) {
        visitor.visitIceControlling(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" with tie breaker: ");
        ByteBuffer buf = ByteBuffer.wrap((byte[])this.m_tieBreaker);
        sb.append(ByteBufferHexDumper.getHexdump((ByteBuffer)buf));
        return sb.toString();
    }
}

