/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes;

import java.io.UnsupportedEncodingException;
import org.littleshoot.stun.stack.message.attributes.AbstractStunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.StunAttributeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCodeAttribute
extends AbstractStunAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCodeAttribute.class);
    private final int m_errorClass;
    private final int m_errorNumber;
    private final CharSequence m_reasonPhrase;
    private int m_errorCode;

    public ErrorCodeAttribute(int code, String reasonPhrase) {
        this((int)Math.floor(code / 100), code % 100, reasonPhrase);
    }

    public ErrorCodeAttribute(int errorClass, int errorNumber, String reasonPhrase) {
        super(StunAttributeType.ERROR_CODE, ErrorCodeAttribute.calculateBodyLength(reasonPhrase));
        if (errorClass < 3 || errorClass > 6) {
            throw new IllegalArgumentException("Bad class of " + errorClass);
        }
        if (errorNumber < 0 || errorNumber > 99) {
            throw new IllegalArgumentException("Bad error # of " + errorNumber);
        }
        this.m_errorClass = errorClass;
        this.m_errorNumber = errorNumber;
        this.m_reasonPhrase = reasonPhrase;
    }

    private static int calculateBodyLength(String reasonPhrase) {
        if (reasonPhrase.length() > 128) {
            LOG.warn("Reason phrase is too long: " + reasonPhrase);
            throw new IllegalArgumentException("Reason phrase is too long: " + reasonPhrase);
        }
        try {
            return 4 + reasonPhrase.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Bad encoding?", (Throwable)e);
            return 4 + reasonPhrase.length();
        }
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public int getErrorClass() {
        return this.m_errorClass;
    }

    public int getErrorNumber() {
        return this.m_errorNumber;
    }

    public CharSequence getReasonPhrase() {
        return this.m_reasonPhrase;
    }

    @Override
    public void accept(StunAttributeVisitor visitor) {
        visitor.visiteErrorCode(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.m_errorClass + this.m_errorNumber + " " + this.m_reasonPhrase;
    }
}

