/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.decoder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.StunAttributesFactoryImpl;
import org.littleshoot.stun.stack.message.turn.AllocateErrorResponse;
import org.littleshoot.stun.stack.message.turn.AllocateRequest;
import org.littleshoot.stun.stack.message.turn.AllocateSuccessResponse;
import org.littleshoot.stun.stack.message.turn.ConnectRequest;
import org.littleshoot.stun.stack.message.turn.ConnectionStatusIndication;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.littleshoot.stun.stack.message.turn.SendIndication;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.FixedLengthDecodingState;
import org.littleshoot.util.mina.MinaUtils;
import org.littleshoot.util.mina.decode.binary.UnsignedShortDecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunMessageDecodingState
extends DecodingStateMachine {
    private static final Logger m_log = LoggerFactory.getLogger(StunMessageDecodingState.class);
    private static final Map<StunAttributeType, StunAttribute> EMPTY_ATTRIBUTES = Collections.emptyMap();

    protected DecodingState init() throws Exception {
        m_log.debug("Initing...");
        return new ReadMessageType();
    }

    protected void destroy() throws Exception {
    }

    protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
        m_log.error("Got finish decode for full message");
        return null;
    }

    private static StunMessage createMessage(int type, byte[] transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        UUID id = new UUID(transactionId);
        StunMessageType messageType = StunMessageType.toType(type);
        if (messageType == null) {
            m_log.warn("Unrecognized type: " + type);
            throw new IllegalArgumentException("Unrecognized type: " + type);
        }
        m_log.debug("Decoded STUN message type: {}", (Object)messageType);
        switch (messageType) {
            case BINDING_REQUEST: {
                return new BindingRequest(id, attributes);
            }
            case BINDING_SUCCESS_RESPONSE: {
                return new BindingSuccessResponse(id, attributes);
            }
            case BINDING_ERROR_RESPONSE: {
                return new BindingErrorResponse(id, attributes);
            }
            case ALLOCATE_REQUEST: {
                return new AllocateRequest(id);
            }
            case ALLOCATE_SUCCESS_RESPONSE: {
                return new AllocateSuccessResponse(id, attributes);
            }
            case ALLOCATE_ERROR_RESPONSE: {
                return new AllocateErrorResponse(id, attributes);
            }
            case DATA_INDICATION: {
                return new DataIndication(id, attributes);
            }
            case SEND_INDICATION: {
                return new SendIndication(id, attributes);
            }
            case CONNECT_REQUEST: {
                return new ConnectRequest(id, attributes);
            }
            case CONNECTION_STATUS_INDICATION: {
                return new ConnectionStatusIndication(id, attributes);
            }
        }
        m_log.error("Could not understand message type: " + type);
        return null;
    }

    private static class ReadBody
    extends FixedLengthDecodingState {
        private final int m_type;
        private final byte[] m_transactionId;

        private ReadBody(int type, int length, byte[] transactionId) {
            super(length);
            this.m_type = type;
            this.m_transactionId = transactionId;
        }

        protected DecodingState finishDecode(ByteBuffer readData, ProtocolDecoderOutput out) throws Exception {
            if (readData.remaining() != this.m_length) {
                m_log.error("Read body of unexpected length.\nExpected length:  " + this.m_length + "\nRemaining length: " + readData.remaining());
            }
            StunAttributesFactoryImpl factory = new StunAttributesFactoryImpl();
            Map<StunAttributeType, StunAttribute> attributes = factory.createAttributes(readData);
            StunMessage message = StunMessageDecodingState.createMessage(this.m_type, this.m_transactionId, attributes);
            out.write((Object)message);
            return null;
        }
    }

    private static class ReadTransactionId
    extends FixedLengthDecodingState {
        private final int m_messageType;
        private final int m_messageLength;

        private ReadTransactionId(int messageType, int messageLength) {
            super(16);
            this.m_messageType = messageType;
            this.m_messageLength = messageLength;
        }

        protected DecodingState finishDecode(ByteBuffer readData, ProtocolDecoderOutput out) throws Exception {
            byte[] transactionId = MinaUtils.toByteArray((ByteBuffer)readData);
            m_log.debug("Read transaction id...");
            if (this.m_messageLength > 0) {
                return new ReadBody(this.m_messageType, this.m_messageLength, transactionId);
            }
            m_log.debug("Handling empty body");
            StunMessage message = StunMessageDecodingState.createMessage(this.m_messageType, transactionId, EMPTY_ATTRIBUTES);
            out.write((Object)message);
            return null;
        }
    }

    private static class ReadMessageLength
    extends UnsignedShortDecodingState {
        private final int m_messageType;

        private ReadMessageLength(int messageType) {
            this.m_messageType = messageType;
        }

        protected DecodingState finishDecode(int decoded, ProtocolDecoderOutput out) throws Exception {
            m_log.debug("Read message length: " + decoded);
            return new ReadTransactionId(this.m_messageType, decoded);
        }
    }

    private static class ReadMessageType
    extends UnsignedShortDecodingState {
        private ReadMessageType() {
        }

        protected DecodingState finishDecode(int decoded, ProtocolDecoderOutput out) throws Exception {
            return new ReadMessageLength(decoded);
        }
    }
}

