/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolEncoder;
import org.littleshoot.stun.stack.decoder.StunMessageDecodingState;
import org.littleshoot.stun.stack.encoder.StunProtocolEncoder;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.DemuxableProtocolCodecFactory;
import org.littleshoot.util.mina.DemuxableProtocolDecoder;
import org.littleshoot.util.mina.DemuxingStateMachineProtocolDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunDemuxableProtocolCodecFactory
implements DemuxableProtocolCodecFactory<StunMessage> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecode(ByteBuffer in) {
        if (!this.enoughData(in)) {
            throw new IllegalArgumentException("Not enough data to determine if we can decode it or not!!");
        }
        int pos = in.position();
        int limit = in.limit();
        try {
            short firstByte = in.getUnsigned();
            int masked = firstByte & 0xC0;
            if (masked > 0) {
                boolean bl = false;
                return bl;
            }
            long magicCookie = 554869826L;
            long secondFourBytes = in.getUnsignedInt(pos + 4);
            boolean magicCookieMatches = secondFourBytes == 554869826L;
            this.m_log.debug("Magic cookie matches: " + magicCookieMatches);
            boolean bl = magicCookieMatches;
            return bl;
        }
        finally {
            in.position(pos);
            in.limit(limit);
        }
    }

    public Class<StunMessage> getClassToEncode() {
        return StunMessage.class;
    }

    public DemuxableProtocolDecoder newDecoder() {
        StunMessageDecodingState startState = new StunMessageDecodingState();
        return new DemuxingStateMachineProtocolDecoder((DecodingStateMachine)startState);
    }

    public ProtocolEncoder newEncoder() {
        return new StunProtocolEncoder();
    }

    public boolean enoughData(ByteBuffer in) {
        return in.remaining() >= 8;
    }
}

