/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import org.litote.kmongo.jackson.KMongoBsonFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u001a\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006!"}, d2={"Lorg/litote/kmongo/jackson/BsonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "BinaryBsonDeserializer", "BinaryBsonSerializer", "BsonTimestampBsonDeserializer", "BsonTimestampBsonSerializer", "Companion", "InstantBsonDeserializer", "InstantBsonSerializer", "LocalDateBsonDeserializer", "LocalDateBsonSerializer", "LocalDateTimeBsonDeserializer", "LocalDateTimeBsonSerializer", "LocalTimeBsonDeserializer", "LocalTimeBsonSerializer", "MaxKeyBsonDeserializer", "MaxKeyBsonSerializer", "MinKeyBsonDeserializer", "MinKeyBsonSerializer", "ObjectIdBsonSerializer", "OffsetDateTimeBsonDeserializer", "OffsetDateTimeBsonSerializer", "OffsetTimeBsonDeserializer", "OffsetTimeBsonSerializer", "TemporalBsonDeserializer", "TemporalBsonSerializer", "ZonedDateTimeBsonDeserializer", "ZonedDateTimeBsonSerializer", "kmongo-shared"})
public final class BsonModule
extends SimpleModule {
    private static final boolean oldZoneIdBehaviour;
    public static final Companion Companion;

    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.setupModule(context);
        context.appendAnnotationIntrospector((AnnotationIntrospector)KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    public BsonModule() {
        this.addSerializer(ObjectId.class, ObjectIdBsonSerializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryBsonSerializer.INSTANCE);
        this.addDeserializer(Binary.class, BinaryBsonDeserializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampBsonSerializer.INSTANCE);
        this.addDeserializer(BsonTimestamp.class, BsonTimestampBsonDeserializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MaxKey.class, MaxKeyBsonDeserializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MinKey.class, MinKeyBsonDeserializer.INSTANCE);
        this.addSerializer(Instant.class, InstantBsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateBsonSerializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, LocalDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalTime.class, LocalTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeBsonSerializer.INSTANCE);
        this.addDeserializer(Instant.class, InstantBsonDeserializer.INSTANCE);
        this.addDeserializer(ZonedDateTime.class, ZonedDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, OffsetDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDate.class, LocalDateBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDateTime.class, LocalDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalTime.class, LocalTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetTime.class, OffsetTimeBsonDeserializer.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        oldZoneIdBehaviour = System.getProperty("kmongo.oldLocalBehaviour") != null;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ObjectIdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/ObjectId;", "()V", "serialize", "", "objectId", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-shared"})
    private static final class ObjectIdBsonSerializer
    extends JsonSerializer<ObjectId> {
        public static final ObjectIdBsonSerializer INSTANCE;

        public void serialize(@NotNull ObjectId objectId, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)objectId, (String)"objectId");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                gen.writeObjectId((Object)objectId);
            } else {
                ExtendedJsonModule.ObjectIdExtendedJsonSerializer.INSTANCE.serialize(objectId, gen, serializerProvider);
            }
        }

        private ObjectIdBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new ObjectIdBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/BsonTimestamp;", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-shared"})
    private static final class BsonTimestampBsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        public static final BsonTimestampBsonSerializer INSTANCE;

        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBsonTimestamp(obj);
            } else {
                ExtendedJsonModule.BsonTimestampExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }

        private BsonTimestampBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new BsonTimestampBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/BsonTimestamp;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-shared"})
    private static final class BsonTimestampBsonDeserializer
    extends JsonDeserializer<BsonTimestamp> {
        public static final BsonTimestampBsonDeserializer INSTANCE;

        @NotNull
        public BsonTimestamp deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode timestamp = tree.get("$timestamp");
                TreeNode treeNode = timestamp.get("t");
                if (treeNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int time = ((ValueNode)treeNode).asInt();
                TreeNode treeNode2 = timestamp.get("i");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int inc = ((ValueNode)treeNode2).asInt();
                return new BsonTimestamp(time, inc);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonTimestamp");
                }
                return (BsonTimestamp)object;
            }
            Object object = ctxt.handleUnexpectedToken(BsonTimestamp.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonTimestamp");
            }
            return (BsonTimestamp)object;
        }

        private BsonTimestampBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new BsonTimestampBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/Binary;", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-shared"})
    private static final class BinaryBsonSerializer
    extends JsonSerializer<Binary> {
        public static final BinaryBsonSerializer INSTANCE;

        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBinary(obj);
            } else {
                ExtendedJsonModule.BinaryExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }

        private BinaryBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new BinaryBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/Binary;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-shared"})
    private static final class BinaryBsonDeserializer
    extends JsonDeserializer<Binary> {
        public static final BinaryBsonDeserializer INSTANCE;

        @NotNull
        public Binary deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                String string;
                TreeNode treeNode = tree.get("$binary");
                if (treeNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                byte[] binary = Base64Variants.MIME_NO_LINEFEEDS.decode(((ValueNode)treeNode).asText());
                TreeNode treeNode2 = tree.get("$type");
                if (treeNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                String string2 = string = ((ValueNode)treeNode2).asText();
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                Integer n = Integer.valueOf(string3, 16);
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                byte type = (byte)n.intValue();
                return new Binary(type, binary);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.Binary");
                }
                return (Binary)object;
            }
            if (tree instanceof BinaryNode) {
                return new Binary(((BinaryNode)tree).binaryValue());
            }
            Object object = ctxt.handleUnexpectedToken(ObjectId.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.Binary");
            }
            return (Binary)object;
        }

        private BinaryBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new BinaryBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MaxKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-shared"})
    private static final class MaxKeyBsonSerializer
    extends JsonSerializer<MaxKey> {
        public static final MaxKeyBsonSerializer INSTANCE;

        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMaxKey();
            } else {
                ExtendedJsonModule.MaxKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }

        private MaxKeyBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new MaxKeyBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MaxKey;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-shared"})
    private static final class MaxKeyBsonDeserializer
    extends JsonDeserializer<MaxKey> {
        public static final MaxKeyBsonDeserializer INSTANCE;

        @NotNull
        public MaxKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$maxKey");
                if (treeNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MaxKey();
                }
                Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
                }
                return (MaxKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
                }
                return (MaxKey)object;
            }
            if (tree instanceof TextNode) {
                return new MaxKey();
            }
            Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MaxKey");
            }
            return (MaxKey)object;
        }

        private MaxKeyBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new MaxKeyBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MinKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-shared"})
    private static final class MinKeyBsonSerializer
    extends JsonSerializer<MinKey> {
        public static final MinKeyBsonSerializer INSTANCE;

        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMinKey();
            } else {
                ExtendedJsonModule.MinKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }

        private MinKeyBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new MinKeyBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MinKey;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-shared"})
    private static final class MinKeyBsonDeserializer
    extends JsonDeserializer<MinKey> {
        public static final MinKeyBsonDeserializer INSTANCE;

        @NotNull
        public MinKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$minKey");
                if (treeNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                }
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MinKey();
                }
                Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
                }
                return (MinKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
                }
                return (MinKey)object;
            }
            if (tree instanceof TextNode) {
                return new MinKey();
            }
            Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bson.types.MinKey");
            }
            return (MinKey)object;
        }

        private MinKeyBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new MinKeyBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "T", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "()V", "date", "Ljava/util/Date;", "temporal", "(Ljava/lang/Object;)Ljava/util/Date;", "epochMillis", "", "(Ljava/lang/Object;)J", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "kmongo-shared"})
    private static abstract class TemporalBsonSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeDateTime(this.date(value));
            } else {
                ExtendedJsonModule.DateExtendedJsonSerializer.INSTANCE.serialize(this.date(value), gen, serializerProvider);
            }
        }

        @NotNull
        public final Date date(T temporal) {
            return new Date(this.epochMillis(temporal));
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/ZonedDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class ZonedDateTimeBsonSerializer
    extends TemporalBsonSerializer<ZonedDateTime> {
        public static final ZonedDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private ZonedDateTimeBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new ZonedDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class OffsetDateTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetDateTime> {
        public static final OffsetDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private OffsetDateTimeBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new OffsetDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class LocalDateBsonSerializer
    extends TemporalBsonSerializer<LocalDate> {
        public static final LocalDateBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalDateBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class LocalTimeBsonSerializer
    extends TemporalBsonSerializer<LocalTime> {
        public static final LocalTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalTimeBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetTime;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class OffsetTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetTime> {
        public static final OffsetTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private OffsetTimeBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new OffsetTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class InstantBsonSerializer
    extends TemporalBsonSerializer<Instant> {
        public static final InstantBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.InstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private InstantBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new InstantBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-shared"})
    private static final class LocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<LocalDateTime> {
        public static final LocalDateTimeBsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }

        private LocalDateTimeBsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateTimeBsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "T", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "toObject", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/lang/Object;", "kmongo-shared"})
    private static abstract class TemporalBsonDeserializer<T>
    extends JsonDeserializer<T> {
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Object date;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
            Object object = date = jp.getEmbeddedObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Date");
            }
            return this.toObject((Date)object);
        }

        public abstract T toObject(@NotNull Date var1);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/ZonedDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class ZonedDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<ZonedDateTime> {
        public static final ZonedDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public ZonedDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), Companion.getMongoZoneId());
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.ofInstant(\u2026toInstant(), mongoZoneId)");
            return zonedDateTime;
        }

        private ZonedDateTimeBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new ZonedDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class OffsetDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetDateTime> {
        public static final OffsetDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public OffsetDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(date.toInstant(), Companion.getMongoZoneId());
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.ofInstant\u2026toInstant(), mongoZoneId)");
            return offsetDateTime;
        }

        private OffsetDateTimeBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new OffsetDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class LocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalDateTime> {
        public static final LocalDateTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), Companion.getMongoZoneId());
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.ofInstant(\u2026toInstant(), mongoZoneId)");
            return localDateTime;
        }

        private LocalDateTimeBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDate;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class LocalDateBsonDeserializer
    extends TemporalBsonDeserializer<LocalDate> {
        public static final LocalDateBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalDate localDate = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDateTimeBsonDeseria\u2026bject(date).toLocalDate()");
            return localDate;
        }

        private LocalDateBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class LocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalTime> {
        public static final LocalTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            LocalTime localTime = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"LocalDateTimeBsonDeseria\u2026bject(date).toLocalTime()");
            return localTime;
        }

        private LocalTimeBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new LocalTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class OffsetTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetTime> {
        public static final OffsetTimeBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public OffsetTime toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            OffsetTime offsetTime = OffsetDateTimeBsonDeserializer.INSTANCE.toObject(date).toOffsetTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"OffsetDateTimeBsonDeseri\u2026ject(date).toOffsetTime()");
            return offsetTime;
        }

        private OffsetTimeBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new OffsetTimeBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/Instant;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-shared"})
    private static final class InstantBsonDeserializer
    extends TemporalBsonDeserializer<Instant> {
        public static final InstantBsonDeserializer INSTANCE;

        @Override
        @NotNull
        public Instant toObject(@NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Instant instant = date.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"date.toInstant()");
            return instant;
        }

        private InstantBsonDeserializer() {
            INSTANCE = this;
        }

        static {
            new InstantBsonDeserializer();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$Companion;", "", "()V", "mongoZoneId", "Ljava/time/ZoneId;", "getMongoZoneId", "()Ljava/time/ZoneId;", "oldZoneIdBehaviour", "", "getOldZoneIdBehaviour", "()Z", "kmongo-shared"})
    public static final class Companion {
        private final boolean getOldZoneIdBehaviour() {
            return oldZoneIdBehaviour;
        }

        @NotNull
        public final ZoneId getMongoZoneId() {
            ZoneId zoneId;
            if (Companion.getOldZoneIdBehaviour()) {
                ZoneId zoneId2 = ZoneId.systemDefault();
                zoneId = zoneId2;
                Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            } else {
                ZoneOffset zoneOffset = ZoneOffset.UTC;
                Intrinsics.checkExpressionValueIsNotNull((Object)zoneOffset, (String)"ZoneOffset.UTC");
                zoneId = zoneOffset;
            }
            return zoneId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

