/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.util.MongoIdUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec;", "T", "", "Lorg/bson/codecs/Codec;", "Lorg/bson/codecs/CollectibleCodec;", "bsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "type", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/bson/codecs/configuration/CodecRegistry;Ljava/lang/Class;)V", "getBsonObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "rawBsonDocumentCodec", "Lorg/bson/RawBsonDocument;", "getType", "()Ljava/lang/Class;", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "documentHasId", "", "document", "(Ljava/lang/Object;)Z", "encode", "", "writer", "Lorg/bson/BsonWriter;", "value", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "generateIdIfAbsentFromDocument", "(Ljava/lang/Object;)Ljava/lang/Object;", "getDocumentId", "Lorg/bson/BsonValue;", "(Ljava/lang/Object;)Lorg/bson/BsonValue;", "getEncoderClass", "kmongo-shared"})
public final class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T> {
    private final Codec<RawBsonDocument> rawBsonDocumentCodec;
    @NotNull
    private final ObjectMapper bsonObjectMapper;
    @NotNull
    private final CodecRegistry codecRegistry;
    @NotNull
    private final Class<T> type;

    @NotNull
    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)decoderContext, (String)"decoderContext");
        try {
            Object object = this.bsonObjectMapper.readValue(((RawBsonDocument)this.rawBsonDocumentCodec.decode(reader, decoderContext)).getByteBuffer().array(), this.type);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bsonObjectMapper.readVal\u2026byteBuffer.array(), type)");
            return (T)object;
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    public void encode(@NotNull BsonWriter writer, @NotNull T value, @NotNull EncoderContext encoderContext) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)encoderContext, (String)"encoderContext");
        try {
            byte[] e = this.bsonObjectMapper.writeValueAsBytes(value);
            this.rawBsonDocumentCodec.encode(writer, (Object)new RawBsonDocument(e), encoderContext);
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    @NotNull
    public Class<T> getEncoderClass() {
        return this.type;
    }

    @NotNull
    public BsonValue getDocumentId(@NotNull T document) {
        BsonValue idValue;
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(this.type));
        if (idProperty == null) {
            throw (Throwable)new IllegalStateException(this.type + " has no id field");
        }
        BsonValue bsonValue = idValue = MongoIdUtil.INSTANCE.getIdBsonValue(idProperty, document);
        if (bsonValue == null) {
            throw (Throwable)new IllegalStateException(this.type + " has null id");
        }
        return bsonValue;
    }

    public boolean documentHasId(@NotNull T document) {
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        return MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(this.type)) != null;
    }

    @NotNull
    public T generateIdIfAbsentFromDocument(@NotNull T document) {
        Object idValue;
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(this.type));
        if (idProperty != null && (idValue = MongoIdUtil.INSTANCE.getIdValue(idProperty, document)) == null) {
            Field javaField;
            String toString = idProperty.getReturnType().toString();
            Field field = javaField = ReflectJvmMapping.getJavaField((KProperty)((KProperty)idProperty));
            if (field == null) {
                Intrinsics.throwNpe();
            }
            field.setAccessible(true);
            if (StringsKt.startsWith$default((String)toString, (String)KClasses.getDefaultType((KClass)Reflection.getOrCreateKotlinClass(ObjectId.class)).toString(), (boolean)false, (int)2, null)) {
                javaField.set(document, ObjectId.get());
            } else if (StringsKt.startsWith$default((String)toString, (String)KClasses.getDefaultType((KClass)Reflection.getOrCreateKotlinClass(String.class)).toString(), (boolean)false, (int)2, null)) {
                javaField.set(document, ObjectId.get().toString());
            } else {
                throw (Throwable)new IllegalArgumentException("generation for id property type not supported : " + idProperty);
            }
        }
        return document;
    }

    @NotNull
    public final ObjectMapper getBsonObjectMapper() {
        return this.bsonObjectMapper;
    }

    @NotNull
    public final CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @NotNull
    public final Class<T> getType() {
        return this.type;
    }

    public JacksonCodec(@NotNull ObjectMapper bsonObjectMapper, @NotNull CodecRegistry codecRegistry, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)bsonObjectMapper, (String)"bsonObjectMapper");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this.bsonObjectMapper = bsonObjectMapper;
        this.codecRegistry = codecRegistry;
        this.type = type;
        Codec codec = this.codecRegistry.get(RawBsonDocument.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)codec, (String)"codecRegistry.get(RawBsonDocument::class.java)");
        this.rawBsonDocumentCodec = codec;
    }
}

