/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.serialization.InstantSerializer;
import org.litote.kmongo.serialization.TemporalExtendedJsonSerializer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/serialization/ZonedDateTimeSerializer;", "Lorg/litote/kmongo/serialization/TemporalExtendedJsonSerializer;", "Ljava/time/ZonedDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "instantiate", "date", "kmongo-serialization-mapping"})
public final class ZonedDateTimeSerializer
extends TemporalExtendedJsonSerializer<ZonedDateTime> {
    @NotNull
    public static final ZonedDateTimeSerializer INSTANCE = new ZonedDateTimeSerializer();

    private ZonedDateTimeSerializer() {
    }

    @Override
    public long epochMillis(@NotNull ZonedDateTime temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        Instant instant = temporal.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return InstantSerializer.INSTANCE.epochMillis(instant);
    }

    @Override
    @NotNull
    public ZonedDateTime instantiate(long date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(InstantSerializer.INSTANCE.instantiate(date), ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
        return zonedDateTime;
    }
}

