/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lorg/bson/codecs/pojo/TriplePropertyCodecProvider;", "Lorg/bson/codecs/pojo/PropertyCodecProvider;", "()V", "get", "Lorg/bson/codecs/Codec;", "T", "type", "Lorg/bson/codecs/pojo/TypeWithTypeParameters;", "registry", "Lorg/bson/codecs/pojo/PropertyCodecRegistry;", "TripleCodec", "kmongo-native-mapping"})
public final class TriplePropertyCodecProvider
implements PropertyCodecProvider {
    @NotNull
    public static final TriplePropertyCodecProvider INSTANCE = new TriplePropertyCodecProvider();

    private TriplePropertyCodecProvider() {
    }

    @Nullable
    public <T> Codec<T> get(@NotNull TypeWithTypeParameters<T> type, @NotNull PropertyCodecRegistry registry) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (Intrinsics.areEqual(Triple.class, (Object)type.getType())) {
            Codec codec = registry.get((TypeWithTypeParameters)type.getTypeParameters().get(0));
            if (codec == null) {
                throw new CodecConfigurationException(Intrinsics.stringPlus((String)"no codec found for ", type.getTypeParameters().get(0)));
            }
            Codec firstCodec = codec;
            Codec codec2 = registry.get((TypeWithTypeParameters)type.getTypeParameters().get(1));
            if (codec2 == null) {
                throw new CodecConfigurationException(Intrinsics.stringPlus((String)"no codec found for ", type.getTypeParameters().get(1)));
            }
            Codec secondCodec = codec2;
            Codec codec3 = registry.get((TypeWithTypeParameters)type.getTypeParameters().get(2));
            if (codec3 == null) {
                throw new CodecConfigurationException(Intrinsics.stringPlus((String)"no codec found for ", type.getTypeParameters().get(2)));
            }
            Codec thirdCodec = codec3;
            return new TripleCodec((Codec<Object>)firstCodec, (Codec<Object>)secondCodec, (Codec<Object>)thirdCodec);
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\u0002\u0010\u0007J$\u0010\f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0019H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/bson/codecs/pojo/TriplePropertyCodecProvider$TripleCodec;", "Lorg/bson/codecs/Codec;", "Lkotlin/Triple;", "firstCodec", "", "secondCodec", "thirdCodec", "(Lorg/bson/codecs/Codec;Lorg/bson/codecs/Codec;Lorg/bson/codecs/Codec;)V", "getFirstCodec", "()Lorg/bson/codecs/Codec;", "getSecondCodec", "getThirdCodec", "decode", "reader", "Lorg/bson/BsonReader;", "context", "Lorg/bson/codecs/DecoderContext;", "encode", "", "writer", "Lorg/bson/BsonWriter;", "pair", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "getEncoderClass", "Ljava/lang/Class;", "kmongo-native-mapping"})
    private static final class TripleCodec
    implements Codec<Triple<?, ?, ?>> {
        @NotNull
        private final Codec<Object> firstCodec;
        @NotNull
        private final Codec<Object> secondCodec;
        @NotNull
        private final Codec<Object> thirdCodec;

        public TripleCodec(@NotNull Codec<Object> firstCodec, @NotNull Codec<Object> secondCodec, @NotNull Codec<Object> thirdCodec) {
            Intrinsics.checkNotNullParameter(firstCodec, (String)"firstCodec");
            Intrinsics.checkNotNullParameter(secondCodec, (String)"secondCodec");
            Intrinsics.checkNotNullParameter(thirdCodec, (String)"thirdCodec");
            this.firstCodec = firstCodec;
            this.secondCodec = secondCodec;
            this.thirdCodec = thirdCodec;
        }

        @NotNull
        public final Codec<Object> getFirstCodec() {
            return this.firstCodec;
        }

        @NotNull
        public final Codec<Object> getSecondCodec() {
            return this.secondCodec;
        }

        @NotNull
        public final Codec<Object> getThirdCodec() {
            return this.thirdCodec;
        }

        public void encode(@NotNull BsonWriter writer, @NotNull Triple<?, ?, ?> pair, @NotNull EncoderContext encoderContext) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(pair, (String)"pair");
            Intrinsics.checkNotNullParameter((Object)encoderContext, (String)"encoderContext");
            writer.writeStartDocument();
            writer.writeName("first");
            this.firstCodec.encode(writer, pair.getFirst(), encoderContext);
            writer.writeName("second");
            this.secondCodec.encode(writer, pair.getSecond(), encoderContext);
            writer.writeName("third");
            this.thirdCodec.encode(writer, pair.getThird(), encoderContext);
            writer.writeEndDocument();
        }

        @NotNull
        public Triple<?, ?, ?> decode(@NotNull BsonReader reader, @NotNull DecoderContext context) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            reader.readStartDocument();
            reader.readName();
            Object first = this.firstCodec.decode(reader, context);
            reader.readName();
            Object second = this.secondCodec.decode(reader, context);
            reader.readName();
            Object third = this.thirdCodec.decode(reader, context);
            Triple triple = new Triple(first, second, third);
            reader.readEndDocument();
            return triple;
        }

        @NotNull
        public Class<Triple<?, ?, ?>> getEncoderClass() {
            return Triple.class;
        }
    }
}

