/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.ClassModelBuilder2;
import org.bson.codecs.pojo.CreatorExecutable;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.InstanceCreatorFactoryImpl;
import org.bson.codecs.pojo.PojoSpecializationHelper;
import org.bson.codecs.pojo.PropertyAccessor;
import org.bson.codecs.pojo.PropertyAccessorImpl;
import org.bson.codecs.pojo.PropertyMetadata;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.PropertyModelSerializationImpl;
import org.bson.codecs.pojo.PropertyReflectionUtils2;
import org.bson.codecs.pojo.PropertySerialization;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PojoBuilderHelper2 {
    /*
     * WARNING - void declaration
     */
    static <T> void configureClassModelBuilder(ClassModelBuilder2<T> classModelBuilder, Class<T> clazz) {
        classModelBuilder.type((Class)Assertions.notNull((String)"clazz", clazz));
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        TreeSet<String> propertyNames = new TreeSet<String>();
        HashMap<String, TypeParameterMap> propertyTypeParameterMap = new HashMap<String, TypeParameterMap>();
        Class<T> currentClass = clazz;
        String declaringClassName = clazz.getSimpleName();
        TypeData parentClassTypeData = null;
        HashMap propertyNameMap = new HashMap();
        while (!currentClass.isEnum() && currentClass.getSuperclass() != null) {
            void var13_17;
            PropertyMetadata<T> propertyMetadata;
            annotations.addAll(Arrays.asList(currentClass.getDeclaredAnnotations()));
            ArrayList genericTypeNames = new ArrayList();
            for (AnnotatedElement annotatedElement : currentClass.getTypeParameters()) {
                genericTypeNames.add(annotatedElement.getName());
            }
            PropertyReflectionUtils2.PropertyMethods propertyMethods = PropertyReflectionUtils2.getPropertyMethods(currentClass);
            for (Method method : propertyMethods.getSetterMethods()) {
                String string = PropertyReflectionUtils2.toPropertyName(method);
                propertyNames.add(string);
                propertyMetadata = PojoBuilderHelper2.getOrCreateMethodPropertyMetadata(string, declaringClassName, propertyNameMap, TypeData.newInstance((Method)method), propertyTypeParameterMap, parentClassTypeData, genericTypeNames, PojoBuilderHelper2.getGenericType(method));
                if (propertyMetadata.getSetter() != null) continue;
                propertyMetadata.setSetter(method);
                for (Annotation annotation : method.getDeclaredAnnotations()) {
                    propertyMetadata.addWriteAnnotation(annotation);
                }
            }
            for (Method method : propertyMethods.getGetterMethods()) {
                String string = PropertyReflectionUtils2.toPropertyName(method);
                propertyNames.add(string);
                propertyMetadata = (PropertyMetadata<T>)propertyNameMap.get(string);
                if (propertyMetadata != null && propertyMetadata.getGetter() != null || (propertyMetadata = PojoBuilderHelper2.getOrCreateMethodPropertyMetadata(string, declaringClassName, propertyNameMap, TypeData.newInstance((Method)method), propertyTypeParameterMap, parentClassTypeData, genericTypeNames, PojoBuilderHelper2.getGenericType(method))).getGetter() != null) continue;
                propertyMetadata.setGetter(method);
                for (Annotation annotation : method.getDeclaredAnnotations()) {
                    propertyMetadata.addReadAnnotation(annotation);
                }
            }
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var13_17 < n) {
                Field field = fieldArray[var13_17];
                propertyNames.add(field.getName());
                PropertyMetadata<T> propertyMetadata2 = PojoBuilderHelper2.getOrCreateFieldPropertyMetadata(field.getName(), declaringClassName, propertyNameMap, TypeData.newInstance((Field)field), propertyTypeParameterMap, parentClassTypeData, genericTypeNames, field.getGenericType());
                if (propertyMetadata2 != null && propertyMetadata2.getField() == null) {
                    propertyMetadata2.field(field);
                    for (Annotation annotation : field.getDeclaredAnnotations()) {
                        propertyMetadata2.addReadAnnotation(annotation);
                        propertyMetadata2.addWriteAnnotation(annotation);
                    }
                }
                ++var13_17;
            }
            parentClassTypeData = TypeData.newInstance((Type)currentClass.getGenericSuperclass(), currentClass);
            currentClass = currentClass.getSuperclass();
        }
        if (currentClass.isInterface()) {
            annotations.addAll(Arrays.asList(currentClass.getDeclaredAnnotations()));
        }
        for (String propertyName : propertyNames) {
            PropertyMetadata propertyMetadata = (PropertyMetadata)propertyNameMap.get(propertyName);
            if (!propertyMetadata.isSerializable() && !propertyMetadata.isDeserializable()) continue;
            classModelBuilder.addProperty(PojoBuilderHelper2.createPropertyModelBuilder(propertyMetadata));
        }
        Collections.reverse(annotations);
        classModelBuilder.annotations(annotations);
        classModelBuilder.propertyNameToTypeParameterMap(propertyTypeParameterMap);
        AnnotatedElement noArgsConstructor = null;
        for (AnnotatedElement annotatedElement : clazz.getDeclaredConstructors()) {
            if (((Constructor)annotatedElement).getParameterTypes().length != 0 || !Modifier.isPublic(((Constructor)annotatedElement).getModifiers()) && !Modifier.isProtected(((Constructor)annotatedElement).getModifiers())) continue;
            noArgsConstructor = annotatedElement;
            ((Constructor)noArgsConstructor).setAccessible(true);
        }
        classModelBuilder.instanceCreatorFactory((InstanceCreatorFactory<T>)new InstanceCreatorFactoryImpl(new CreatorExecutable(clazz, noArgsConstructor)));
    }

    private static <T, S> PropertyMetadata<T> getOrCreateMethodPropertyMetadata(String propertyName, String declaringClassName, Map<String, PropertyMetadata<?>> propertyNameMap, TypeData<T> typeData, Map<String, TypeParameterMap> propertyTypeParameterMap, TypeData<S> parentClassTypeData, List<String> genericTypeNames, Type genericType) {
        PropertyMetadata<T> propertyMetadata = PojoBuilderHelper2.getOrCreatePropertyMetadata(propertyName, declaringClassName, propertyNameMap, typeData);
        if (!PojoBuilderHelper2.isAssignableClass(propertyMetadata.getTypeData().getType(), typeData.getType())) {
            propertyMetadata.setError(String.format("Property '%s' in %s, has differing data types: %s and %s.", propertyName, declaringClassName, propertyMetadata.getTypeData(), typeData));
        }
        PojoBuilderHelper2.cachePropertyTypeData(propertyMetadata, propertyTypeParameterMap, parentClassTypeData, genericTypeNames, genericType);
        return propertyMetadata;
    }

    private static boolean isAssignableClass(Class<?> propertyTypeClass, Class<?> typeDataClass) {
        return propertyTypeClass.isAssignableFrom(typeDataClass) || typeDataClass.isAssignableFrom(propertyTypeClass);
    }

    private static <T, S> PropertyMetadata<T> getOrCreateFieldPropertyMetadata(String propertyName, String declaringClassName, Map<String, PropertyMetadata<?>> propertyNameMap, TypeData<T> typeData, Map<String, TypeParameterMap> propertyTypeParameterMap, TypeData<S> parentClassTypeData, List<String> genericTypeNames, Type genericType) {
        PropertyMetadata<T> propertyMetadata = PojoBuilderHelper2.getOrCreatePropertyMetadata(propertyName, declaringClassName, propertyNameMap, typeData);
        if (!propertyMetadata.getTypeData().getType().isAssignableFrom(typeData.getType())) {
            return null;
        }
        PojoBuilderHelper2.cachePropertyTypeData(propertyMetadata, propertyTypeParameterMap, parentClassTypeData, genericTypeNames, genericType);
        return propertyMetadata;
    }

    private static <T> PropertyMetadata<T> getOrCreatePropertyMetadata(String propertyName, String declaringClassName, Map<String, PropertyMetadata<?>> propertyNameMap, TypeData<T> typeData) {
        PropertyMetadata propertyMetadata = propertyNameMap.get(propertyName);
        if (propertyMetadata == null) {
            propertyMetadata = new PropertyMetadata(propertyName, declaringClassName, typeData);
            propertyNameMap.put(propertyName, propertyMetadata);
        }
        return propertyMetadata;
    }

    private static <T, S> void cachePropertyTypeData(PropertyMetadata<T> propertyMetadata, Map<String, TypeParameterMap> propertyTypeParameterMap, TypeData<S> parentClassTypeData, List<String> genericTypeNames, Type genericType) {
        TypeParameterMap typeParameterMap = PojoBuilderHelper2.getTypeParameterMap(genericTypeNames, genericType);
        propertyTypeParameterMap.put(propertyMetadata.getName(), typeParameterMap);
        propertyMetadata.typeParameterInfo(typeParameterMap, parentClassTypeData);
    }

    private static Type getGenericType(Method method) {
        return PropertyReflectionUtils2.isGetter(method) ? method.getGenericReturnType() : method.getGenericParameterTypes()[0];
    }

    static <T> PropertyModelBuilder<T> createPropertyModelBuilder(PropertyMetadata<T> propertyMetadata) {
        PropertyModelBuilder propertyModelBuilder = PropertyModel.builder().propertyName(propertyMetadata.getName()).readName(propertyMetadata.getName()).writeName(propertyMetadata.getName()).typeData(propertyMetadata.getTypeData()).readAnnotations(propertyMetadata.getReadAnnotations()).writeAnnotations(propertyMetadata.getWriteAnnotations()).propertySerialization((PropertySerialization)new PropertyModelSerializationImpl()).propertyAccessor((PropertyAccessor)new PropertyAccessorImpl(propertyMetadata)).setError(propertyMetadata.getError());
        if (propertyMetadata.getTypeParameters() != null) {
            propertyModelBuilder.typeData(PojoSpecializationHelper.specializeTypeData((TypeData)propertyModelBuilder.getTypeData(), (List)propertyMetadata.getTypeParameters(), (TypeParameterMap)propertyMetadata.getTypeParameterMap()));
        }
        return propertyModelBuilder;
    }

    private static TypeParameterMap getTypeParameterMap(List<String> genericTypeNames, Type propertyType) {
        int classParamIndex = genericTypeNames.indexOf(propertyType.toString());
        TypeParameterMap.Builder builder = TypeParameterMap.builder();
        if (classParamIndex != -1) {
            builder.addIndex(classParamIndex);
        } else if (propertyType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)propertyType;
            for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                classParamIndex = genericTypeNames.indexOf(pt.getActualTypeArguments()[i].toString());
                if (classParamIndex != -1) {
                    builder.addIndex(i, classParamIndex);
                    continue;
                }
                builder.addIndex(i, PojoBuilderHelper2.getTypeParameterMap(genericTypeNames, pt.getActualTypeArguments()[i]));
            }
        }
        return builder.build();
    }

    static <V> V stateNotNull(String property, V value) {
        if (value == null) {
            throw new IllegalStateException(String.format("%s cannot be null", property));
        }
        return value;
    }

    private PojoBuilderHelper2() {
    }
}

