/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.async;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.service.ClassMappingType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/async/KMongo;", "", "()V", "createClient", "Lcom/mongodb/async/client/MongoClient;", "connectionString", "Lcom/mongodb/ConnectionString;", "settings", "Lcom/mongodb/async/client/MongoClientSettings;", "", "kmongo-async-shared"})
public final class KMongo {
    public static final KMongo INSTANCE;

    @NotNull
    public final MongoClient createClient() {
        return this.createClient(new ConnectionString("mongodb://localhost"));
    }

    @NotNull
    public final MongoClient createClient(@NotNull MongoClientSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{settings.getCodecRegistry(), ClassMappingType.INSTANCE.codecRegistry()});
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)settings).codecRegistry(codecRegistry).build());
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoClient, (String)"MongoClients.create(\n   \u2026y(codecRegistry).build())");
        return mongoClient;
    }

    @NotNull
    public final MongoClient createClient(@NotNull String connectionString) {
        Intrinsics.checkParameterIsNotNull((Object)connectionString, (String)"connectionString");
        return this.createClient(new ConnectionString(connectionString));
    }

    @NotNull
    public final MongoClient createClient(@NotNull ConnectionString connectionString) {
        Intrinsics.checkParameterIsNotNull((Object)connectionString, (String)"connectionString");
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().build()).credentialList(connectionString.getCredentialList()).sslSettings(SslSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoClientSettings, (String)"MongoClientSettings.buil\u2026nString).build()).build()");
        return this.createClient(mongoClientSettings);
    }

    private KMongo() {
        INSTANCE = this;
    }

    static {
        new KMongo();
    }
}

