/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.linkki.core.ui.table.column.annotation.UITableColumn;
import org.linkki.tooling.apt.validator.MethodAnnotationValidator;

public class UITableColumnValidator
extends MethodAnnotationValidator<UITableColumn> {
    static final String SORTABLE_METHOD_RETURNS_VOID = "UITableColumnValidator.sortableMethodReturnsVoid";
    static final String SORTABLE_RETURN_TYPE_NOT_COMPARABLE = "UITableColumnValidator.sortableReturnTypeNotComparable";
    private static final String PROPERTY_SORTABLE = "sortable";

    public UITableColumnValidator(ProcessingEnvironment env) {
        super(env, UITableColumn.class);
    }

    @Override
    public void validate(UITableColumn annotation, ExecutableElement method) {
        if (annotation.sortable()) {
            if (method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                this.printError(method, PROPERTY_SORTABLE, SORTABLE_METHOD_RETURNS_VOID);
            } else if (!this.isComparable(method.getReturnType())) {
                this.printError(method, PROPERTY_SORTABLE, SORTABLE_RETURN_TYPE_NOT_COMPARABLE);
            }
        }
    }

    private boolean isComparable(TypeMirror type) {
        TypeElement comparable = this.elements().getTypeElement(Comparable.class.getCanonicalName());
        return this.types().isAssignable(type, this.types().getDeclaredType(comparable, new TypeMirror[0]));
    }
}

