/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.util.Optional;
import java.util.function.Function;

public interface Either<L, R> {
    public <U> Either<U, R> mapLeft(Function<L, U> var1);

    public <U> Either<L, U> mapRight(Function<R, U> var1);

    public <U> Either<U, R> flatMapLeft(Function<L, Either<U, R>> var1);

    public <U> Either<L, U> flatMapRight(Function<R, Either<L, U>> var1);

    public boolean isLeft();

    public boolean isRight();

    public Optional<L> getLeft();

    public Optional<R> getRight();

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public static <T, L extends T, R extends T> T get(Either<L, R> either) {
        if (either.isLeft()) {
            return (T)((Left)either).getValue();
        }
        if (either.isRight()) {
            return (T)((Right)either).getValue();
        }
        throw new IllegalArgumentException("unknown type " + either.getClass());
    }

    public static class Right<L, R>
    implements Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        public R getValue() {
            return this.value;
        }

        @Override
        public <U> Either<U, R> mapLeft(Function<L, U> transform) {
            return this;
        }

        @Override
        public <U> Either<L, U> mapRight(Function<R, U> transform) {
            return Either.right(transform.apply(this.getValue()));
        }

        @Override
        public <U> Either<U, R> flatMapLeft(Function<L, Either<U, R>> transform) {
            return this;
        }

        @Override
        public <U> Either<L, U> flatMapRight(Function<R, Either<L, U>> transform) {
            return transform.apply(this.getValue());
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public Optional<L> getLeft() {
            return Optional.empty();
        }

        @Override
        public Optional<R> getRight() {
            return Optional.of(this.value);
        }
    }

    public static class Left<L, R>
    implements Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        public L getValue() {
            return this.value;
        }

        @Override
        public <U> Either<U, R> mapLeft(Function<L, U> transform) {
            return Either.left(transform.apply(this.getValue()));
        }

        @Override
        public <U> Either<L, U> mapRight(Function<R, U> transform) {
            return this;
        }

        @Override
        public <U> Either<U, R> flatMapLeft(Function<L, Either<U, R>> transform) {
            return transform.apply(this.getValue());
        }

        @Override
        public <U> Either<L, U> flatMapRight(Function<R, Either<L, U>> transform) {
            return this;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public Optional<L> getLeft() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<R> getRight() {
            return Optional.empty();
        }
    }
}

