/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sequence<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    private Sequence() {
        this.list = Collections.emptyList();
    }

    private Sequence(Collection<T> collection) {
        this.list = Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static <T> Sequence<T> of(Collection<? extends T> elements) {
        return new Sequence<T>(elements);
    }

    @SafeVarargs
    public static <T> Sequence<T> of(T ... elements) {
        return new Sequence<T>(Arrays.asList(elements));
    }

    public static <T> Sequence<T> empty() {
        return new Sequence<T>();
    }

    @CheckReturnValue
    public Sequence<T> with(Collection<T> elements) {
        ArrayList<T> collection = new ArrayList<T>(this.list.size() + elements.size());
        collection.addAll(this.list);
        collection.addAll(elements);
        return new Sequence(collection);
    }

    public Sequence<T> withNewElementsFrom(Collection<T> elements) {
        ArrayList collection = new ArrayList(this.list.size() + elements.size());
        collection.addAll(this.list);
        elements.stream().filter(e -> !collection.contains(e)).forEach(collection::add);
        return new Sequence(collection);
    }

    @CheckReturnValue
    public final Sequence<T> with(Sequence<T> sequence) {
        return this.with((Collection<T>)sequence.list());
    }

    @SafeVarargs
    @CheckReturnValue
    public final Sequence<T> with(T ... newElements) {
        return this.with((Collection<T>)Arrays.asList(newElements));
    }

    @SafeVarargs
    @CheckReturnValue
    public final Sequence<T> withIf(boolean condition, Supplier<T> ... suppliers) {
        if (condition) {
            return this.with(Arrays.stream(suppliers).map(Supplier::get).collect(Collectors.toList()));
        }
        return this;
    }

    @CheckReturnValue
    public final Sequence<T> withIf(boolean condition, Supplier<T> supplier) {
        if (condition) {
            return this.with(supplier.get());
        }
        return this;
    }

    public List<T> list() {
        return this.list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    public String toString() {
        return this.list.toString();
    }

    public static <T> Collector<T, ?, Sequence<T>> collect() {
        return new SequenceCollector();
    }

    private static final class SequenceCollector<T>
    implements Collector<T, List<T>, Sequence<T>> {
        SequenceCollector() {
        }

        @Override
        public Supplier<List<T>> supplier() {
            return LinkedList::new;
        }

        @Override
        public BiConsumer<List<T>, T> accumulator() {
            return List::add;
        }

        @Override
        public BinaryOperator<List<T>> combiner() {
            return (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            };
        }

        @Override
        public Function<List<T>, Sequence<T>> finisher() {
            return Sequence::of;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

