/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BeanUtils {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    private BeanUtils() {
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) {
        try {
            return Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Optional<Method> getMethod(Class<?> clazz, Predicate<Method> predicate) {
        return BeanUtils.getMethods(clazz, predicate).reduce((m1, m2) -> {
            throw new IllegalStateException(MessageFormat.format("Ambiguous methods ({0} and {1}) found in {2}", m1, m2, clazz));
        });
    }

    public static Stream<Method> getMethods(Class<?> clazz, Predicate<Method> predicate) {
        return Arrays.stream(clazz.getMethods()).filter(m -> !m.isSynthetic()).filter(predicate);
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        for (Class<?> classToSearch = clazz; classToSearch != null; classToSearch = classToSearch.getSuperclass()) {
            try {
                return classToSearch.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new RuntimeException(new NoSuchFieldException("No field '" + name + "' found in class '" + clazz + "' or any of its super classes."));
    }

    @CheckForNull
    public static Object getValueFromField(Object object, String name) {
        Field field = BeanUtils.getField(object.getClass(), name);
        return BeanUtils.getValueFromField(object, field);
    }

    @CheckForNull
    public static Object getValueFromField(final Object object, final Field field) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            @CheckForNull
            public Object run() {
                boolean accessible = field.canAccess(object);
                if (!accessible) {
                    field.setAccessible(true);
                }
                try {
                    Object object2 = field.get(object);
                    return object2;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
        });
    }

    public static String getPropertyName(Method method) {
        return BeanUtils.getPropertyName(method.getReturnType(), method.getName());
    }

    public static String getPropertyName(Type returnType, String methodName) {
        if (returnType.equals(Void.TYPE)) {
            return methodName;
        }
        if (methodName.startsWith(IS_PREFIX)) {
            return StringUtils.uncapitalize((String)methodName.substring(2));
        }
        if (methodName.startsWith(GET_PREFIX)) {
            return StringUtils.uncapitalize((String)methodName.substring(3));
        }
        return methodName;
    }
}

