/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.test.matcher;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class StreamMatcher<T>
extends TypeSafeMatcher<Stream<T>> {
    private final Predicate<T> predicate;
    private final boolean allMatch;

    private StreamMatcher(Predicate<T> predicate, boolean allMatch) {
        this.predicate = predicate;
        this.allMatch = allMatch;
    }

    public void describeTo(Description description) {
        if (this.allMatch) {
            description.appendText("a Stream whose items all match " + this.predicate);
        } else {
            description.appendText("a Stream with any item matching " + this.predicate);
        }
    }

    protected boolean matchesSafely(Stream<T> s) {
        if (this.allMatch) {
            return s.allMatch(this.predicate);
        }
        return s.anyMatch(this.predicate);
    }

    public static <T> StreamMatcher<T> allMatch(Predicate<T> predicate) {
        return new StreamMatcher<T>(predicate, true);
    }

    public static <T> StreamMatcher<T> anyMatch(Predicate<T> predicate) {
        return new StreamMatcher<T>(predicate, false);
    }
}

