/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linkki.framework.ui.dialogs.ConfirmationDialog;
import org.linkki.util.handler.Handler;

public class DialogErrorHandler
implements ErrorHandler {
    public static final String ERROR_PARAM = "errorOccurred";
    private static final long serialVersionUID = -6253400229098333633L;
    private static final Logger LOGGER = Logger.getLogger(DialogErrorHandler.class.getName());
    private static final String DEFAULT_START_VIEW = "";
    private final String startView;
    private final BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator;

    public DialogErrorHandler(BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator) {
        this(dialogCreator, DEFAULT_START_VIEW);
    }

    public DialogErrorHandler(BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator, String startView) {
        this.dialogCreator = dialogCreator;
        this.startView = startView;
    }

    public void error(ErrorEvent event) {
        LOGGER.log(Level.SEVERE, "Unhandled exception", event.getThrowable());
        this.showErrorDialog(event);
    }

    private void showErrorDialog(ErrorEvent errorEvent) {
        ConfirmationDialog dialog = this.dialogCreator.apply(errorEvent, this::navigateToStartView);
        dialog.open();
    }

    private void navigateToStartView() {
        UI.getCurrent().navigate(this.startView, QueryParameters.fromString((String)ERROR_PARAM));
    }
}

