/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.VaadinServlet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.linkki.core.ui.ComponentStyles;
import org.linkki.framework.ui.dialogs.ConfirmationDialog;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

public class DefaultErrorDialog
extends ConfirmationDialog {
    private static final long serialVersionUID = 1L;

    public DefaultErrorDialog(ErrorEvent errorEvent, Handler navigateToStartView) {
        super(NlsText.getString("DefaultErrorHandler.errorDialogTitle"), navigateToStartView, new Component[]{DefaultErrorDialog.createContent(errorEvent)});
        this.setSize("80em", "40em");
    }

    private static VerticalLayout createContent(ErrorEvent errorEvent) {
        LocalDateTime timestamp = LocalDateTime.now();
        VerticalLayout content = new VerticalLayout();
        content.add(new Component[]{DefaultErrorDialog.createLabelWithTimestamp(timestamp)});
        content.add(new Component[]{DefaultErrorDialog.createRootCauseTextField(errorEvent.getThrowable())});
        if (!VaadinServlet.getCurrent().getService().getDeploymentConfiguration().isProductionMode()) {
            content.add(new Component[]{DefaultErrorDialog.createStackTraceTextArea(errorEvent.getThrowable())});
        }
        content.setSizeFull();
        return content;
    }

    private static Label createLabelWithTimestamp(LocalDateTime timestamp) {
        String formattedTimestamp = timestamp.format(DateTimeFormatter.ofPattern(NlsText.getString("DefaultErrorHandler.timestampFormat")));
        return new Label(NlsText.format("DefaultErrorHandler.errorDialogText", formattedTimestamp));
    }

    private static TextField createRootCauseTextField(@CheckForNull Throwable t) {
        TextField textField = new TextField(NlsText.getString("DefaultErrorHandler.errorDialogDescription"));
        String message = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)t)).map(Throwable::getLocalizedMessage).orElse(ExceptionUtils.getRootCauseMessage((Throwable)t));
        textField.setValue(message);
        DefaultErrorDialog.formatText(textField);
        return textField;
    }

    private static TextArea createStackTraceTextArea(@CheckForNull Throwable t) {
        TextArea textArea = new TextArea(NlsText.getString("DefaultErrorHandler.errorDialogDetails"));
        textArea.setValue(ExceptionUtils.getStackTrace((Throwable)t));
        DefaultErrorDialog.formatText(textArea);
        ComponentStyles.setOverflowAuto((Component)textArea);
        return textArea;
    }

    private static <T extends HasValueAndElement<?, ?> & HasSize> void formatText(T textArea) {
        textArea.setReadOnly(true);
        ((HasSize)textArea).setWidthFull();
    }
}

