/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.util.List;
import org.linkki.framework.ui.application.ApplicationInfo;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.framework.ui.application.menu.ApplicationMenuItemDefinition;
import org.linkki.framework.ui.application.menu.ThemeVariantToggleMenuItemDefinition;
import org.linkki.framework.ui.dialogs.ApplicationInfoDialog;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.framework.ui.pmo.ApplicationInfoPmo;
import org.linkki.util.Objects;
import org.linkki.util.Sequence;

public class ApplicationHeader
extends Composite<HorizontalLayout> {
    static final String APPMENU_RIGHT_ID = "appmenu-right";
    static final String APPMENU_HELP_ID = "appmenu-help";
    static final String APPMENU_INFO_ID = "appmenu-info";
    static final String APPMENU_THEME_ID = "appmenu-theme";
    private static final long serialVersionUID = 1L;
    private final ApplicationInfo applicationInfo;
    private final Sequence<ApplicationMenuItemDefinition> menuItemDefinitions;

    public ApplicationHeader(ApplicationInfo applicationInfo, Sequence<ApplicationMenuItemDefinition> menuItemDefinitions) {
        this.applicationInfo = (ApplicationInfo)Objects.requireNonNull((Object)applicationInfo, (String)"applicationInfo must not be null");
        this.menuItemDefinitions = (Sequence)Objects.requireNonNull(menuItemDefinitions, (String)"menuItemDefinitions must not be null");
        ((HorizontalLayout)this.getContent()).addClassName("linkki-application-header");
        ((HorizontalLayout)this.getContent()).setWidthFull();
    }

    public void init() {
        this.addLeftComponents();
        this.addRightComponents();
    }

    protected void addLeftComponents() {
        ApplicationMenu applicationMenu = new ApplicationMenu(this.getMenuItemDefinitions().list());
        ((HorizontalLayout)this.getContent()).add(new Component[]{applicationMenu});
        ((HorizontalLayout)this.getContent()).setFlexGrow(1.0, new HasElement[]{applicationMenu});
    }

    private void addRightComponents() {
        HorizontalLayout wrapper = new HorizontalLayout();
        wrapper.addClassName("linkki-application-header-right");
        wrapper.setAlignItems(FlexComponent.Alignment.BASELINE);
        wrapper.setSpacing(true);
        this.addRightComponents(wrapper);
        ((HorizontalLayout)this.getContent()).add(new Component[]{wrapper});
    }

    protected void addRightComponents(HorizontalLayout parent) {
        parent.add(new Component[]{this.createRightMenuBar()});
    }

    protected MenuBar createRightMenuBar() {
        MenuBar rightMenuBar = new MenuBar();
        rightMenuBar.setId(APPMENU_RIGHT_ID);
        rightMenuBar.addThemeVariants(new MenuBarVariant[]{MenuBarVariant.LUMO_ICON});
        rightMenuBar.addClassNames(new String[]{"linkki-application-menu"});
        this.addHelpMenu(rightMenuBar);
        return rightMenuBar;
    }

    protected MenuItem addHelpMenu(MenuBar parent) {
        MenuItem helpMenu = parent.addItem((Component)VaadinIcon.QUESTION_CIRCLE.create());
        helpMenu.setId(APPMENU_HELP_ID);
        this.addHelpMenuItems(helpMenu);
        return helpMenu;
    }

    protected void addHelpMenuItems(MenuItem helpMenu) {
        this.addApplicationInfoMenuItem(helpMenu);
    }

    protected void addApplicationInfoMenuItem(MenuItem helpMenu) {
        new ApplicationMenuItemDefinition(NlsText.getString("ApplicationHeader.Info"), APPMENU_INFO_ID, this::showApplicationInfo).createItem((SubMenu)helpMenu.getSubMenu());
    }

    protected void addThemeVariantToggles(MenuItem menuItem, ThemeVariantToggleMenuItemDefinition ... themeVariants) {
        if (themeVariants.length == 1) {
            themeVariants[0].createItem((SubMenu)menuItem.getSubMenu());
        } else if (themeVariants.length > 1) {
            new ApplicationMenuItemDefinition(NlsText.getString("ApplicationHeader.Theme"), APPMENU_THEME_ID, List.of(themeVariants)).createItem((SubMenu)menuItem.getSubMenu());
        }
    }

    protected void showApplicationInfo() {
        new ApplicationInfoDialog(this.createApplicationInfoPmo()).open();
    }

    protected ApplicationInfoPmo createApplicationInfoPmo() {
        return new ApplicationInfoPmo(this.getApplicationInfo());
    }

    protected Sequence<ApplicationMenuItemDefinition> getMenuItemDefinitions() {
        return this.menuItemDefinitions;
    }

    protected ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }
}

