/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.zookeeper.KeeperException;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.util.text.TextUtils;
import org.linkedin.zookeeper.client.IZKClient;

public class ZooKeeperURLHandler
extends URLStreamHandler {
    private final IZKClient _defaultClient;

    public ZooKeeperURLHandler(IZKClient defaultClient) {
        this._defaultClient = defaultClient;
    }

    @Override
    protected URLConnection openConnection(URL url) {
        return new ZooKeeperURLConnection(url, this._defaultClient);
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        super.parseURL(u, spec, start, limit);
        if (!TextUtils.isEmptyString((String)u.getHost()) || u.getPort() != -1) {
            throw new UnsupportedOperationException("host/port not supported yet");
        }
        if (!TextUtils.isEmptyString((String)u.getQuery())) {
            throw new IllegalArgumentException("no query string is allowed");
        }
    }

    public static class ZooKeeperURLConnection
    extends URLConnection {
        private final IZKClient _zk;

        ZooKeeperURLConnection(URL url, IZKClient zk) {
            super(url);
            this._zk = zk;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return new ByteArrayInputStream(this._zk.getData(this.url.getPath()));
            }
            catch (InternalException e) {
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (KeeperException e) {
                throw new IOException(e);
            }
        }
    }
}

