/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.snapshot;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.ligoj.app.dao.SubscriptionRepository;
import org.ligoj.app.model.Node;
import org.ligoj.app.plugin.vm.dao.VmSnapshotStatusRepository;
import org.ligoj.app.plugin.vm.model.SnapshotOperation;
import org.ligoj.app.plugin.vm.model.VmSnapshotStatus;
import org.ligoj.app.plugin.vm.snapshot.Snapshot;
import org.ligoj.app.plugin.vm.snapshot.Snapshotting;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.subscription.LongTaskRunnerSubscription;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/vm/{subscription:\\d+}/snapshot")
@Produces(value={"application/json"})
@Transactional
public class VmSnapshotResource
implements LongTaskRunnerSubscription<VmSnapshotStatus, VmSnapshotStatusRepository> {
    private static final Logger log = LoggerFactory.getLogger(VmSnapshotResource.class);
    @Autowired
    protected VmSnapshotStatusRepository taskRepository;
    @Autowired
    private SecurityHelper securityHelper;
    @Autowired
    protected SubscriptionRepository subscriptionRepository;
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected ServicePluginLocator locator;

    private Snapshotting getSnapshot(Node node) {
        return Optional.ofNullable((Snapshotting)this.locator.getResource(node.getId(), Snapshotting.class)).orElseThrow(() -> new BusinessException("snapshot-no-supported", new Object[]{node.getRefined().getId()}));
    }

    @POST
    public VmSnapshotStatus create(@PathParam(value="subscription") int subscription, @QueryParam(value="stop") @DefaultValue(value="false") boolean stop) {
        Snapshotting snap = this.getSnapshot(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode());
        log.info("New snapshot requested for subscription {}", (Object)subscription);
        VmSnapshotStatus task = (VmSnapshotStatus)this.startTask(Integer.valueOf(subscription), t -> {
            t.setWorkload(1);
            t.setDone(0);
            t.setSnapshotInternalId(null);
            t.setStatusText(null);
            t.setPhase(null);
            t.setFinishedRemote(false);
            t.setOperation(SnapshotOperation.CREATE);
            t.setStop(stop);
        });
        String user = this.securityHelper.getLogin();
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            executor.submit(() -> {
                Thread.sleep(50L);
                this.securityHelper.setUserName(user);
                snap.snapshot(task);
                log.info("Snapshot requested for subscription {} finished", (Object)subscription);
                return null;
            });
        }
        return task;
    }

    @DELETE
    @Path(value="{snapshot}")
    public VmSnapshotStatus delete(@PathParam(value="subscription") int subscription, @PathParam(value="snapshot") String snapshot) {
        Snapshotting snap = this.getSnapshot(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode());
        log.info("Snapshot deletion requested for subscription {}, snapshot {}", (Object)subscription, (Object)snapshot);
        VmSnapshotStatus task = (VmSnapshotStatus)this.startTask(Integer.valueOf(subscription), t -> {
            t.setWorkload(1);
            t.setDone(0);
            t.setSnapshotInternalId(snapshot);
            t.setStatusText("deleting");
            t.setPhase(null);
            t.setFinishedRemote(false);
            t.setOperation(SnapshotOperation.DELETE);
            t.setStop(false);
        });
        String user = this.securityHelper.getLogin();
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            executor.submit(() -> {
                Thread.sleep(50L);
                this.securityHelper.setUserName(user);
                snap.delete(task);
                log.info("Snapshot deletion requested for subscription {}, snapshot {} finished", (Object)subscription, (Object)snapshot);
                return null;
            });
        }
        return task;
    }

    @GET
    public List<Snapshot> findAll(@PathParam(value="subscription") int subscription, @PathParam(value="q") @DefaultValue(value="") String criteria) throws Exception {
        return this.getSnapshot(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)).getNode()).findAllSnapshots(subscription, criteria);
    }

    public Supplier<VmSnapshotStatus> newTask() {
        return VmSnapshotStatus::new;
    }

    @GET
    @Path(value="task")
    public VmSnapshotStatus getTask(@PathParam(value="subscription") int subscription) {
        VmSnapshotStatus task = (VmSnapshotStatus)super.getTask(subscription);
        if (task != null) {
            this.getSnapshot(task.getLocked().getNode()).completeStatus(task);
        }
        return task;
    }

    public boolean isFinished(VmSnapshotStatus task) {
        if (task.isFailed()) {
            task.setFinishedRemote(true);
        } else if (!task.isFinishedRemote()) {
            this.getSnapshot(this.subscriptionResource.checkVisible((Integer)task.getLocked().getId()).getNode()).completeStatus(task);
        }
        return task.isFinishedRemote();
    }

    public VmSnapshotStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    public SubscriptionRepository getSubscriptionRepository() {
        return this.subscriptionRepository;
    }

    public SubscriptionResource getSubscriptionResource() {
        return this.subscriptionResource;
    }
}

