/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.execution;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.FastDateFormat;
import org.ligoj.app.dao.SubscriptionRepository;
import org.ligoj.app.model.Project;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.vm.dao.VmExecutionRepository;
import org.ligoj.app.plugin.vm.dao.VmExecutionStatusRepository;
import org.ligoj.app.plugin.vm.dao.VmScheduleRepository;
import org.ligoj.app.plugin.vm.execution.Vm;
import org.ligoj.app.plugin.vm.execution.VmExecutionServicePlugin;
import org.ligoj.app.plugin.vm.model.VmExecution;
import org.ligoj.app.plugin.vm.model.VmExecutionStatus;
import org.ligoj.app.plugin.vm.model.VmOperation;
import org.ligoj.app.plugin.vm.model.VmSchedule;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.plugin.AbstractToolPluginResource;
import org.ligoj.app.resource.subscription.LongTaskRunnerSubscription;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.DateUtils;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/vm/{subscription:\\d+}/execution")
@Produces(value={"application/json"})
@Transactional
public class VmExecutionResource
implements LongTaskRunnerSubscription<VmExecutionStatus, VmExecutionStatusRepository> {
    private static final Logger log = LoggerFactory.getLogger(VmExecutionResource.class);
    private static final String COMMON_CSV_HEADER = "subscription;project;projectKey;projectName;node";
    @Autowired
    protected VmExecutionResource self = this;
    @Autowired
    protected VmExecutionStatusRepository taskRepository;
    @Autowired
    private SecurityHelper securityHelper;
    @Autowired
    protected SubscriptionRepository subscriptionRepository;
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected VmExecutionRepository vmExecutionRepository;
    @Autowired
    private VmScheduleRepository vmScheduleRepository;
    @Autowired
    protected ServicePluginLocator locator;

    @POST
    @Path(value="{operation}")
    @Consumes(value={"application/json"})
    public VmExecutionStatus execute(@PathParam(value="subscription") int subscription, @PathParam(value="operation") VmOperation operation) {
        return this.execute(this.subscriptionResource.checkVisible(Integer.valueOf(subscription)), operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmExecutionStatus execute(Subscription subscription, VmOperation operation) {
        String node = subscription.getNode().getId();
        String trigger = this.securityHelper.getLogin();
        log.info("Operation {} on subscription {}, node {} is requested by {}", new Object[]{operation, subscription.getId(), node, trigger});
        VmExecution execution = new VmExecution();
        boolean failed = true;
        execution.setOperation(operation);
        execution.setSubscription(subscription);
        execution.setTrigger(trigger);
        execution.setDate(new Date());
        VmExecutionStatus task = (VmExecutionStatus)this.self.startTask((Integer)subscription.getId(), t -> {
            t.setFinishedRemote(false);
            t.setOperation(operation);
            t.setExecution(execution);
        });
        try {
            this.getTool(node).execute(execution);
            log.info("Operation {} (->{}) on subscription {}, node {} : succeed", new Object[]{operation, execution.getOperation(), subscription.getId(), node});
            execution.setSucceed(true);
            failed = false;
        }
        catch (Exception e) {
            execution.setError(e.getMessage());
            log.error("Operation {} on subscription {}, node {} : failed", new Object[]{operation, subscription.getId(), node, e});
        }
        finally {
            this.self.endTask((Integer)subscription.getId(), failed);
            this.saveAndFlush(execution, operation);
        }
        return task;
    }

    public Supplier<VmExecutionStatus> newTask() {
        return VmExecutionStatus::new;
    }

    @GET
    public VmExecutionStatus getTask(@PathParam(value="subscription") int subscription) {
        VmExecutionStatus task = (VmExecutionStatus)super.getTask(subscription);
        if (task != null && this.completeStatus(task)) {
            this.taskRepository.saveAndFlush((Object)task);
        }
        return task;
    }

    private VmExecutionServicePlugin getTool(String node) {
        return (VmExecutionServicePlugin)this.locator.getResourceExpected(node, VmExecutionServicePlugin.class);
    }

    private boolean completeStatus(VmExecutionStatus task) {
        if (task.isFailed()) {
            task.setFinishedRemote(true);
        }
        if (!task.isFinishedRemote() && task.isFinished()) {
            int subscription = (Integer)task.getLocked().getId();
            String node = task.getLocked().getNode().getId();
            try {
                Vm vm = this.getTool(node).getVmDetails(this.subscriptionResource.getParametersNoCheck(subscription));
                task.setVm(vm);
                task.setFinishedRemote(!vm.isBusy());
                return true;
            }
            catch (Exception e) {
                log.info("Unable to retrieve VM information of subscription {}, node {}", (Object)subscription, (Object)node);
            }
        }
        return false;
    }

    public boolean isFinished(VmExecutionStatus task) {
        this.completeStatus(task);
        return task.isFinishedRemote();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="{file:executions-.*.csv}")
    public Response downloadHistoryReport(@PathParam(value="subscription") int subscription, @PathParam(value="file") String file) {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        return AbstractToolPluginResource.download(o -> this.writeHistory(o, this.vmExecutionRepository.findAllBySubscription(subscription)), (String)file).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/service/vm/{node:service:.+}/{file:schedules-.*.csv}")
    public Response downloadNodeSchedulesReport(@PathParam(value="node") String node, @PathParam(value="file") String file) {
        List<VmSchedule> schedules = this.vmScheduleRepository.findAllByNode(node, this.securityHelper.getLogin());
        Map lastExecutions = this.vmExecutionRepository.findAllByNodeLast(node).stream().collect(Collectors.toMap(e -> (Integer)e.getSubscription().getId(), Function.identity()));
        return AbstractToolPluginResource.download(o -> this.writeSchedules(o, schedules, lastExecutions), (String)file).build();
    }

    private void writeHistory(OutputStream output, Collection<VmExecution> executions) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, "cp1252"));
        FastDateFormat df = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss");
        writer.write("subscription;project;projectKey;projectName;node;dateHMS;timestamp;previousState;operation;vm;trigger;succeed;statusText;errorText");
        for (VmExecution execution : executions) {
            this.writeCommon(writer, execution.getSubscription());
            this.writeExecutionStatus(writer, execution, df);
        }
        writer.flush();
    }

    private void writeSchedules(OutputStream output, Collection<VmSchedule> schedules, Map<Integer, VmExecution> lastExecutions) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, "cp1252"));
        FastDateFormat df = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss");
        Date now = DateUtils.newCalendar().getTime();
        writer.write("subscription;project;projectKey;projectName;node;cron;operation;lastDateHMS;lastTimestamp;previousState;lastOperation;vm;lastTrigger;lastSucceed;lastStatusText;lastErrorText;nextDateHMS;nextTimestamp");
        for (VmSchedule schedule : schedules) {
            VmExecution execution = lastExecutions.get(schedule.getSubscription().getId());
            this.writeCommon(writer, schedule.getSubscription());
            writer.write(59);
            writer.write(schedule.getCron());
            writer.write(59);
            writer.write(schedule.getOperation().name());
            if (execution == null) {
                writer.write(";;;;;;;;;");
            } else {
                this.writeExecutionStatus(writer, execution, df);
            }
            try {
                Date next = new CronExpression(schedule.getCron()).getNextValidTimeAfter(now);
                writer.write(59);
                writer.write(df.format(next));
                writer.write(59);
                writer.write(String.valueOf(next.getTime()));
            }
            catch (ParseException pe) {
                log.error("Invalid CRON expression {} : {}", (Object)schedule.getCron(), (Object)pe.getMessage());
                writer.write(";ERROR;ERROR");
            }
        }
        writer.flush();
    }

    private void writeExecutionStatus(Writer writer, VmExecution execution, FastDateFormat df) throws IOException {
        writer.write(59);
        writer.write(df.format(execution.getDate()));
        writer.write(59);
        writer.write(String.valueOf(execution.getDate().getTime()));
        writer.write(59);
        writer.write(Optional.ofNullable(execution.getPreviousState()).map(Enum::name).orElse(""));
        writer.write(59);
        writer.write(execution.getOperation().name());
        writer.write(59);
        writer.write(Objects.toString(execution.getVm(), ""));
        writer.write(59);
        writer.write(execution.getTrigger());
        writer.write(59);
        writer.write(String.valueOf(execution.isSucceed()));
        writer.write(59);
        writer.write(Objects.toString(execution.getStatusText(), ""));
        writer.write(59);
        writer.write(Objects.toString(execution.getError(), ""));
    }

    private void writeCommon(Writer writer, Subscription subscription) throws IOException {
        Project project = subscription.getProject();
        writer.write(10);
        writer.write(String.valueOf(subscription.getId()));
        writer.write(59);
        writer.write(String.valueOf(project.getId()));
        writer.write(59);
        writer.write(project.getPkey());
        writer.write(59);
        writer.write(project.getName().replace('\"', '\''));
        writer.write(59);
        writer.write(subscription.getNode().getId());
    }

    private void saveAndFlush(VmExecution execution, VmOperation operation) {
        if (execution.getOperation() == null) {
            log.info("Operation {} on subscription {} : skipped", (Object)operation, (Object)execution.getSubscription().getId());
        } else {
            this.vmExecutionRepository.saveAndFlush((Object)execution);
        }
    }

    public VmExecutionStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    public SubscriptionRepository getSubscriptionRepository() {
        return this.subscriptionRepository;
    }

    public SubscriptionResource getSubscriptionResource() {
        return this.subscriptionResource;
    }
}

