/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.reader.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.io7m.junreachable.UnreachableCodeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.nypl.simplified.json.core.JSONParseException;
import org.nypl.simplified.json.core.JSONParserUtilities;
import org.nypl.simplified.json.core.JSONSerializerUtilities;
import org.nypl.simplified.reader.api.ReaderColorScheme;
import org.nypl.simplified.reader.api.ReaderFontSelection;
import org.nypl.simplified.reader.api.ReaderPreferences;
import org.nypl.simplified.reader.api.ReaderPublisherCSS;

public final class ReaderPreferencesJSON {
    private ReaderPreferencesJSON() {
        throw new UnreachableCodeException();
    }

    public static ReaderPreferences deserializeFromJSON(ObjectMapper jom, JsonNode node) throws JSONParseException {
        Objects.requireNonNull(jom, "Object mapper");
        Objects.requireNonNull(node, "JSON");
        ObjectNode obj = JSONParserUtilities.checkObject(null, (JsonNode)node);
        double font_scale = JSONParserUtilities.getDoubleDefault((ObjectNode)obj, (String)"font_scale", (double)100.0);
        ReaderFontSelection font_family = ReaderPreferencesJSON.fontFamily(JSONParserUtilities.getStringDefault((ObjectNode)obj, (String)"font_family", (String)ReaderFontSelection.READER_FONT_SANS_SERIF.name()));
        ReaderColorScheme color_scheme = ReaderPreferencesJSON.colorScheme(JSONParserUtilities.getStringDefault((ObjectNode)obj, (String)"color_scheme", (String)ReaderColorScheme.SCHEME_BLACK_ON_WHITE.name()));
        ReaderPublisherCSS css = ReaderPreferencesJSON.publisherCSS(JSONParserUtilities.getStringDefault((ObjectNode)obj, (String)"publisher_css", (String)ReaderPublisherCSS.PUBLISHER_DEFAULT_CSS_DISABLED.name()));
        return ReaderPreferences.builder().setFontScale(font_scale).setFontFamily(font_family).setColorScheme(color_scheme).setPublisherCSS(css).build();
    }

    private static ReaderPublisherCSS publisherCSS(String publisher_css) throws JSONParseException {
        try {
            return ReaderPublisherCSS.valueOf(publisher_css);
        }
        catch (IllegalArgumentException e) {
            throw new JSONParseException("Unparseable publisher CSS", (Throwable)e);
        }
    }

    private static ReaderColorScheme colorScheme(String font_family) throws JSONParseException {
        try {
            return ReaderColorScheme.valueOf(font_family);
        }
        catch (IllegalArgumentException e) {
            throw new JSONParseException("Unparseable color scheme", (Throwable)e);
        }
    }

    private static ReaderFontSelection fontFamily(String font_family) throws JSONParseException {
        try {
            return ReaderFontSelection.valueOf(font_family);
        }
        catch (IllegalArgumentException e) {
            throw new JSONParseException("Unparseable font family", (Throwable)e);
        }
    }

    public static ObjectNode serializeToJSON(ObjectMapper jom, ReaderPreferences description) {
        Objects.requireNonNull(jom, "Object mapper");
        Objects.requireNonNull(description, "Description");
        ObjectNode jo = jom.createObjectNode();
        jo.put("font_scale", description.fontScale());
        jo.put("font_family", description.fontFamily().name());
        jo.put("color_scheme", description.colorScheme().name());
        jo.put("publisher_css", description.publisherCSS().name());
        return jo;
    }

    public static String serializeToString(ObjectMapper jom, ReaderPreferences description) throws IOException {
        ObjectNode jo = ReaderPreferencesJSON.serializeToJSON(jom, description);
        ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
        JSONSerializerUtilities.serialize((ObjectNode)jo, (OutputStream)bao);
        return bao.toString("UTF-8");
    }
}

