/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.reader.api;

import org.nypl.simplified.reader.api.ReaderColorScheme;
import org.nypl.simplified.reader.api.ReaderFontSelection;
import org.nypl.simplified.reader.api.ReaderPreferences;

final class AutoValue_ReaderPreferences
extends ReaderPreferences {
    private final ReaderColorScheme colorScheme;
    private final ReaderFontSelection fontFamily;
    private final double fontScale;
    private final double brightness;

    private AutoValue_ReaderPreferences(ReaderColorScheme colorScheme, ReaderFontSelection fontFamily, double fontScale, double brightness) {
        this.colorScheme = colorScheme;
        this.fontFamily = fontFamily;
        this.fontScale = fontScale;
        this.brightness = brightness;
    }

    @Override
    public ReaderColorScheme colorScheme() {
        return this.colorScheme;
    }

    @Override
    public ReaderFontSelection fontFamily() {
        return this.fontFamily;
    }

    @Override
    public double fontScale() {
        return this.fontScale;
    }

    @Override
    public double brightness() {
        return this.brightness;
    }

    public String toString() {
        return "ReaderPreferences{colorScheme=" + (Object)((Object)this.colorScheme) + ", fontFamily=" + (Object)((Object)this.fontFamily) + ", fontScale=" + this.fontScale + ", brightness=" + this.brightness + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReaderPreferences) {
            ReaderPreferences that = (ReaderPreferences)o;
            return this.colorScheme.equals((Object)that.colorScheme()) && this.fontFamily.equals((Object)that.fontFamily()) && Double.doubleToLongBits(this.fontScale) == Double.doubleToLongBits(that.fontScale()) && Double.doubleToLongBits(this.brightness) == Double.doubleToLongBits(that.brightness());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.colorScheme.hashCode();
        h$ *= 1000003;
        h$ ^= this.fontFamily.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.fontScale) >>> 32 ^ Double.doubleToLongBits(this.fontScale));
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.brightness) >>> 32 ^ Double.doubleToLongBits(this.brightness));
    }

    @Override
    public ReaderPreferences.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ReaderPreferences.Builder {
        private ReaderColorScheme colorScheme;
        private ReaderFontSelection fontFamily;
        private Double fontScale;
        private Double brightness;

        Builder() {
        }

        private Builder(ReaderPreferences source) {
            this.colorScheme = source.colorScheme();
            this.fontFamily = source.fontFamily();
            this.fontScale = source.fontScale();
            this.brightness = source.brightness();
        }

        @Override
        public ReaderPreferences.Builder setColorScheme(ReaderColorScheme colorScheme) {
            if (colorScheme == null) {
                throw new NullPointerException("Null colorScheme");
            }
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public ReaderPreferences.Builder setFontFamily(ReaderFontSelection fontFamily) {
            if (fontFamily == null) {
                throw new NullPointerException("Null fontFamily");
            }
            this.fontFamily = fontFamily;
            return this;
        }

        @Override
        public ReaderPreferences.Builder setFontScale(double fontScale) {
            this.fontScale = fontScale;
            return this;
        }

        @Override
        public double fontScale() {
            if (this.fontScale == null) {
                throw new IllegalStateException("Property \"fontScale\" has not been set");
            }
            return this.fontScale;
        }

        @Override
        public ReaderPreferences.Builder setBrightness(double brightness) {
            this.brightness = brightness;
            return this;
        }

        @Override
        public double brightness() {
            if (this.brightness == null) {
                throw new IllegalStateException("Property \"brightness\" has not been set");
            }
            return this.brightness;
        }

        @Override
        ReaderPreferences autoBuild() {
            String missing = "";
            if (this.colorScheme == null) {
                missing = missing + " colorScheme";
            }
            if (this.fontFamily == null) {
                missing = missing + " fontFamily";
            }
            if (this.fontScale == null) {
                missing = missing + " fontScale";
            }
            if (this.brightness == null) {
                missing = missing + " brightness";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ReaderPreferences(this.colorScheme, this.fontFamily, this.fontScale, this.brightness);
        }
    }
}

