/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.reader.api;

import com.google.auto.value.AutoValue;
import org.nypl.simplified.reader.api.AutoValue_ReaderPreferences;
import org.nypl.simplified.reader.api.ReaderColorScheme;
import org.nypl.simplified.reader.api.ReaderFontSelection;

@AutoValue
public abstract class ReaderPreferences {
    public static Builder builder() {
        AutoValue_ReaderPreferences.Builder builder = new AutoValue_ReaderPreferences.Builder();
        ((Builder)builder).setColorScheme(ReaderColorScheme.SCHEME_BLACK_ON_WHITE);
        ((Builder)builder).setFontFamily(ReaderFontSelection.READER_FONT_SANS_SERIF);
        ((Builder)builder).setBrightness(1.0);
        ((Builder)builder).setFontScale(100.0);
        return builder;
    }

    public abstract ReaderColorScheme colorScheme();

    public abstract ReaderFontSelection fontFamily();

    public abstract double fontScale();

    public abstract Builder toBuilder();

    public abstract double brightness();

    public static abstract class Builder {
        public abstract Builder setColorScheme(ReaderColorScheme var1);

        public abstract Builder setFontFamily(ReaderFontSelection var1);

        public abstract Builder setFontScale(double var1);

        public abstract Builder setBrightness(double var1);

        public abstract double brightness();

        public abstract double fontScale();

        public final ReaderPreferences build() {
            this.setFontScale(Math.min(200.0, Math.max(50.0, this.fontScale())));
            this.setBrightness(Math.min(1.0, Math.max(0.0, this.brightness())));
            return this.autoBuild();
        }

        abstract ReaderPreferences autoBuild();
    }
}

