/* Copyright (c) 2022 LibJ
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * You should have received a copy of The MIT License (MIT) along with this
 * program. If not, see <http://opensource.org/licenses/MIT/>.
 */

package org.libj.util;

import java.util.NoSuchElementException;

import org.libj.util.primitive.IntIterator;

public class SequenceIntIterator implements IntIterator {
  protected int start;
  protected final int end;
  protected final int step;

  public SequenceIntIterator(final int start, final int end, final int step) {
    this.start = start;
    this.end = end;
    this.step = step;
    if (step > 0) {
      if (start >= end)
        throw new IllegalArgumentException("start (" + start + ") must be less than end (" + end + ") with a positive step (" + step + ")");
    }
    else if (step < 0) {
      if (start <= end)
        throw new IllegalArgumentException("end (" + end + ") must be less than start (" + start + ") with a negative step (" + step + ")");
    }
    else {
      throw new IllegalArgumentException("step must not be 0");
    }

    this.start -= step;
  }

  @Override
  public boolean hasNext() {
    return step > 0 ? start < end : end < start;
  }

  @Override
  public int next() {
    if (!hasNext())
      throw new NoSuchElementException();

    return start += step;
  }
}