/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net.classpath;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import org.libj.net.ClasspathURLStreamHandler;

public class Handler
extends ClasspathURLStreamHandler {
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!"classpath".equals(url.getProtocol())) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        String resourcePath = url.toString().substring(12);
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            throw new FileNotFoundException(resourcePath);
        }
        return resourceUrl.openConnection();
    }

    public static class Factory
    implements URLStreamHandlerFactory {
        private static Handler handler;

        @Override
        public Handler createURLStreamHandler(String protocol) {
            return !"classpath".equals(protocol) ? null : (handler == null ? (handler = new Handler()) : handler);
        }
    }
}

