/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class URIComponent {
    public static String decode(String uri) {
        try {
            return URIComponent.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String decode(String uri, String enc) throws UnsupportedEncodingException {
        return uri != null ? URLDecoder.decode(uri, enc) : null;
    }

    public static String encode(String uri) {
        try {
            return URIComponent.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String encode(char ch) {
        try {
            return URIComponent.encode(ch, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String encode(String uri, String enc) throws UnsupportedEncodingException {
        return uri == null ? null : URLEncoder.encode(uri, enc).replace("+", "%20");
    }

    public static String encode(char ch, String enc) throws UnsupportedEncodingException {
        return URIComponent.encode(String.valueOf(ch), enc);
    }

    private URIComponent() {
    }
}

