/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.util.Collection;
import java.util.Objects;
import org.libj.util.CollectionUtil;

public class Service {
    private final String serviceName;
    private final int port;
    private final Collection<String> aliases;

    protected Service(String serviceName, int port, Collection<String> aliases) {
        this.serviceName = serviceName;
        this.port = port;
        this.aliases = aliases;
    }

    public String getName() {
        return this.serviceName;
    }

    public int getPort() {
        return this.port;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service that = (Service)obj;
        if (this.port != that.port) {
            return false;
        }
        if (!Objects.equals(this.serviceName, that.serviceName)) {
            return false;
        }
        return Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.serviceName != null) {
            hashCode = 31 * hashCode + this.serviceName.hashCode();
        }
        if (this.aliases != null) {
            hashCode = 31 * hashCode + this.aliases.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        String alias = CollectionUtil.toString(this.aliases, (String)"\", \"");
        return "{\n  name: \"" + this.serviceName + "\",\n  port: " + this.port + ",\n  aliases: [" + (alias.length() > 0 ? "\"" + alias + "\"" : "") + "]\n}";
    }
}

