/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.libj.net.Cookies;
import org.libj.net.URLConnections;
import org.libj.util.function.ThrowingConsumer;

public final class HTTP {
    public static URL get(String url, Map<String, String[]> parameters) throws IOException {
        return HTTP.get(url, parameters, "UTF-8");
    }

    public static InputStream getAsStream(String url, Map<String, String[]> parameters) throws IOException {
        return HTTP.getAsStream(url, parameters, "UTF-8");
    }

    public static InputStream getAsStream(String url, Map<String, String[]> parameters, String charset) throws IOException, UnsupportedEncodingException {
        return URLConnections.checkFollowRedirect(HTTP.get(url, parameters, charset).openConnection(), (ThrowingConsumer<HttpURLConnection, IOException>)((ThrowingConsumer)c -> c.setUseCaches(false))).getInputStream();
    }

    public static InputStream getAsStream(URL url) throws IOException, UnsupportedEncodingException {
        return URLConnections.checkFollowRedirect(url.openConnection(), (ThrowingConsumer<HttpURLConnection, IOException>)((ThrowingConsumer)c -> c.setUseCaches(false))).getInputStream();
    }

    public static URL get(String url, Map<String, String[]> parameters, String charset) throws IOException, UnsupportedEncodingException {
        return new URL(url + "?" + HTTP.createQuery(parameters, charset));
    }

    public static InputStream postAsStream(URL url, Map<String, String[]> parameters) throws IOException {
        return HTTP.postAsStream(url, parameters, null);
    }

    public static InputStream postAsStream(URL url, Map<String, String[]> parameters, Properties properties) throws IOException {
        return HTTP.postAsStream(url, parameters, properties, null);
    }

    public static InputStream postAsStream(URL url, Map<String, String[]> parameters, Properties properties, List<String> cookies) throws IOException {
        String charset;
        String string = charset = properties != null ? properties.getProperty("accept-charset") : null;
        if (charset == null) {
            charset = "UTF-8";
        }
        String query = HTTP.createQuery(parameters, charset);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                urlConnection.setRequestProperty((String)property.getKey(), (String)property.getValue());
            }
        }
        if (cookies != null) {
            Map.Entry<String, String> cookie = Cookies.createCookieHeader(cookies);
            urlConnection.setRequestProperty(cookie.getKey(), cookie.getValue());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream());){
            writer.write(query);
        }
        return urlConnection.getInputStream();
    }

    public static String createQuery(Map<String, String[]> parameters, String charset) throws UnsupportedEncodingException {
        if (parameters == null || parameters.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> iterator = parameters.entrySet().iterator();
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String name = entry.getKey();
            String[] values = entry.getValue();
            if (i > 0) {
                builder.append('&');
            }
            int j$ = values.length;
            for (int j = 0; j < j$; ++j) {
                if (j > 0) {
                    temp.append('&');
                }
                temp.append(URLEncoder.encode(name, charset));
                temp.append('=');
                temp.append(URLEncoder.encode(values[j], charset));
            }
            builder.append((CharSequence)temp);
            temp.setLength(0);
            ++i;
        }
        return builder.toString();
    }

    private HTTP() {
    }
}

