/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.Serializable;
import java.util.Base64;
import java.util.Objects;
import org.libj.lang.Strings;

public abstract class AuthScheme
implements Serializable {
    private final String name;
    private final int len;

    public static AuthScheme parse(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (Basic.prototype.matches(authorization)) {
            return Basic.prototype.newInstance(authorization);
        }
        if (Bearer.prototype.matches(authorization)) {
            return Bearer.prototype.newInstance(authorization);
        }
        return null;
    }

    private AuthScheme(String name) {
        this.name = name;
        this.len = name.length();
    }

    public final boolean matches(String authorization) {
        return authorization != null && authorization.length() > this.len && authorization.charAt(this.len) == ' ' && Strings.regionMatches((CharSequence)authorization, (boolean)true, (int)0, (CharSequence)this.name, (int)0, (int)this.len);
    }

    public abstract String encode();

    abstract AuthScheme newInstance(String var1);

    public static class Bearer
    extends AuthScheme {
        private static final String name = "Bearer";
        private static final Bearer prototype = new Bearer();
        private final String token;

        public static String encode(String token) {
            return "Bearer " + Base64.getEncoder().encodeToString(token.getBytes());
        }

        public static Bearer decode(String authorization) {
            return prototype.matches(Objects.requireNonNull(authorization)) ? new Bearer(new String(Base64.getDecoder().decode(authorization.substring(7)))) : null;
        }

        public Bearer(String token) {
            super(name);
            this.token = Objects.requireNonNull(token);
        }

        private Bearer() {
            super(name);
            this.token = null;
        }

        public String getToken() {
            return this.token;
        }

        @Override
        public String encode() {
            return Bearer.encode(this.token);
        }

        @Override
        Bearer newInstance(String authorization) {
            return Bearer.decode(authorization);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Bearer)) {
                return false;
            }
            return Objects.equals(this.token, ((Bearer)obj).token);
        }

        public int hashCode() {
            int hashCode = 1;
            if (this.token != null) {
                hashCode = 31 * hashCode + this.token.hashCode();
            }
            return hashCode;
        }
    }

    public static class Basic
    extends AuthScheme {
        private static final String name = "Basic";
        private static final Basic prototype = new Basic();
        private final String username;
        private final String password;

        public static String encode(String username, String password) {
            return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        }

        public static Basic decode(String authorization) {
            if (!prototype.matches(Objects.requireNonNull(authorization))) {
                return null;
            }
            String login = new String(Base64.getDecoder().decode(authorization.substring(6)));
            int index = login.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("Authorization header is malformed: missing ':'");
            }
            return new Basic(login.substring(0, index), login.substring(index + 1));
        }

        public Basic(String username, String password) {
            super(name);
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
        }

        private Basic() {
            super(name);
            this.username = null;
            this.password = null;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        @Override
        public String encode() {
            return Basic.encode(this.username, this.password);
        }

        @Override
        Basic newInstance(String authorization) {
            return Basic.decode(authorization);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Basic)) {
                return false;
            }
            Basic that = (Basic)obj;
            if (!Objects.equals(this.username, that.username)) {
                return false;
            }
            return Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            int hashCode = 1;
            if (this.username != null) {
                hashCode = 31 * hashCode + this.username.hashCode();
            }
            if (this.password != null) {
                hashCode = 31 * hashCode + this.password.hashCode();
            }
            return hashCode;
        }
    }
}

