/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

class SimpleTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final Types typeUtils;
    private final TemplateConfiguration configuration;
    private final TypeNodeFactory typeNodeFactory;
    private final TypeMirror objectMirror;

    SimpleTypeNodeFactory() {
        this.typeUtils = null;
        this.configuration = null;
        this.typeNodeFactory = null;
        this.objectMirror = null;
    }

    private SimpleTypeNodeFactory(TypeNodeFactory typeNodeFactory, Types typeUtils, Elements elementUtils, TemplateConfiguration configuration) {
        this.typeNodeFactory = typeNodeFactory;
        this.configuration = configuration;
        this.typeUtils = typeUtils;
        this.objectMirror = TypeNodeUtils.getObjectMirror(elementUtils);
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new SimpleTypeNodeFactory(typeNodeFactory, typeUtils, elementUtils, configuration);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, DeclaredType containingType) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        TypeScriptType typeScriptTypeAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, TypeScriptType.class, this.typeUtils);
        String typeName = TypeNodeUtils.defineName(typeMirror, typeScriptTypeAnnotation, this::defineNameFromSimpleType);
        return new SimpleTypeNode(optional, fieldName, parameterName, typeName, this.defineVariableType(typeName, typeMirror), this.defineTypeParameters(typeMirror), TypeNodeUtils.defineTemplate(this.configuration.getInterfaceTemplate(), typeScriptTypeAnnotation, typeElement), this.typeNodeFactory.defineChildren(typeElement, (DeclaredType)typeMirror));
    }

    private List<TypeNode> defineTypeParameters(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.stream().map(t -> t.getKind().equals((Object)TypeKind.WILDCARD) ? this.objectMirror : t).map(this.typeNodeFactory::createTypeNode).collect(Collectors.toList());
    }

    private String defineVariableType(String typeName, TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> variableTypeArguments = ((DeclaredType)declaredType.asElement().asType()).getTypeArguments();
        String variableType = variableTypeArguments.isEmpty() ? typeName : typeName + variableTypeArguments.stream().map(it -> ((TypeVariable)it).asElement().getSimpleName().toString()).collect(Collectors.joining(", ", "<", ">"));
        return variableType;
    }

    private String defineNameFromSimpleType(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        String typeName = TypeKind.DECLARED.equals((Object)kind) ? this.typeUtils.asElement(typeMirror).getSimpleName().toString() : "UNDEFINED";
        return typeName;
    }

    class SimpleTypeNode
    extends TypeNode {
        private final String fieldName;
        private final String parameterName;
        private final String typeName;
        private final String type;
        private final String variableType;
        private final String template;
        private final List<TypeNode> typeParameters;
        private final List<TypeNode> children;
        private Set<TypeNode> imports;
        private Set<TypeNode> types;

        SimpleTypeNode(boolean optional, String fieldName, String parameterName, String typeName, String variableType, List<TypeNode> typeParameters, String template, List<TypeNode> children) {
            super(optional);
            this.fieldName = fieldName;
            this.parameterName = parameterName;
            this.typeName = typeName;
            this.variableType = variableType;
            this.typeParameters = typeParameters;
            this.template = template;
            this.children = children;
            this.type = this.defineType();
        }

        private String defineType() {
            String name;
            if (this.typeParameters.isEmpty()) {
                name = this.typeName;
            } else {
                String parameters = this.typeParameters.stream().map(TypeNode::getType).collect(Collectors.joining(", ", "<", ">"));
                name = this.typeName + parameters;
            }
            return name;
        }

        private Set<TypeNode> collectImports() {
            HashSet nodesSet = new HashSet(this.children.size() + 5);
            this.children.stream().filter(it -> !it.isMappedType()).filter(it -> !this.getTypeName().equals(it.getTypeName())).flatMap(it -> it.getTypes().stream()).forEach(nodesSet::add);
            return Collections.unmodifiableSet(nodesSet);
        }

        private Set<TypeNode> collectTypes() {
            HashSet<TypeNode> nodesSet = new HashSet<TypeNode>(this.getImports().size() + 5);
            nodesSet.add(this);
            nodesSet.addAll(this.getImports());
            return nodesSet;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }

        @Override
        public List<TypeNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.SIMPLE;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public Set<TypeNode> getTypes() {
            if (this.types == null) {
                this.types = this.collectTypes();
            }
            return this.types;
        }

        @Override
        public Set<TypeNode> getImports() {
            if (this.imports == null) {
                this.imports = this.collectImports();
            }
            return this.imports;
        }

        @Override
        public String getVariableType() {
            return this.variableType;
        }
    }
}

