/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

final class EnumTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final TemplateConfiguration configuration;
    private final Types typeUtils;

    EnumTypeNodeFactory() {
        this.typeUtils = null;
        this.configuration = null;
        this.typeNodeFactory = null;
    }

    private EnumTypeNodeFactory(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils) {
        this.typeNodeFactory = typeNodeFactory;
        this.configuration = configuration;
        this.typeUtils = typeUtils;
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new EnumTypeNodeFactory(typeNodeFactory, configuration, typeUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, DeclaredType containingType) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        TypeScriptType typeScriptTypeAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, TypeScriptType.class, this.typeUtils);
        return new EnumTypeNode(optional, fieldName, parameterName, TypeNodeUtils.defineName(typeMirror, typeScriptTypeAnnotation, this::defineNameForEnumType), TypeNodeUtils.defineTemplate(this.configuration.getEnumTemplate(), typeScriptTypeAnnotation, typeElement), this.typeNodeFactory.defineChildren(typeElement, (DeclaredType)typeMirror), this.defineEnumValues(typeMirror));
    }

    private String defineNameForEnumType(TypeMirror typeMirror) {
        return this.typeUtils.asElement(typeMirror).getSimpleName().toString();
    }

    private Set<EnumValue> defineEnumValues(TypeMirror typeMirror) {
        Element enumElement = this.typeUtils.asElement(typeMirror);
        if (enumElement == null) {
            return Collections.emptySet();
        }
        return enumElement.getEnclosedElements().stream().filter(e -> ElementKind.ENUM_CONSTANT.equals((Object)e.getKind())).map(e -> new EnumValue(e.getSimpleName().toString())).collect(Collectors.toSet());
    }

    private final class EnumTypeNode
    extends TypeNode {
        private final String fieldName;
        private final String parameterName;
        private final String typeName;
        private final String template;
        private final List<TypeNode> children;
        private final Set<TypeNode> imports;
        private final Set<TypeNode> types;
        private final Set<EnumValue> enumValues;

        private EnumTypeNode(boolean optional, String fieldName, String parameterName, String typeName, String template, List<TypeNode> children, Set<EnumValue> enumValues) {
            super(optional);
            this.fieldName = fieldName;
            this.parameterName = parameterName;
            this.typeName = typeName;
            this.template = template;
            this.children = children;
            this.enumValues = enumValues;
            this.imports = this.collectImports();
            this.types = this.collectTypes();
        }

        private Set<TypeNode> collectImports() {
            HashSet nodesSet = new HashSet(this.children.size() + 5);
            this.children.stream().filter(it -> !it.isMappedType()).flatMap(it -> it.getTypes().stream()).forEach(nodesSet::add);
            return Collections.unmodifiableSet(nodesSet);
        }

        private Set<TypeNode> collectTypes() {
            HashSet<TypeNode> nodesSet = new HashSet<TypeNode>(this.imports.size() + 5);
            nodesSet.add(this);
            nodesSet.addAll(this.imports);
            return nodesSet;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getType() {
            return this.getTypeName();
        }

        @Override
        public String getTemplate() {
            return this.template;
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.ENUM;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return Collections.emptyList();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.children;
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.types;
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.imports;
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.enumValues;
        }
    }
}

