/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.model.typefactories.MissingConfigurationTemplateException;

public class TypeNodeUtils {
    static final String NO_TEMPLATE = "NO_TEMPLATE";
    static final String UNDEFINED_TYPE_NAME = "UNDEFINED";
    static final String JAVA_LANG_OBJECT = "java.lang.Object";
    static TypeMirror objectMirror;

    public static <A extends Annotation> A getAnnotationForClass(TypeMirror typeMirror, Class<A> annotation, Types typeUtils) {
        TypeKind kind = typeMirror.getKind();
        TypeMirror realMirror = TypeKind.ARRAY.equals((Object)kind) ? ((ArrayType)typeMirror).getComponentType() : typeMirror;
        Element definingElement = typeUtils.asElement(realMirror);
        return definingElement != null ? (A)definingElement.getAnnotation(annotation) : null;
    }

    static String defineTemplate(String typeNodeTemplate, TypeScriptType typeScriptTypeAnnotation, Element element) {
        if (typeNodeTemplate == null || typeNodeTemplate.isEmpty()) {
            throw new MissingConfigurationTemplateException("TemplateConfiguration is null while processing Element", element);
        }
        String template = typeScriptTypeAnnotation == null || typeScriptTypeAnnotation.template().isEmpty() ? typeNodeTemplate : typeScriptTypeAnnotation.template();
        return template;
    }

    static String defineName(TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation, Function<TypeMirror, String> nameFunction) {
        String typeFromAnnotation = TypeNodeUtils.defineTypeFromAnnotation(typeScriptTypeAnnotation);
        if (!UNDEFINED_TYPE_NAME.equals(typeFromAnnotation)) {
            return typeFromAnnotation;
        }
        return nameFunction.apply(typeMirror);
    }

    static TypeMirror getObjectMirror(Elements elementUtils) {
        if (objectMirror == null) {
            objectMirror = elementUtils.getTypeElement(JAVA_LANG_OBJECT).asType();
        }
        return objectMirror;
    }

    private static String defineTypeFromAnnotation(TypeScriptType annotation) {
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return UNDEFINED_TYPE_NAME;
    }
}

