/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

final class MapTypeNodeFactory
implements ConcreteTypeNodeFactory {
    private final TypeNodeFactory typeNodeFactory;
    private final Types typeUtils;
    private final TypeMirror objectMirror;

    MapTypeNodeFactory() {
        this.typeUtils = null;
        this.typeNodeFactory = null;
        this.objectMirror = null;
    }

    private MapTypeNodeFactory(TypeNodeFactory typeNodeFactory, Types typeUtils, Elements elementUtils) {
        this.typeNodeFactory = typeNodeFactory;
        this.typeUtils = typeUtils;
        this.objectMirror = TypeNodeUtils.getObjectMirror(elementUtils);
    }

    @Override
    public ConcreteTypeNodeFactory newConfiguredInstance(TypeNodeFactory typeNodeFactory, TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        return new MapTypeNodeFactory(typeNodeFactory, typeUtils, elementUtils);
    }

    @Override
    public TypeNode createTypeNode(String fieldName, String parameterName, boolean optional, TypeMirror typeMirror, TypeMirror containingType) {
        List<TypeNode> typeParameters = this.defineTypeParameters(typeMirror, containingType);
        TypeScriptType typeScriptTypeAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, TypeScriptType.class, this.typeUtils);
        String typeName = TypeNodeUtils.defineName(typeMirror, typeScriptTypeAnnotation, it -> this.defineNameFromMapType(typeParameters));
        return new MapTypeNode(optional, fieldName, parameterName, typeName, typeParameters);
    }

    private List<TypeNode> defineTypeParameters(TypeMirror typeMirror, TypeMirror containingType) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        List<TypeNode> typeParameters = typeArguments.stream().map(it -> it.getKind().equals((Object)TypeKind.WILDCARD) ? this.objectMirror : it).map(it -> this.typeNodeFactory.createTypeNode((TypeMirror)it, containingType)).collect(Collectors.toList());
        if (typeParameters.isEmpty()) {
            typeParameters.add(this.typeNodeFactory.createTypeNode(this.objectMirror));
            typeParameters.add(this.typeNodeFactory.createTypeNode(this.objectMirror));
        }
        return typeParameters;
    }

    private String defineNameFromMapType(List<TypeNode> typeParameters) {
        TypeNode key = typeParameters.get(0);
        TypeNode value = typeParameters.get(1);
        String keyName = key.getTypeName();
        String valueName = value.getTypeName();
        return keyName + "/" + valueName;
    }

    class MapTypeNode
    extends TypeNode {
        private final String fieldName;
        private final String parameterName;
        private final String typeName;
        private final String type;
        private final List<TypeNode> typeParameters;
        private final Set<TypeNode> imports;
        private final Set<TypeNode> types;

        MapTypeNode(boolean optional, String fieldName, String parameterName, String typeName, List<TypeNode> typeParameters) {
            super(optional);
            this.fieldName = fieldName;
            this.parameterName = parameterName;
            this.typeName = typeName;
            this.type = "{ [index: " + typeParameters.get(0).getType() + "]: " + typeParameters.get(1).getType() + " }";
            this.typeParameters = typeParameters;
            this.imports = typeParameters.stream().filter(it -> !it.isMappedType()).flatMap(it -> it.getImports().stream()).collect(Collectors.toSet());
            this.types = typeParameters.stream().filter(it -> !it.isMappedType()).flatMap(it -> it.getTypes().stream()).collect(Collectors.toSet());
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getTemplate() {
            return "NO_TEMPLATE";
        }

        @Override
        public TypeNodeKind getKind() {
            return TypeNodeKind.MAP;
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public List<TypeNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.types;
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.imports;
        }
    }
}

