/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.leandreck.endpoints.annotations.TypeScriptEndpoint;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.model.EndpointNode;
import org.leandreck.endpoints.processor.model.EndpointNodeFactory;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.printer.Engine;
import org.leandreck.endpoints.processor.printer.TypesPackage;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TypeScriptEndpointProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private EndpointNodeFactory factory;
    private Engine engine;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        Types typeUtils = processingEnv.getTypeUtils();
        this.engine = new Engine();
        this.factory = new EndpointNodeFactory(typeUtils, processingEnv.getElementUtils());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(TypeScriptEndpoint.class.getCanonicalName());
        annotations.add(TypeScriptIgnore.class.getCanonicalName());
        annotations.add(TypeScriptType.class.getCanonicalName());
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(TypeScriptEndpoint.class);
        List<TypeElement> endpoints = annotated.stream().filter(element -> ElementKind.CLASS.equals((Object)element.getKind())).map(element -> (TypeElement)element).collect(Collectors.toList());
        if (endpoints.size() > 0) {
            this.processEndpoints(endpoints);
        }
        return true;
    }

    private void processEndpoints(List<TypeElement> endpointElements) {
        Throwable throwable;
        Writer out;
        HashSet<EndpointNode> endpointNodes = new HashSet<EndpointNode>(endpointElements.size());
        for (TypeElement element : endpointElements) {
            EndpointNode endpointNode2 = this.factory.createEndpointNode(element);
            try {
                out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", this.toTSFilename(endpointNode2.getServiceName(), ".generated.ts"), element).openWriter();
                throwable = null;
                try {
                    this.engine.processEndpoint(endpointNode2, out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (TemplateException tex) {
                this.printMessage(element, element.getAnnotationMirrors().stream().findFirst().orElse(null), "Could not process template %s. Cause: %s", endpointNode2.getTemplate(), tex.getMessage());
            }
            catch (IOException ioe) {
                this.printMessage(element, element.getAnnotationMirrors().stream().findFirst().orElse(null), "Could not load template %s. Cause: %s", endpointNode2.getTemplate(), ioe.getMessage());
            }
            endpointNodes.add(endpointNode2);
        }
        Element[] endpointArray = endpointElements.toArray(new TypeElement[endpointElements.size()]);
        Set<TypeNode> typeNodes = endpointNodes.stream().flatMap(endpointNode -> endpointNode.getTypes().stream()).collect(Collectors.toSet());
        TypesPackage typesPackage = new TypesPackage(endpointNodes, typeNodes);
        try {
            out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "index.ts", endpointArray).openWriter();
            throwable = null;
            try {
                this.engine.processIndexTs(typesPackage, out);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (TemplateException tex) {
            this.printMessage("Could not process template index.ts. Cause: %s", tex.getMessage());
        }
        catch (IOException ioe) {
            this.printMessage("Could not load template index.ts. Cause: %s", ioe.getMessage());
        }
        try {
            out = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "api.module.ts", endpointArray).openWriter();
            throwable = null;
            try {
                this.engine.processModuleTs(typesPackage, out);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (TemplateException tex) {
            this.printMessage("Could not process template api.module.ts. Cause: %s", tex.getMessage());
        }
        catch (IOException ioe) {
            this.printMessage("Could not load template api.module.ts. Cause: %s", ioe.getMessage());
        }
        for (TypeNode type : typeNodes) {
            try {
                Writer out2 = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", this.toTSFilename(type.getTypeName(), ".model.generated.ts"), endpointArray).openWriter();
                Throwable throwable8 = null;
                try {
                    this.engine.processTypeScriptTypeNode(type, out2);
                }
                catch (Throwable throwable9) {
                    throwable8 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (out2 == null) continue;
                    if (throwable8 != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable throwable10) {
                            throwable8.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    out2.close();
                }
            }
            catch (TemplateException tex) {
                this.printMessage("Could not process template %s for TypeNode %s. Cause: %s", type.getTemplate(), type.getTypeName(), tex.getMessage());
            }
            catch (IOException ioe) {
                this.printMessage("Could not load template %s for TypeNode %s. Cause: %s", type.getTemplate(), type.getTypeName(), ioe.getMessage());
            }
        }
    }

    private void printMessage(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    private void printMessage(Element element, AnnotationMirror annotationMirror, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), element, annotationMirror);
    }

    private String toTSFilename(String typeName, String suffix) {
        return typeName.toLowerCase() + suffix;
    }
}

