/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.leandreck.endpoints.processor.model.TypeNode;

public class MethodNode {
    private final String name;
    private final String url;
    private final boolean ignored;
    private final TypeNode returnType;
    private final TypeNode requestBodyType;
    private final List<TypeNode> pathVariableTypes;
    private final List<String> httpMethods;
    private final Set<TypeNode> types;

    public MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType) {
        this.name = name;
        this.url = url;
        this.ignored = ignored;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
        this.requestBodyType = null;
        this.pathVariableTypes = Collections.emptyList();
        this.types = this.collectTypes();
    }

    public MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType, TypeNode requestBodyType, List<TypeNode> pathVariableTypes) {
        this.name = name;
        this.ignored = ignored;
        this.url = url;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
        this.requestBodyType = requestBodyType;
        this.pathVariableTypes = pathVariableTypes;
        this.types = this.collectTypes();
    }

    private Set<TypeNode> collectTypes() {
        HashMap<String, TypeNode> typeMap = new HashMap<String, TypeNode>();
        if (this.returnType != null) {
            typeMap.put(this.returnType.getTypeName(), this.returnType);
        }
        if (this.requestBodyType != null) {
            typeMap.put(this.requestBodyType.getTypeName(), this.requestBodyType);
        }
        return new HashSet<TypeNode>(typeMap.values());
    }

    public TypeNode getReturnType() {
        return this.returnType;
    }

    public List<String> getHttpMethods() {
        return Collections.unmodifiableList(this.httpMethods);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getUrl() {
        return this.url;
    }

    public TypeNode getRequestBodyType() {
        return this.requestBodyType;
    }

    public Set<TypeNode> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public List<TypeNode> getPathVariableTypes() {
        return Collections.unmodifiableList(this.pathVariableTypes);
    }
}

