/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeKind;

class TypeNodeFactory {
    private static final Map<String, String> mappings = new HashMap<String, String>(20);
    private static final String NUMBER_TYPE = "number";
    private static final String STRING_TYPE = "string";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String UNDEFINED = "UNDEFINED";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final TypeMirror objectMirror;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Map<String, List<TypeNode>> createdChildren = new ConcurrentHashMap<String, List<TypeNode>>(200);

    public TypeNodeFactory(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.objectMirror = elementUtils.getTypeElement(JAVA_LANG_OBJECT).asType();
    }

    public TypeNode createTypeNode(TypeMirror typeMirror) {
        TypeScriptType typeScriptTypeAnnotation = this.getTypeScriptTypeAnnotation(typeMirror);
        String fieldName = "TYPE-ROOT";
        return this.initType("TYPE-ROOT", typeMirror, typeScriptTypeAnnotation);
    }

    private TypeScriptType getTypeScriptTypeAnnotation(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        TypeMirror realMirror = TypeKind.ARRAY.equals((Object)kind) ? ((ArrayType)typeMirror).getComponentType() : typeMirror;
        Element definingElement = this.typeUtils.asElement(realMirror);
        return definingElement != null ? definingElement.getAnnotation(TypeScriptType.class) : null;
    }

    public TypeNode createTypeNode(VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        TypeScriptType typeScriptTypeAnnotation = this.getTypeScriptTypeAnnotation(typeMirror);
        String fieldName = variableElement.getSimpleName().toString();
        return this.initType(fieldName, typeMirror, typeScriptTypeAnnotation);
    }

    private TypeNode initType(String fieldName, TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation) {
        TypeNode newTypeNode;
        TypeNodeKind typeNodeKind = this.defineKind(typeMirror);
        String typeName = this.defineName(typeMirror, typeNodeKind, typeScriptTypeAnnotation);
        if (mappings.containsValue(typeName)) {
            newTypeNode = new TypeNode(fieldName, typeName, typeNodeKind);
        } else {
            List<TypeNode> typeParameters = this.defineTypeParameters(typeNodeKind, typeMirror);
            List<TypeNode> cachedChildren = this.createdChildren.get(typeName);
            if (cachedChildren != null) {
                String template = TypeNodeFactory.defineTemplate(typeScriptTypeAnnotation);
                newTypeNode = new TypeNode(fieldName, typeName, typeParameters, template, typeNodeKind, cachedChildren);
            } else {
                TypeElement typeElement = this.getDefiningClassElement(typeNodeKind, typeMirror);
                String template = TypeNodeFactory.defineTemplate(typeScriptTypeAnnotation);
                List<String> publicGetter = this.definePublicGetter(typeElement);
                List<TypeNode> children = this.defineChildren(typeElement, publicGetter);
                newTypeNode = new TypeNode(fieldName, typeName, typeParameters, template, typeNodeKind, children);
                this.createdChildren.put(typeName, children);
            }
        }
        return newTypeNode;
    }

    private TypeElement getDefiningClassElement(TypeNodeKind typeNodeKind, TypeMirror typeMirror) {
        TypeMirror realMirror = TypeNodeKind.ARRAY.equals((Object)typeNodeKind) ? ((ArrayType)typeMirror).getComponentType() : typeMirror;
        return (TypeElement)this.typeUtils.asElement(realMirror);
    }

    private List<TypeNode> defineTypeParameters(TypeNodeKind typeNodeKind, TypeMirror typeMirror) {
        List<TypeNode> typeParameters;
        if (TypeNodeKind.COLLECTION.equals((Object)typeNodeKind) || TypeNodeKind.MAP.equals((Object)typeNodeKind)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            typeParameters = typeArguments.stream().map(t -> t.getKind().equals((Object)TypeKind.WILDCARD) ? this.objectMirror : t).map(this::createTypeNode).collect(Collectors.toList());
            if (typeParameters.isEmpty()) {
                typeParameters.add(this.createTypeNode(this.objectMirror));
                if (TypeNodeKind.MAP.equals((Object)typeNodeKind)) {
                    typeParameters.add(this.createTypeNode(this.objectMirror));
                }
            }
        } else {
            typeParameters = Collections.emptyList();
        }
        return typeParameters;
    }

    private List<String> definePublicGetter(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(g -> g.getSimpleName().toString().startsWith("get") || g.getSimpleName().toString().startsWith("is")).filter(g -> g.getModifiers().contains((Object)Modifier.PUBLIC)).filter(g -> !g.getModifiers().contains((Object)Modifier.ABSTRACT)).map(g -> g.getSimpleName().toString()).collect(Collectors.toList());
    }

    private boolean filterVariableElements(VariableElement variableElement, List<String> publicGetter) {
        return publicGetter.stream().map(g -> g.toLowerCase().endsWith(variableElement.getSimpleName().toString().toLowerCase())).reduce(false, (a, b) -> a != false || b != false);
    }

    private List<TypeNode> defineChildren(TypeElement typeElement, List<String> publicGetter) {
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(c -> c.getAnnotation(TypeScriptIgnore.class) == null).filter(c -> !c.getModifiers().contains((Object)Modifier.TRANSIENT)).filter(c -> this.filterVariableElements((VariableElement)c, publicGetter)).map(this::createTypeNode).collect(Collectors.toList());
    }

    private static String defineTemplate(TypeScriptType typeScriptTypeAnnotation) {
        String template = typeScriptTypeAnnotation == null || typeScriptTypeAnnotation.template().isEmpty() ? "/org/leandreck/endpoints/templates/typescript/interface.ftl" : typeScriptTypeAnnotation.template();
        return template;
    }

    private String defineName(TypeMirror typeMirror, TypeNodeKind typeNodeKind, TypeScriptType typeScriptTypeAnnotation) {
        String name;
        String typeFromAnnotation;
        if (typeScriptTypeAnnotation != null && !UNDEFINED.equals(typeFromAnnotation = TypeNodeFactory.defineTypeFromAnnotation(typeScriptTypeAnnotation))) {
            return typeFromAnnotation;
        }
        switch (typeNodeKind) {
            case ARRAY: {
                name = this.defineNameFromArrayType((ArrayType)typeMirror);
                break;
            }
            case COLLECTION: {
                name = this.defineNameFromCollectionType((DeclaredType)typeMirror);
                break;
            }
            case MAP: {
                name = this.defineNameFromMapType((DeclaredType)typeMirror);
                break;
            }
            case SIMPLE: {
                name = this.defineNameFromSimpleType(typeMirror);
                break;
            }
            default: {
                name = this.defineNameFromSimpleType(typeMirror);
            }
        }
        return name;
    }

    private static String defineTypeFromAnnotation(TypeScriptType annotation) {
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return UNDEFINED;
    }

    private String defineNameFromSimpleType(TypeMirror typeMirror) {
        String key;
        String mappedValue;
        TypeKind kind = typeMirror.getKind();
        String typeName = kind.isPrimitive() || TypeKind.VOID.equals((Object)kind) ? mappings.get(kind.name()) : (TypeKind.DECLARED.equals((Object)kind) ? ((mappedValue = mappings.get(key = this.typeUtils.asElement(typeMirror).getSimpleName().toString())) == null ? "I" + key : mappedValue) : UNDEFINED);
        return typeName;
    }

    private String defineNameFromArrayType(ArrayType arrayMirror) {
        TypeMirror componentMirror = arrayMirror.getComponentType();
        return this.defineNameFromSimpleType(componentMirror);
    }

    private String defineNameFromCollectionType(DeclaredType declaredType) {
        TypeMirror genericMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        TypeElement listElement = typeArguments.isEmpty() ? this.elementUtils.getTypeElement(JAVA_LANG_OBJECT) : (TypeKind.WILDCARD.equals((Object)(genericMirror = typeArguments.get(0)).getKind()) ? this.elementUtils.getTypeElement(JAVA_LANG_OBJECT) : (TypeElement)this.typeUtils.asElement(genericMirror));
        return this.defineNameFromSimpleType(listElement.asType());
    }

    private String defineNameFromMapType(DeclaredType declaredType) {
        TypeElement valueElement;
        TypeElement keyElement;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            keyElement = this.elementUtils.getTypeElement(JAVA_LANG_OBJECT);
            valueElement = this.elementUtils.getTypeElement(JAVA_LANG_OBJECT);
        } else {
            TypeMirror keyMirror = typeArguments.get(0);
            keyElement = TypeKind.WILDCARD.equals((Object)keyMirror.getKind()) ? this.elementUtils.getTypeElement(JAVA_LANG_OBJECT) : (TypeElement)this.typeUtils.asElement(keyMirror);
            TypeMirror valueMirror = typeArguments.get(1);
            valueElement = TypeKind.WILDCARD.equals((Object)valueMirror.getKind()) ? this.elementUtils.getTypeElement(JAVA_LANG_OBJECT) : (TypeElement)this.typeUtils.asElement(valueMirror);
        }
        String keyName = this.defineNameFromSimpleType(keyElement.asType());
        String valueName = this.defineNameFromSimpleType(valueElement.asType());
        return keyName + "/" + valueName;
    }

    private TypeNodeKind defineKind(TypeMirror typeMirror) {
        TypeNodeKind typeNodeKind;
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case ARRAY: {
                typeNodeKind = TypeNodeKind.ARRAY;
                break;
            }
            case DECLARED: {
                TypeMirror collectionMirror = this.elementUtils.getTypeElement("java.util.Collection").asType();
                DeclaredType mapMirror = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Map"), new TypeMirror[0]);
                if (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(collectionMirror))) {
                    typeNodeKind = TypeNodeKind.COLLECTION;
                    break;
                }
                if (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(mapMirror))) {
                    typeNodeKind = TypeNodeKind.MAP;
                    break;
                }
                typeNodeKind = TypeNodeKind.SIMPLE;
                break;
            }
            default: {
                typeNodeKind = TypeNodeKind.SIMPLE;
            }
        }
        return typeNodeKind;
    }

    static {
        mappings.put("VOID", "void");
        mappings.put("BYTE", NUMBER_TYPE);
        mappings.put("Byte", NUMBER_TYPE);
        mappings.put("SHORT", NUMBER_TYPE);
        mappings.put("Short", NUMBER_TYPE);
        mappings.put("INT", NUMBER_TYPE);
        mappings.put("Integer", NUMBER_TYPE);
        mappings.put("LONG", NUMBER_TYPE);
        mappings.put("Long", NUMBER_TYPE);
        mappings.put("FLOAT", NUMBER_TYPE);
        mappings.put("Float", NUMBER_TYPE);
        mappings.put("DOUBLE", NUMBER_TYPE);
        mappings.put("Double", NUMBER_TYPE);
        mappings.put("BigDecimal", NUMBER_TYPE);
        mappings.put("BigInteger", NUMBER_TYPE);
        mappings.put("CHAR", STRING_TYPE);
        mappings.put("Character", STRING_TYPE);
        mappings.put("String", STRING_TYPE);
        mappings.put("BOOLEAN", BOOLEAN_TYPE);
        mappings.put("Boolean", BOOLEAN_TYPE);
        mappings.put("Date", "Date");
        mappings.put("LocalDate", "Date");
        mappings.put("Object", "any");
    }
}

