/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.List;
import org.leandreck.endpoints.processor.model.TypeNodeKind;

public class TypeNode {
    private final String fieldName;
    private final String typeName;
    private final String type;
    private final String template;
    private final boolean mappedType;
    private final TypeNodeKind kind;
    private final List<TypeNode> children;

    public TypeNode(String fieldName, String typeName, TypeNodeKind kind) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.kind = kind;
        this.template = "";
        this.children = Collections.emptyList();
        this.mappedType = true;
        this.type = this.defineType();
    }

    public TypeNode(String fieldName, String typeName, String template, TypeNodeKind kind, List<TypeNode> children) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.template = template;
        this.kind = kind;
        this.children = children;
        this.mappedType = false;
        this.type = this.defineType();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private String defineType() {
        String name;
        switch (this.kind) {
            case SIMPLE: {
                name = this.typeName;
                break;
            }
            case ARRAY: 
            case COLLECTION: {
                name = this.typeName + "[]";
                break;
            }
            case MAP: {
                String[] types = this.typeName.split("/");
                String keyName = this.mappedType ? "I" + types[0] : types[0];
                String valueName = this.mappedType ? "I" + types[1] : types[1];
                name = "{ [index: " + keyName + "]: " + valueName + " }";
                break;
            }
            default: {
                name = this.typeName;
            }
        }
        return name;
    }

    public String getTemplate() {
        return this.template;
    }

    public List<TypeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public TypeNodeKind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMappedType() {
        return this.mappedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeNode typeNode = (TypeNode)o;
        return this.typeName.equals(typeNode.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }
}

